/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.codahale.metrics.annotation.Counted;
import com.codahale.metrics.annotation.Metered;
import com.codahale.metrics.annotation.Timed;
import com.google.common.base.Predicate;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.annotation.Resource;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AcceptAnyAuthenticationPolicyFactory;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.ContextualAuthenticationPolicy;
import org.jasig.cas.authentication.ContextualAuthenticationPolicyFactory;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.PrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServiceContext;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.AbstractTicketException;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.UnsatisfiedAuthenticationPolicyException;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

public abstract class AbstractCentralAuthenticationService
implements CentralAuthenticationService,
Serializable,
ApplicationEventPublisherAware {
    private static final long serialVersionUID = -7572316677901391166L;
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    protected ApplicationEventPublisher eventPublisher;
    @Resource(name="ticketRegistry")
    protected TicketRegistry ticketRegistry;
    @Resource(name="servicesManager")
    protected ServicesManager servicesManager;
    @Resource(name="logoutManager")
    protected LogoutManager logoutManager;
    @Resource(name="defaultTicketFactory")
    protected TicketFactory ticketFactory;
    @Resource(name="authenticationPolicyFactory")
    protected ContextualAuthenticationPolicyFactory<ServiceContext> serviceContextAuthenticationPolicyFactory = new AcceptAnyAuthenticationPolicyFactory();
    protected PrincipalFactory principalFactory = new DefaultPrincipalFactory();

    protected AbstractCentralAuthenticationService() {
    }

    public AbstractCentralAuthenticationService(TicketRegistry ticketRegistry, TicketFactory ticketFactory, ServicesManager servicesManager, LogoutManager logoutManager) {
        this.ticketRegistry = ticketRegistry;
        this.servicesManager = servicesManager;
        this.logoutManager = logoutManager;
        this.ticketFactory = ticketFactory;
    }

    public final void setServiceContextAuthenticationPolicyFactory(ContextualAuthenticationPolicyFactory<ServiceContext> policy) {
        this.serviceContextAuthenticationPolicyFactory = policy;
    }

    public void setTicketFactory(TicketFactory ticketFactory) {
        this.ticketFactory = ticketFactory;
    }

    @Autowired
    public final void setPrincipalFactory(@Qualifier(value="principalFactory") PrincipalFactory principalFactory) {
        this.principalFactory = principalFactory;
    }

    protected final void doPublishEvent(ApplicationEvent e) {
        this.logger.debug("Publishing {}", (Object)e);
        this.eventPublisher.publishEvent(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(readOnly=true, transactionManager="ticketTransactionManager")
    @Timed(name="GET_TICKET_TIMER")
    @Metered(name="GET_TICKET_METER")
    @Counted(name="GET_TICKET_COUNTER", monotonic=true)
    public <T extends Ticket> T getTicket(String ticketId, Class<? extends Ticket> clazz) throws InvalidTicketException {
        Assert.notNull((Object)ticketId, (String)"ticketId cannot be null");
        Ticket ticket = this.ticketRegistry.getTicket(ticketId, clazz);
        if (ticket == null) {
            this.logger.debug("Ticket [{}] by type [{}] cannot be found in the ticket registry.", (Object)ticketId, (Object)clazz.getSimpleName());
            throw new InvalidTicketException(ticketId);
        }
        if (ticket instanceof TicketGrantingTicket) {
            Ticket ticket2 = ticket;
            synchronized (ticket2) {
                if (ticket.isExpired()) {
                    this.ticketRegistry.deleteTicket(ticketId);
                    this.logger.debug("Ticket [{}] has expired and is now deleted from the ticket registry.", (Object)ticketId);
                    throw new InvalidTicketException(ticketId);
                }
            }
        }
        return (T)ticket;
    }

    @Transactional(readOnly=true, transactionManager="ticketTransactionManager")
    @Timed(name="GET_TICKETS_TIMER")
    @Metered(name="GET_TICKETS_METER")
    @Counted(name="GET_TICKETS_COUNTER", monotonic=true)
    public Collection<Ticket> getTickets(Predicate<Ticket> predicate) {
        HashSet<Ticket> c = new HashSet<Ticket>(this.ticketRegistry.getTickets());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (predicate.apply((Object)((Ticket)it.next()))) continue;
            it.remove();
        }
        return c;
    }

    protected final Authentication getAuthenticationSatisfiedByPolicy(TicketGrantingTicket ticket, ServiceContext context) throws AbstractTicketException {
        ContextualAuthenticationPolicy policy = this.serviceContextAuthenticationPolicyFactory.createPolicy((Object)context);
        if (policy.isSatisfiedBy(ticket.getAuthentication())) {
            this.logger.debug("Authentication policy {} is satisfied by the authentication associated with {}", (Object)policy, (Object)ticket.getId());
            return ticket.getAuthentication();
        }
        for (Authentication auth : ticket.getSupplementalAuthentications()) {
            if (!policy.isSatisfiedBy(auth)) continue;
            this.logger.debug("Authentication policy {} is satisfied by supplemental authentication associated with {}", (Object)policy, (Object)ticket.getId());
            return auth;
        }
        throw new UnsatisfiedAuthenticationPolicyException(policy);
    }

    protected final void verifyRegisteredServiceProperties(RegisteredService registeredService, Service service) throws UnauthorizedServiceException {
        if (registeredService == null) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not found in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
        if (!registeredService.getAccessStrategy().isServiceAccessAllowed()) {
            String msg = String.format("ServiceManagement: Unauthorized Service Access. Service [%s] is not enabled in service registry.", service.getId());
            this.logger.warn(msg);
            throw new UnauthorizedServiceException("screen.service.error.message", msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void evaluateProxiedServiceIfNeeded(Service service, TicketGrantingTicket ticketGrantingTicket, RegisteredService registeredService) {
        Service proxiedBy = ticketGrantingTicket.getProxiedBy();
        if (proxiedBy != null) {
            this.logger.debug("TGT is proxied by [{}]. Locating proxy service in registry...", (Object)proxiedBy.getId());
            RegisteredService proxyingService = this.servicesManager.findServiceBy(proxiedBy);
            if (proxyingService != null) {
                this.logger.debug("Located proxying service [{}] in the service registry", (Object)proxyingService);
                if (proxyingService.getProxyPolicy().isAllowedToProxy()) return;
                this.logger.warn("Found proxying service {}, but it is not authorized to fulfill the proxy attempt made by {}", (Object)proxyingService.getId(), (Object)service.getId());
                throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
            }
            this.logger.warn("No proxying service found. Proxy attempt by service [{}] (registered service [{}]) is not allowed.", (Object)service.getId(), (Object)registeredService.getId());
            throw new UnauthorizedProxyingException("Proxying is not allowed for registered service " + registeredService.getId());
        }
        this.logger.debug("TGT {} is not proxied by another service", (Object)ticketGrantingTicket.getId());
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setTicketRegistry(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public void setServicesManager(ServicesManager servicesManager) {
        this.servicesManager = servicesManager;
    }

    public void setLogoutManager(LogoutManager logoutManager) {
        this.logoutManager = logoutManager;
    }
}

