/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import java.util.Formatter;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.CasVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

@Component(value="casEnvironmentContextListener")
public final class CasEnvironmentContextListener
implements ServletContextListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEnvironmentContextListener.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);

    public CasEnvironmentContextListener() {
        LOGGER.debug("[{}] initialized...", (Object)CasEnvironmentContextListener.class.getSimpleName());
    }

    @PostConstruct
    public void logEnvironmentInfo() {
        if (!INITIALIZED.get()) {
            LOGGER.info(this.collectEnvironmentInfo());
            INITIALIZED.set(true);
        }
    }

    private String collectEnvironmentInfo() {
        Properties properties = System.getProperties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (Formatter formatter = new Formatter();){
            formatter.format("\n******************** Welcome to CAS *******************\n", new Object[0]);
            formatter.format("CAS Version: %s\n", CasVersion.getVersion());
            formatter.format("Build Date/Time: %s\n", CasVersion.getDateTime());
            formatter.format("Java Home: %s\n", properties.get("java.home"));
            formatter.format("Java Vendor: %s\n", properties.get("java.vendor"));
            formatter.format("Java Version: %s\n", properties.get("java.version"));
            formatter.format("OS Architecture: %s\n", properties.get("os.arch"));
            formatter.format("OS Name: %s\n", properties.get("os.name"));
            formatter.format("OS Version: %s\n", properties.get("os.version"));
            formatter.format("*******************************************************\n", new Object[0]);
            return formatter.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append((Object)this.collectEnvironmentInfo());
        return builder.toString();
    }

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        WebApplicationContext ctx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)servletContext);
        LOGGER.info("[{}] has loaded the CAS servlet application context: {}", (Object)servletContext.getServerInfo(), (Object)ctx);
    }

    public void contextDestroyed(ServletContextEvent event) {
    }
}

