/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.google.common.base.Throwables;
import java.io.File;
import java.net.URL;
import org.jasig.cas.CasEnvironmentContextListener;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.VfsResource;

public final class CasVersion {
    private static final Logger LOGGER = LoggerFactory.getLogger(CasEnvironmentContextListener.class);

    private CasVersion() {
    }

    public static String getVersion() {
        return CasVersion.class.getPackage().getImplementationVersion();
    }

    public static DateTime getDateTime() {
        try {
            Class<CasVersion> clazz = CasVersion.class;
            URL resource = clazz.getResource(String.valueOf(clazz.getSimpleName()) + ".class");
            if ("file".equals(resource.getProtocol())) {
                return new DateTime(new File(resource.toURI()).lastModified());
            }
            if ("jar".equals(resource.getProtocol())) {
                String path = resource.getPath();
                File file = new File(path.substring(5, path.indexOf(33)));
                return new DateTime(file.lastModified());
            }
            if ("vfs".equals(resource.getProtocol())) {
                File file = new VfsResource(resource.openConnection().getContent()).getFile();
                return new DateTime(file.lastModified());
            }
            LOGGER.warn("Unhandled url protocol: {} resource: {}", (Object)resource.getProtocol(), (Object)resource);
            return DateTime.now();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

