/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.money.CurrencyUnit;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;

@Deprecated
public final class HistoricConversionQueryBuilder {
    private final ConversionQueryBuilder conversionQueryBuilder;

    private HistoricConversionQueryBuilder(ConversionQueryBuilder conversionQuery) {
        this.conversionQueryBuilder = conversionQuery;
    }

    public static HistoricConversionQueryBuilder of(CurrencyUnit currencyUnit) {
        Objects.requireNonNull(currencyUnit, "Currency is required");
        return new HistoricConversionQueryBuilder(ConversionQueryBuilder.of().setTermCurrency(currencyUnit));
    }

    public HistoricConversionQueryWithDayBuilder withDay(LocalDate localDate) {
        Objects.requireNonNull(localDate);
        this.conversionQueryBuilder.set(LocalDate.class, (Object)localDate);
        return new HistoricConversionQueryWithDayBuilder(this.conversionQueryBuilder);
    }

    @SafeVarargs
    public final HistoricConversionQueryWithDayBuilder withDays(LocalDate ... localDates) {
        Objects.requireNonNull(localDates);
        if (localDates.length == 0) {
            throw new IllegalArgumentException("LocalDates are required");
        }
        if (Stream.of(localDates).anyMatch(Predicate.isEqual(null))) {
            throw new IllegalArgumentException("LocalDates cannot be null");
        }
        Comparator comparator = Comparator.naturalOrder();
        LocalDate[] sortedDates = (LocalDate[])Stream.of(localDates).sorted(comparator.reversed()).toArray(LocalDate[]::new);
        this.conversionQueryBuilder.set(LocalDate[].class, (Object)sortedDates);
        return new HistoricConversionQueryWithDayBuilder(this.conversionQueryBuilder);
    }

    @SafeVarargs
    public final HistoricConversionQueryWithDayBuilder withDaysPriorityDefined(LocalDate ... localDates) {
        Objects.requireNonNull(localDates);
        if (localDates.length == 0) {
            throw new IllegalArgumentException("LocalDates are required");
        }
        if (Stream.of(localDates).anyMatch(Predicate.isEqual(null))) {
            throw new IllegalArgumentException("LocalDates cannot be null");
        }
        this.conversionQueryBuilder.set(LocalDate[].class, (Object)localDates);
        return new HistoricConversionQueryWithDayBuilder(this.conversionQueryBuilder);
    }

    public final HistoricConversionQueryWithDayBuilder withDaysBetween(LocalDate begin, LocalDate end) {
        Objects.requireNonNull(begin);
        Objects.requireNonNull(end);
        if (end.isBefore(begin)) {
            throw new IllegalArgumentException("The end period should be bigger than the begin period.");
        }
        int days = (int)ChronoUnit.DAYS.between(begin, end);
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (int index = days; index >= 0; --index) {
            dates.add(begin.plusDays(index));
        }
        this.conversionQueryBuilder.set(LocalDate[].class, (Object)dates.toArray(new LocalDate[dates.size()]));
        return new HistoricConversionQueryWithDayBuilder(this.conversionQueryBuilder);
    }

    public ConversionQuery build() {
        return this.conversionQueryBuilder.build();
    }

    public String toString() {
        String sb = HistoricConversionQueryBuilder.class.getName() + "{ conversionQueryBuilder: " + this.conversionQueryBuilder + "}";
        return sb;
    }

    public class HistoricConversionQueryWithDayBuilder {
        private final ConversionQueryBuilder conversionQueryBuilder;

        HistoricConversionQueryWithDayBuilder(ConversionQueryBuilder conversionQueryBuilder) {
            this.conversionQueryBuilder = conversionQueryBuilder;
        }

        public ConversionQuery build() {
            return this.conversionQueryBuilder.build();
        }

        public String toString() {
            String sb = HistoricConversionQueryWithDayBuilder.class.getName() + "{ conversionQueryBuilder: " + this.conversionQueryBuilder + "}";
            return sb;
        }
    }
}

