/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.convert.imf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.NumberValue;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ProviderContext;
import javax.money.convert.RateType;
import org.javamoney.moneta.convert.ExchangeRateBuilder;
import org.javamoney.moneta.convert.imf.IMFAbstractRateProvider;
import org.javamoney.moneta.spi.DefaultNumberValue;

class IMFRateReadingHandler {
    private static final Logger LOG = Logger.getLogger(IMFRateReadingHandler.class.getName());
    private final Map<String, CurrencyUnit> currenciresByName;
    private final ProviderContext context;

    IMFRateReadingHandler(Map<String, CurrencyUnit> currenciresByName, ProviderContext context) {
        this.currenciresByName = currenciresByName;
        this.context = context;
    }

    RateIMFResult read(InputStream inputStream) throws IOException, ParseException {
        HashMap<CurrencyUnit, List<ExchangeRate>> currencyToSdr = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        HashMap<CurrencyUnit, List<ExchangeRate>> sdrToCurrency = new HashMap<CurrencyUnit, List<ExchangeRate>>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String line = reader.readLine();
        if (line.contains("Request Rejected")) {
            throw new IOException("Request has been rejected by IMF server.");
        }
        boolean isCurrencyToSdr = true;
        List<LocalDate> timestamps = null;
        while (Objects.nonNull(line)) {
            if (line.trim().isEmpty()) {
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("SDRs per Currency unit")) {
                isCurrencyToSdr = false;
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("Currency units per SDR")) {
                isCurrencyToSdr = true;
                line = reader.readLine();
                continue;
            }
            if (line.startsWith("Currency")) {
                timestamps = this.readTimestamps(line);
                line = reader.readLine();
                continue;
            }
            String[] parts = line.split("\\t");
            CurrencyUnit currency = this.currenciresByName.get(parts[0]);
            if (Objects.isNull(currency)) {
                LOG.finest(() -> "Uninterpretable data from IMF data feed: " + parts[0]);
                line = reader.readLine();
                continue;
            }
            this.saveExchangeRate(currencyToSdr, sdrToCurrency, isCurrencyToSdr, timestamps, currency, this.parseValues(parts));
            line = reader.readLine();
        }
        this.sortResult(currencyToSdr, sdrToCurrency);
        return new RateIMFResult(currencyToSdr, sdrToCurrency);
    }

    private void sortResult(Map<CurrencyUnit, List<ExchangeRate>> newCurrencyToSdr, Map<CurrencyUnit, List<ExchangeRate>> newSdrToCurrency) {
        newSdrToCurrency.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        newCurrencyToSdr.values().forEach(c -> Collections.sort((List)List.class.cast(c)));
        newSdrToCurrency.forEach((c, l) -> LOG.finest(() -> "SDR -> " + c.getCurrencyCode() + ": " + l));
        newCurrencyToSdr.forEach((c, l) -> LOG.finest(() -> c.getCurrencyCode() + " -> SDR: " + l));
    }

    private List<LocalDate> readTimestamps(String line) {
        DateTimeFormatter sdf = DateTimeFormatter.ofPattern("MMMM dd, uuuu").withLocale(Locale.ENGLISH);
        String[] parts = line.split("\\\t");
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(parts.length);
        for (int i = 1; i < parts.length; ++i) {
            dates.add(LocalDate.parse(parts[i], sdf));
        }
        return dates;
    }

    private void saveExchangeRate(Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr, Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency, boolean isCurrencyToSdr, List<LocalDate> timestamps, CurrencyUnit currency, Double[] values) {
        for (int index = 0; index < values.length; ++index) {
            List rates;
            ExchangeRate rate;
            if (Objects.isNull(values[index]) || Objects.isNull(this.getLocalDateFromTS(timestamps, index))) continue;
            LocalDate fromTS = this.getLocalDateFromTS(timestamps, index);
            RateType rateType = this.getRateType(fromTS);
            if (isCurrencyToSdr) {
                rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).set((Object)fromTS)).build()).setBase(currency).setTerm(IMFAbstractRateProvider.SDR).setFactor((NumberValue)new DefaultNumberValue((Number)(1.0 / values[index]))).build();
                rates = currencyToSdr.computeIfAbsent(currency, c -> new ArrayList(5));
                rates.add(rate);
                continue;
            }
            rate = new ExchangeRateBuilder(((ConversionContextBuilder)ConversionContextBuilder.create((ProviderContext)this.context, (RateType)rateType).set((Object)fromTS)).build()).setBase(IMFAbstractRateProvider.SDR).setTerm(currency).setFactor(DefaultNumberValue.of((Number)(1.0 / values[index]))).build();
            rates = sdrToCurrency.computeIfAbsent(currency, c -> new ArrayList(5));
            rates.add(rate);
        }
    }

    private Double[] parseValues(String[] parts) throws ParseException {
        ArrayList<Double> result = new ArrayList<Double>();
        int index = 0;
        for (String part : parts) {
            if (index == 0) {
                ++index;
                continue;
            }
            if (part.isEmpty() || "NA".equals(part)) {
                ++index;
                result.add(null);
                continue;
            }
            ++index;
            result.add(Double.valueOf(part.trim().replace(",", "")));
        }
        return result.toArray(new Double[parts.length - 1]);
    }

    private LocalDate getLocalDateFromTS(List<LocalDate> timestamps, int index) {
        return timestamps != null ? timestamps.get(index) : null;
    }

    private RateType getRateType(LocalDate fromTS) {
        RateType rateType = RateType.HISTORIC;
        if (fromTS.equals(LocalDate.now())) {
            rateType = RateType.DEFERRED;
        }
        return rateType;
    }

    public String toString() {
        String sb = IMFRateReadingHandler.class.getName() + "{ currenciresByName: " + this.currenciresByName + ", context: " + this.context + "}";
        return sb;
    }

    class RateIMFResult {
        private final Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr;
        private final Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency;

        RateIMFResult(Map<CurrencyUnit, List<ExchangeRate>> currencyToSdr, Map<CurrencyUnit, List<ExchangeRate>> sdrToCurrency) {
            this.currencyToSdr = currencyToSdr;
            this.sdrToCurrency = sdrToCurrency;
        }

        public Map<CurrencyUnit, List<ExchangeRate>> getCurrencyToSdr() {
            return this.currencyToSdr;
        }

        public Map<CurrencyUnit, List<ExchangeRate>> getSdrToCurrency() {
            return this.sdrToCurrency;
        }
    }
}

