/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.io.Serializable;
import java.util.Objects;
import javax.money.CurrencyContext;
import javax.money.CurrencyUnit;
import javax.money.MonetaryException;
import org.javamoney.moneta.CurrencyUnitBuilder;

final class BuildableCurrencyUnit
implements CurrencyUnit,
Comparable<CurrencyUnit>,
Serializable {
    private static final long serialVersionUID = -2389580389919492220L;
    private String currencyCode;
    private int numericCode;
    private int defaultFractionDigits;
    private CurrencyContext currencyContext;

    BuildableCurrencyUnit(CurrencyUnitBuilder builder) {
        Objects.requireNonNull(builder.currencyCode, "currencyCode required");
        if (builder.numericCode < -1) {
            throw new MonetaryException("numericCode must be >= -1");
        }
        if (builder.defaultFractionDigits < 0) {
            throw new MonetaryException("defaultFractionDigits must be >= 0");
        }
        if (builder.currencyContext == null) {
            throw new MonetaryException("currencyContext must be != null");
        }
        this.defaultFractionDigits = builder.defaultFractionDigits;
        this.numericCode = builder.numericCode;
        this.currencyCode = builder.currencyCode;
        this.currencyContext = builder.currencyContext;
    }

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public int getNumericCode() {
        return this.numericCode;
    }

    public int getDefaultFractionDigits() {
        return this.defaultFractionDigits;
    }

    public CurrencyContext getContext() {
        return this.currencyContext;
    }

    @Override
    public int compareTo(CurrencyUnit o) {
        Objects.requireNonNull(o);
        return this.currencyCode.compareTo(o.getCurrencyCode());
    }

    public int hashCode() {
        return Objects.hashCode(this.currencyCode);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CurrencyUnit) {
            CurrencyUnit other = (CurrencyUnit)obj;
            return Objects.equals(this.getCurrencyCode(), other.getCurrencyCode());
        }
        return false;
    }

    public String toString() {
        return "BuildableCurrencyUnit(currencyCode=" + this.currencyCode + ", numericCode=" + this.numericCode + ", defaultFractionDigits=" + this.defaultFractionDigits + ", context=" + this.currencyContext + ")";
    }
}

