/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta;

import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.MonetaryContext;
import javax.money.MonetaryContextBuilder;
import org.javamoney.moneta.Money;
import org.javamoney.moneta.spi.MonetaryConfig;

class DefaultMonetaryContextFactory {
    DefaultMonetaryContextFactory() {
    }

    public MonetaryContext getContext() {
        try {
            Map<String, String> config = MonetaryConfig.getConfig();
            String value = config.get("org.javamoney.moneta.Money.defaults.precision");
            if (Objects.nonNull(value)) {
                return this.createMonetaryContextNonNullConfig(config, Integer.parseInt(value));
            }
            return this.createContextWithConfig(config);
        }
        catch (Exception e) {
            Logger.getLogger(DefaultMonetaryContextFactory.class.getName()).log(Level.SEVERE, "Error evaluating default NumericContext, using default (NumericContext.NUM64).", e);
            return ((MonetaryContextBuilder)MonetaryContextBuilder.of(Money.class).set((Object)MathContext.DECIMAL64)).build();
        }
    }

    private MonetaryContext createContextWithConfig(Map<String, String> config) {
        MonetaryContextBuilder builder = MonetaryContextBuilder.of(Money.class);
        String value = config.get("org.javamoney.moneta.Money.defaults.mathContext");
        if (Objects.nonNull(value)) {
            switch (value.toUpperCase(Locale.ENGLISH)) {
                case "DECIMAL32": {
                    Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL32");
                    builder.set((Object)MathContext.DECIMAL32);
                    break;
                }
                case "DECIMAL64": {
                    Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL64");
                    builder.set((Object)MathContext.DECIMAL64);
                    break;
                }
                case "DECIMAL128": {
                    Logger.getLogger(Money.class.getName()).info("Using MathContext.DECIMAL128");
                    builder.set((Object)MathContext.DECIMAL128);
                    break;
                }
                case "UNLIMITED": {
                    Logger.getLogger(Money.class.getName()).info("Using MathContext.UNLIMITED");
                    builder.set((Object)MathContext.UNLIMITED);
                    break;
                }
                default: {
                    Logger.getLogger(Money.class.getName()).warning("Found invalid MathContext: " + value + ", using default MathContext.DECIMAL64");
                    builder.set((Object)MathContext.DECIMAL64);
                    break;
                }
            }
        } else {
            Logger.getLogger(Money.class.getName()).info("Using default MathContext.DECIMAL64");
            builder.set((Object)MathContext.DECIMAL64);
        }
        return builder.build();
    }

    private MonetaryContext createMonetaryContextNonNullConfig(Map<String, String> config, int prec) {
        String value = config.get("org.javamoney.moneta.Money.defaults.roundingMode");
        RoundingMode rm = Objects.nonNull(value) ? RoundingMode.valueOf(value.toUpperCase(Locale.ENGLISH)) : RoundingMode.HALF_UP;
        MonetaryContext mc = ((MonetaryContextBuilder)((MonetaryContextBuilder)MonetaryContextBuilder.of(Money.class).setPrecision(prec).set((Object)rm)).set(Money.class)).build();
        Logger.getLogger(DefaultMonetaryContextFactory.class.getName()).info("Using custom MathContext: precision=" + prec + ", roundingMode=" + rm);
        return mc;
    }
}

