/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.format;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;
import java.util.Optional;
import javax.money.MonetaryAmount;
import javax.money.format.AmountFormatContext;
import javax.money.format.AmountFormatContextBuilder;
import javax.money.format.MonetaryParseException;
import org.javamoney.moneta.format.MonetaryAmountFormatSymbols;
import org.javamoney.moneta.format.MonetaryAmountNumericInformation;
import org.javamoney.moneta.format.MonetaryAmountSymbols;
import org.javamoney.moneta.spi.MonetaryAmountProducer;

class DefaultMonetaryAmountFormatSymbols
implements MonetaryAmountFormatSymbols {
    static final String STYLE = "MonetaryAmountFormatSymbols";
    private static final AmountFormatContext CONTEXT = AmountFormatContextBuilder.of((String)"MonetaryAmountFormatSymbols").build();
    private final MonetaryAmountSymbols symbols;
    private final DecimalFormat decimalFormat;
    private final MonetaryAmountProducer producer;
    private final MonetaryAmountNumericInformation numericInformation;

    DefaultMonetaryAmountFormatSymbols(MonetaryAmountSymbols symbols, MonetaryAmountProducer producer) {
        this.symbols = symbols;
        this.producer = producer;
        this.decimalFormat = (DecimalFormat)DecimalFormat.getCurrencyInstance();
        this.decimalFormat.setDecimalFormatSymbols(symbols.getFormatSymbol());
        this.numericInformation = new MonetaryAmountNumericInformation(this.decimalFormat);
    }

    DefaultMonetaryAmountFormatSymbols(String pattern, MonetaryAmountSymbols symbols, MonetaryAmountProducer producer) {
        this.symbols = symbols;
        this.producer = producer;
        this.decimalFormat = new DecimalFormat(pattern, symbols.getFormatSymbol());
        this.numericInformation = new MonetaryAmountNumericInformation(this.decimalFormat);
    }

    public AmountFormatContext getContext() {
        return CONTEXT;
    }

    public void print(Appendable appendable, MonetaryAmount amount) throws IOException {
        Objects.requireNonNull(appendable);
        appendable.append(this.queryFrom(amount));
    }

    public MonetaryAmount parse(CharSequence text) throws MonetaryParseException {
        Objects.requireNonNull(text);
        try {
            Number number = this.decimalFormat.parse(text.toString());
            return this.producer.create(this.symbols.getCurrency(), number);
        }
        catch (Exception exception) {
            throw new MonetaryParseException(exception.getMessage(), text, 0);
        }
    }

    public String queryFrom(MonetaryAmount amount) {
        return Optional.ofNullable(amount).map(m -> this.decimalFormat.format(amount.getNumber().numberValue(BigDecimal.class))).orElse("null");
    }

    @Override
    public MonetaryAmountSymbols getAmountSymbols() {
        return this.symbols;
    }

    @Override
    public MonetaryAmountNumericInformation getNumericInformation() {
        return this.numericInformation;
    }

    public int hashCode() {
        return Objects.hash(this.symbols, this.numericInformation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (DefaultMonetaryAmountFormatSymbols.class.isInstance(obj)) {
            DefaultMonetaryAmountFormatSymbols other = (DefaultMonetaryAmountFormatSymbols)DefaultMonetaryAmountFormatSymbols.class.cast(obj);
            return Objects.equals(other.symbols, this.symbols) && Objects.equals(other.numericInformation, this.numericInformation);
        }
        return false;
    }

    public String toString() {
        return DefaultMonetaryAmountFormatSymbols.class.getName() + "{ numericInformation: " + this.numericInformation + ", symbols: " + this.symbols + "}";
    }
}

