/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.function;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import org.javamoney.moneta.RoundedMoney;

public final class PrecisionContextRoundedOperator
implements MonetaryOperator {
    private final MathContext mathContext;

    private PrecisionContextRoundedOperator(MathContext mathContext) {
        this.mathContext = mathContext;
    }

    public static PrecisionContextRoundedOperator of(MathContext mathContext) {
        Objects.requireNonNull(mathContext);
        if (RoundingMode.UNNECESSARY.equals((Object)mathContext.getRoundingMode())) {
            throw new IllegalArgumentException("To create the MathContextRoundedOperator you cannot use the RoundingMode.UNNECESSARY on MathContext");
        }
        if (mathContext.getPrecision() <= 0) {
            throw new IllegalArgumentException("To create the MathContextRoundedOperator you cannot use the zero precision on MathContext");
        }
        return new PrecisionContextRoundedOperator(mathContext);
    }

    public MonetaryAmount apply(MonetaryAmount amount) {
        RoundedMoney roundedMoney = RoundedMoney.from(Objects.requireNonNull(amount));
        BigDecimal numberValue = (BigDecimal)roundedMoney.getNumber().numberValue(BigDecimal.class);
        BigDecimal numberRounded = numberValue.round(this.mathContext);
        return RoundedMoney.of(numberRounded, roundedMoney.getCurrency(), (MonetaryOperator)this);
    }

    public MathContext getMathContext() {
        return this.mathContext;
    }

    public String toString() {
        return PrecisionContextRoundedOperator.class.getName() + "{mathContext:" + this.mathContext + "}";
    }
}

