/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ServiceLoader;
import java.util.logging.Logger;
import javax.money.spi.ServiceProvider;
import org.javamoney.moneta.internal.OSGIServiceComparator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class OSGIServiceProvider
implements ServiceProvider {
    private static final Logger LOG = Logger.getLogger(OSGIServiceProvider.class.getName());
    private static final OSGIServiceComparator REF_COMPARATOR = new OSGIServiceComparator();
    private final BundleContext bundleContext;

    public OSGIServiceProvider(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public boolean isInitialized() {
        return this.bundleContext != null;
    }

    public int getPriority() {
        return 10;
    }

    public <T> T getService(Class<T> serviceType) {
        LOG.finest("TAMAYA  Loading service: " + serviceType.getName());
        ServiceReference ref = this.bundleContext.getServiceReference(serviceType);
        if (ref != null) {
            return (T)this.bundleContext.getService(ref);
        }
        return null;
    }

    public <T> T create(Class<T> serviceType) {
        LOG.finest("TAMAYA  Creating service: " + serviceType.getName());
        ServiceReference ref = this.bundleContext.getServiceReference(serviceType);
        if (ref != null) {
            try {
                return (T)this.bundleContext.getService(ref).getClass().newInstance();
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public <T> List<T> getServices(Class<T> serviceType) {
        LOG.finest("TAMAYA  Loading services: " + serviceType.getName());
        ArrayList<ServiceReference> refs = new ArrayList<ServiceReference>();
        ArrayList<Object> services = new ArrayList<Object>(refs.size());
        try {
            refs.addAll(this.bundleContext.getServiceReferences(serviceType, null));
            refs.sort(REF_COMPARATOR);
            for (ServiceReference ref : refs) {
                Object service = this.bundleContext.getService(ref);
                if (service == null) continue;
                services.add(service);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
        try {
            for (T service : ServiceLoader.load(serviceType)) {
                services.add(service);
            }
            return services;
        }
        catch (Exception e) {
            e.printStackTrace();
            return services;
        }
    }

    public Enumeration<URL> getResources(String resource, ClassLoader cl) {
        LOG.finest("TAMAYA  Loading resources: " + resource);
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = this.bundleContext.getBundle().getEntry(resource);
        if (url != null) {
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + this.bundleContext.getBundle().getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in registered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        for (Bundle bundle : this.bundleContext.getBundles()) {
            url = bundle.getEntry(resource);
            if (url == null || result.contains(url)) continue;
            LOG.finest("TAMAYA  Resource: " + resource + " found in unregistered bundle " + bundle.getSymbolicName());
            result.add(url);
        }
        return Collections.enumeration(result);
    }
}

