/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.spi.LoaderService;

class DefaultLoaderListener {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderListener.class.getName());
    private final Map<String, List<LoaderService.LoaderListener>> listenersMap = new ConcurrentHashMap<String, List<LoaderService.LoaderListener>>();

    DefaultLoaderListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LoaderService.LoaderListener> getListeners(String dataId) {
        List<LoaderService.LoaderListener> listeners;
        if (Objects.isNull(dataId)) {
            dataId = "";
        }
        if (Objects.isNull(listeners = this.listenersMap.get(dataId))) {
            Map<String, List<LoaderService.LoaderListener>> map = this.listenersMap;
            synchronized (map) {
                listeners = this.listenersMap.get(dataId);
                if (Objects.isNull(listeners)) {
                    listeners = Collections.synchronizedList(new ArrayList());
                    this.listenersMap.put(dataId, listeners);
                }
            }
        }
        return listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger(String dataId, InputStream is) {
        List<LoaderService.LoaderListener> listeners;
        List<LoaderService.LoaderListener> list = listeners = this.getListeners("");
        synchronized (list) {
            for (LoaderService.LoaderListener ll : listeners) {
                try {
                    ll.newDataLoaded(dataId, is);
                }
                catch (Exception e) {
                    LOG.log(Level.SEVERE, "Error calling LoadListener: " + ll, e);
                }
            }
        }
        if (!Objects.isNull(dataId) && !dataId.isEmpty()) {
            list = listeners = this.getListeners(dataId);
            synchronized (list) {
                for (LoaderService.LoaderListener ll : listeners) {
                    try {
                        ll.newDataLoaded(dataId, is);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to load new data: " + ll, e);
                    }
                }
            }
        }
    }

    public String toString() {
        return DefaultLoaderListener.class.getName() + "{listenersMap: " + this.listenersMap + "}";
    }
}

