/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.MonetaryException;
import org.javamoney.moneta.internal.loader.ResourceCache;

public class DefaultResourceCache
implements ResourceCache {
    private static final Logger LOG = Logger.getLogger(DefaultResourceCache.class.getName());
    private static final String SUFFIX = ".dat";
    private File localDir = new File(System.getProperty("temp.dir", ".resourceCache"));
    private final Map<String, File> cachedResources = new ConcurrentHashMap<String, File>();

    public DefaultResourceCache() {
        File[] files;
        if (!this.localDir.exists()) {
            if (!this.localDir.mkdirs()) {
                LOG.severe("Error creating cache dir  " + this.localDir + ", resource cache disabled!");
                this.localDir = null;
            } else {
                LOG.finest("Created cache dir  " + this.localDir);
            }
        } else if (!this.localDir.isDirectory()) {
            LOG.severe("Error initializing cache dir  " + this.localDir + ", not a directory, resource cache disabled!");
            this.localDir = null;
        } else if (!this.localDir.canWrite()) {
            LOG.severe("Error initializing cache dir  " + this.localDir + ", not writable, resource cache disabled!");
            this.localDir = null;
        }
        if (Objects.nonNull(this.localDir) && (files = this.localDir.listFiles()) != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                String resourceId = file.getName().substring(0, file.getName().length() - 4);
                this.cachedResources.put(resourceId, file);
            }
        }
    }

    @Override
    public void write(String resourceId, byte[] data) {
        try {
            File file = this.cachedResources.get(resourceId);
            if (Objects.isNull(file)) {
                file = new File(this.localDir, resourceId + SUFFIX);
                Files.write(file.toPath(), data, new OpenOption[0]);
                this.cachedResources.put(resourceId, file);
            } else {
                Files.write(file.toPath(), data, new OpenOption[0]);
            }
        }
        catch (Exception e) {
            LOG.log(Level.WARNING, "Caching of resource failed: " + resourceId, e);
        }
    }

    @Override
    public boolean isCached(String resourceId) {
        return this.cachedResources.containsKey(resourceId);
    }

    @Override
    public byte[] read(String resourceId) {
        File f = this.cachedResources.get(resourceId);
        if (Objects.isNull(f)) {
            return null;
        }
        try {
            return Files.readAllBytes(f.toPath());
        }
        catch (IOException exception) {
            throw new MonetaryException("An error on retrieve the resource id: " + resourceId, (Throwable)exception);
        }
    }

    @Override
    public void clear(String resourceId) {
        File file = this.cachedResources.get(resourceId);
        if (file != null) {
            if (file.exists() && !file.delete()) {
                LOG.warning("Failed to delete caching file: " + file.getAbsolutePath());
            }
            this.cachedResources.remove(resourceId);
        }
    }

    public String toString() {
        return "DefaultResourceCache [localDir=" + this.localDir + ", cachedResources=" + this.cachedResources + "]";
    }
}

