/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.internal.loader;

import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javamoney.moneta.internal.loader.DefaultLoaderListener;
import org.javamoney.moneta.internal.loader.LoadableResource;

public class LoadDataLoaderService {
    private static final Logger LOG = Logger.getLogger(DefaultLoaderListener.class.getName());
    private final DefaultLoaderListener listener;

    LoadDataLoaderService(DefaultLoaderListener listener) {
        this.listener = listener;
    }

    public boolean execute(String resourceId, Map<String, LoadableResource> resources) {
        LoadableResource load = resources.get(resourceId);
        if (Objects.nonNull(load)) {
            try {
                if (load.load()) {
                    LOG.log(Level.INFO, "Read data from: " + load.getRemoteResources());
                    this.listener.trigger(resourceId, load.getDataStream());
                    LOG.log(Level.INFO, "New data successfully loaded from: " + load.getRemoteResources());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to read/load resource (checking fallback): " + resourceId, e);
            }
            try {
                if (load.loadFallback()) {
                    LOG.log(Level.WARNING, "Read fallback data from: " + load.getFallbackResource());
                    this.listener.trigger(resourceId, load.getDataStream());
                    LOG.log(Level.WARNING, "Loaded fallback data from: " + load.getFallbackResource());
                    return true;
                }
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to read/load fallback resource: " + resourceId, e);
            }
        } else {
            throw new IllegalArgumentException("No such resource: " + resourceId);
        }
        return false;
    }

    public String toString() {
        return LoadDataLoaderService.class.getName() + "{ listener: " + this.listener + "}";
    }
}

