/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.moneta.spi;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryContext;
import javax.money.MonetaryException;
import org.javamoney.moneta.spi.ConvertBigDecimal;

public final class MoneyUtils {
    private static final Logger LOG = Logger.getLogger(MoneyUtils.class.getName());

    private MoneyUtils() {
    }

    public static BigDecimal getBigDecimal(long num) {
        return BigDecimal.valueOf(num);
    }

    public static BigDecimal getBigDecimal(double num) {
        if (Double.isNaN(num)) {
            throw new ArithmeticException("Invalid input Double.NaN.");
        }
        if (Double.isInfinite(num)) {
            throw new ArithmeticException("Invalid input Double.xxx_INFINITY.");
        }
        return new BigDecimal(String.valueOf(num));
    }

    public static BigDecimal getBigDecimal(Number num) {
        return ConvertBigDecimal.of(num);
    }

    public static BigDecimal getBigDecimal(Number num, MonetaryContext moneyContext) {
        BigDecimal bd = MoneyUtils.getBigDecimal(num);
        if (Objects.nonNull(moneyContext)) {
            MathContext mc = MoneyUtils.getMathContext(moneyContext, RoundingMode.HALF_EVEN);
            bd = new BigDecimal(bd.toString(), mc);
            if (moneyContext.getMaxScale() > 0) {
                LOG.log(Level.FINE, "Got Max Scale %n", moneyContext.getMaxScale());
                bd = bd.setScale(moneyContext.getMaxScale(), mc.getRoundingMode());
            }
        }
        return bd;
    }

    public static MathContext getMathContext(MonetaryContext monetaryContext, RoundingMode defaultMode) {
        MathContext ctx = (MathContext)monetaryContext.get(MathContext.class);
        if (Objects.nonNull(ctx)) {
            return ctx;
        }
        RoundingMode roundingMode = (RoundingMode)((Object)monetaryContext.get(RoundingMode.class));
        if (roundingMode == null) {
            roundingMode = Optional.ofNullable(defaultMode).orElse(RoundingMode.HALF_EVEN);
        }
        return new MathContext(monetaryContext.getPrecision(), roundingMode);
    }

    public static void checkAmountParameter(MonetaryAmount amount, CurrencyUnit currencyUnit) {
        Objects.requireNonNull(amount, "Amount must not be null.");
        CurrencyUnit amountCurrency = amount.getCurrency();
        if (!currencyUnit.getCurrencyCode().equals(amountCurrency.getCurrencyCode())) {
            throw new MonetaryException("Currency mismatch: " + currencyUnit + "/" + amountCurrency);
        }
    }

    public static void checkNumberParameter(Number number) {
        Objects.requireNonNull(number, "Number is required.");
    }
}

