/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.channel.socket.oio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import org.jboss.netty.channel.AbstractChannel;
import org.jboss.netty.channel.ChannelException;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelSink;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.socket.DatagramChannel;
import org.jboss.netty.channel.socket.DatagramChannelConfig;
import org.jboss.netty.channel.socket.DefaultDatagramChannelConfig;

final class OioDatagramChannel
extends AbstractChannel
implements DatagramChannel {
    final MulticastSocket socket;
    final Object interestOpsLock = new Object();
    private final DatagramChannelConfig config;
    volatile Thread workerThread;
    private volatile InetSocketAddress localAddress;
    volatile InetSocketAddress remoteAddress;

    OioDatagramChannel(ChannelFactory factory, ChannelPipeline pipeline, ChannelSink sink) {
        super(null, factory, pipeline, sink);
        try {
            this.socket = new MulticastSocket(null);
        }
        catch (IOException e) {
            throw new ChannelException("Failed to open a datagram socket.", e);
        }
        try {
            this.socket.setSoTimeout(10);
            this.socket.setBroadcast(false);
        }
        catch (SocketException e) {
            throw new ChannelException("Failed to configure the datagram socket timeout.", e);
        }
        this.config = new DefaultDatagramChannelConfig(this.socket);
        Channels.fireChannelOpen(this);
    }

    @Override
    public DatagramChannelConfig getConfig() {
        return this.config;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress == null) {
            try {
                this.localAddress = localAddress = (InetSocketAddress)this.socket.getLocalSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return localAddress;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress remoteAddress = this.remoteAddress;
        if (remoteAddress == null) {
            try {
                this.remoteAddress = remoteAddress = (InetSocketAddress)this.socket.getRemoteSocketAddress();
            }
            catch (Throwable t) {
                return null;
            }
        }
        return remoteAddress;
    }

    @Override
    public boolean isBound() {
        return this.isOpen() && this.socket.isBound();
    }

    @Override
    public boolean isConnected() {
        return this.isOpen() && this.socket.isConnected();
    }

    @Override
    protected boolean setClosed() {
        return super.setClosed();
    }

    @Override
    protected void setInterestOpsNow(int interestOps) {
        super.setInterestOpsNow(interestOps);
    }

    @Override
    public ChannelFuture write(Object message, SocketAddress remoteAddress) {
        if (remoteAddress == null || remoteAddress.equals(this.getRemoteAddress())) {
            return super.write(message, null);
        }
        return super.write(message, remoteAddress);
    }

    @Override
    public void joinGroup(InetAddress multicastAddress) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public void joinGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        this.ensureBound();
        try {
            this.socket.joinGroup(multicastAddress, networkInterface);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    private void ensureBound() {
        if (!this.isBound()) {
            throw new IllegalStateException(DatagramChannel.class.getName() + " must be bound to join a group.");
        }
    }

    @Override
    public void leaveGroup(InetAddress multicastAddress) {
        try {
            this.socket.leaveGroup(multicastAddress);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    @Override
    public void leaveGroup(InetSocketAddress multicastAddress, NetworkInterface networkInterface) {
        try {
            this.socket.leaveGroup(multicastAddress, networkInterface);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }
}

