/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.expetion;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.modules.jmreport.common.constant.ErrorCode;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class JimuGlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(JimuGlobalExceptionHandler.class);

    @ExceptionHandler(value={JimuAlertException.class})
    public static Result openException(Exception ex, HttpServletRequest request, HttpServletResponse response) {
        response.setContentType("application/json; charset=utf-8");
        Result result = JimuGlobalExceptionHandler.resolveException(ex, request.getRequestURI());
        response.setStatus(result.getCode().intValue());
        return result;
    }

    public static Result resolveException(Exception ex, String path) {
        ErrorCode errorCode = ErrorCode.ERROR;
        int n = HttpStatus.INTERNAL_SERVER_ERROR.value();
        String string = ex.getMessage();
        String string2 = ex.getClass().getSuperclass().getName();
        String string3 = ex.getClass().getName();
        if (string3.contains("JimuAlertException")) {
            n = HttpStatus.OK.value();
            errorCode = ErrorCode.ALERT;
        }
        return JimuGlobalExceptionHandler.buildBody(ex, errorCode, path, n);
    }

    private static Result buildBody(Exception exception, ErrorCode resultCode, String path, int httpStatus) {
        String string = exception.getMessage();
        if (resultCode == null) {
            resultCode = ErrorCode.ERROR;
        }
        int n = resultCode.getCode();
        Result<Object> result = Result.error(n, string);
        log.error("==> \u9519\u8bef:{} exception: {}", result, (Object)exception);
        return result;
    }
}

