/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Objects;
import org.jeecg.modules.jmreport.common.expetion.JimuAlertException;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.springframework.util.CollectionUtils;

public class ApiAssert {
    public static void eq(String info, Object obj1, Object obj2) {
        if (!Objects.equals(obj1, obj2)) {
            ApiAssert.failure(info);
        }
    }

    public static void isTrue(String info, boolean condition) {
        if (!condition) {
            ApiAssert.failure(info);
        }
    }

    public static void isFalse(String info, boolean condition) {
        if (condition) {
            ApiAssert.failure(info);
        }
    }

    public static void gtzero(String info, int n) {
        if (n <= 0) {
            ApiAssert.failure(info);
        }
    }

    public static void lezero(String info, int n) {
        if (n > 0) {
            ApiAssert.failure(info);
        }
    }

    public static void gtzero(String info, BigDecimal n) {
        if (CommonUtils.le(n, new BigDecimal(0)).booleanValue()) {
            ApiAssert.failure(info);
        }
    }

    public static void gezero(String info, BigDecimal n) {
        if (CommonUtils.le(n, new BigDecimal(0)).booleanValue()) {
            ApiAssert.failure(info);
        }
    }

    public static void isEmpty(String info, Object obj) {
        if (oConvertUtils.isNotEmpty(obj)) {
            ApiAssert.failure(info);
        }
    }

    public static void isNotEmpty(String info, Object obj) {
        if (oConvertUtils.isEmpty(obj)) {
            ApiAssert.failure(info);
        }
    }

    public static void anyOneIsNull(String info, Object ... conditions) {
        if (CommonUtils.allNotNull(conditions)) {
            ApiAssert.failure(info);
        }
    }

    public static void anyOneIsNotNull(String info, Object ... conditions) {
        if (CommonUtils.allIsNull(conditions)) {
            ApiAssert.failure(info);
        }
    }

    public static void allNotNull(String info, Object ... conditions) {
        if (CommonUtils.anyOneIsNull(conditions)) {
            ApiAssert.failure(info);
        }
    }

    private static void failure(Result j2) {
        throw new JimuAlertException(1001, j2.getMessage());
    }

    public static void failure(String info) {
        throw new JimuAlertException(1001, info);
    }

    public static void notEmpty(Result j2, Object[] array) {
        if (oConvertUtils.isEmpty(array)) {
            ApiAssert.failure(j2);
        }
    }

    public static void noNullElements(Result j2, Object[] array) {
        if (array != null) {
            for (Object object : array) {
                if (object != null) continue;
                ApiAssert.failure(j2);
            }
        }
    }

    public static void notEmpty(Result j2, Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            ApiAssert.failure(j2);
        }
    }

    private ApiAssert() {
    }
}

