/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import com.alibaba.fastjson.JSONObject;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFSimpleShape;
import org.jeecg.modules.jmreport.common.constant.CommonConstant;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.expetion.JimuReportException;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtil {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtil.class);

    public static boolean isHave(String[] strs, String s) {
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!oConvertUtils.isNotEmpty(s) || !s.contains(strs[i2])) continue;
            return true;
        }
        return false;
    }

    public static Map<String, Object> isExistence(List<String> list, String[] text, String[] symbols, Integer n) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            String string = list.get(n);
            String string2 = ExcelUtil.ifHaveEnglish(text, string);
            String string3 = ExcelUtil.ifHaveSysbom(symbols, string);
            if (oConvertUtils.isEmpty(string3)) {
                return null;
            }
            if (string.contains(string2)) {
                String string4 = string.replace(string2, "");
                String[] stringArray = string3.split("__");
                for (String string5 : stringArray) {
                    string4 = string4.replace(string5, "");
                }
                String string6 = string4.replaceAll("[^A-Z]", "");
                String string7 = "";
                for (int i2 = 0; i2 < string6.length(); ++i2) {
                    string7 = string7 + string6.charAt(i2) + ",";
                }
                hashMap.put("newFirstWord", string7.substring(0, string7.lastIndexOf(",")));
                hashMap.put("english", string2);
                hashMap.put("sysbom", string3);
                return hashMap;
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static String ifHaveSysbom(String[] strs, String s) {
        String string = "";
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!s.contains(strs[i2])) continue;
            string = string + strs[i2] + "__";
        }
        if (oConvertUtils.isNotEmpty(string)) {
            string = string.substring(0, string.lastIndexOf("__"));
        }
        return string;
    }

    public static String ifHaveEnglish(String[] strs, String s) {
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!s.contains(strs[i2].split("=")[1])) continue;
            return strs[i2].split("=")[1];
        }
        return "";
    }

    public static String getCellValueByCell(Cell cell) {
        if (cell == null || cell.toString().trim().equals("")) {
            return "";
        }
        String string = "";
        CellType cellType = cell.getCellTypeEnum();
        switch (cellType) {
            case STRING: {
                string = cell.getStringCellValue();
                break;
            }
            case BOOLEAN: {
                string = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case NUMERIC: {
                string = String.valueOf(cell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                string = String.valueOf(cell.getCellFormula());
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    public static String isHaveText(String[] strs, String s) {
        for (int i2 = 0; i2 < strs.length; ++i2) {
            if (!oConvertUtils.isNotEmpty(s) || !s.contains(strs[i2])) continue;
            return strs[i2];
        }
        return "";
    }

    public static SimpleDateFormat getFormat(String dataText) {
        SimpleDateFormat simpleDateFormat = null;
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy/MM/dd");
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        SimpleDateFormat simpleDateFormat4 = new SimpleDateFormat("HH:mm:ss");
        SimpleDateFormat simpleDateFormat5 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        switch (dataText) {
            case "date": {
                simpleDateFormat = simpleDateFormat2;
                break;
            }
            case "date2": {
                simpleDateFormat = simpleDateFormat3;
                break;
            }
            case "time": {
                simpleDateFormat = simpleDateFormat4;
                break;
            }
            case "datetime": {
                simpleDateFormat = simpleDateFormat5;
                break;
            }
            default: {
                simpleDateFormat = null;
            }
        }
        return simpleDateFormat;
    }

    public static SimpleDateFormat getDataFormat(String text) {
        SimpleDateFormat simpleDateFormat = null;
        if (text.contains("-") && text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        } else if (text.contains("-")) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        } else if (ExcelUtil.isHave(CommonConstant.ABBREVIATION, text) && text.contains("PM") || text.contains("AM")) {
            simpleDateFormat = new SimpleDateFormat("MMM d, yyyy K:m:s a", Locale.ENGLISH);
        } else if (text.contains(":") && text.contains("PM") || text.contains("AM")) {
            simpleDateFormat = new SimpleDateFormat("K:m:s a", Locale.ENGLISH);
        } else if (text.contains(":")) {
            simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        } else if (ExcelUtil.isHave(CommonConstant.ABBREVIATION, text)) {
            simpleDateFormat = new SimpleDateFormat("MMM d, yyyy", Locale.ENGLISH);
        }
        return simpleDateFormat;
    }

    public static byte[] getImage(String text, String lineStart, Integer width, Integer height, JSONObject styleJson) throws FileNotFoundException, IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        int n = 4;
        String[] stringArray = text.split("\\|");
        int n2 = stringArray.length - 1;
        if (n2 > 4) {
            return null;
        }
        String string = "#FFFFFF";
        String string2 = "#000000";
        int n3 = 10;
        String string3 = JmConst.FONT_FAMILY;
        int n4 = 0;
        int n5 = 0;
        if (null != styleJson && styleJson.size() > 0) {
            object5 = styleJson.get((Object)"bgcolor");
            object4 = styleJson.get((Object)"color");
            object3 = styleJson.get((Object)"font");
            if (oConvertUtils.isNotEmpty(object5)) {
                string = object5.toString();
            }
            if (oConvertUtils.isNotEmpty(object4)) {
                string2 = object4.toString();
            }
            if (oConvertUtils.isNotEmpty(object3)) {
                JSONObject jSONObject = (JSONObject)object3;
                object2 = jSONObject.get((Object)"size");
                object = jSONObject.get((Object)"name");
                Object object6 = jSONObject.get((Object)"bold");
                Object object7 = jSONObject.get((Object)"italic");
                if (oConvertUtils.isNotEmpty(object2)) {
                    n3 = Integer.parseInt(object2.toString());
                }
                if (oConvertUtils.isNotEmpty(object)) {
                    string3 = object.toString();
                }
                if (oConvertUtils.isNotEmpty(object6) && ((Boolean)object6).booleanValue()) {
                    n4 = 1;
                }
                if (oConvertUtils.isNotEmpty(object7) && ((Boolean)object7).booleanValue()) {
                    n5 = 2;
                }
            }
        }
        width = width + 20;
        height = height + 20;
        n3 += 5;
        object5 = new BufferedImage(width, height, n);
        object4 = ((BufferedImage)object5).createGraphics();
        ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ((Graphics2D)object4).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        object3 = new BasicStroke(1.0f, 1, 0);
        ((Graphics2D)object4).setStroke((Stroke)object3);
        ((Graphics)object4).setColor(new Color(Integer.parseInt(string.substring(1, 3), 16), Integer.parseInt(string.substring(3, 5), 16), Integer.parseInt(string.substring(5, 7), 16)));
        ((Graphics)object4).fillRect(0, 0, ((BufferedImage)object5).getWidth(), ((BufferedImage)object5).getHeight());
        ((Graphics)object4).drawImage((Image)object5, 0, 0, ((BufferedImage)object5).getWidth(), ((BufferedImage)object5).getHeight(), null);
        float f2 = 1.0f;
        if (lineStart.equals("lefttop")) {
            ExcelUtil.formTopToBottom(width, height, stringArray, (Graphics2D)object4, string2);
            ExcelUtil.paintingTopFont(width, height, stringArray, (Graphics2D)object4, string3, n3, n4, n5, string2);
        } else {
            ExcelUtil.formBottomToTop(width, height, stringArray, (Graphics2D)object4);
            ExcelUtil.paintingBottomFont(width, height, stringArray, (Graphics2D)object4, string3, n3, n4, n5);
        }
        object2 = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)object5, "png", (OutputStream)object2);
        ((Image)object5).flush();
        object = ((ByteArrayOutputStream)object2).toByteArray();
        ((Graphics)object4).dispose();
        ((ByteArrayOutputStream)object2).close();
        return object;
    }

    public static void formTopToBottom(Integer width, Integer height, String[] split, Graphics2D pen, String lineColor) {
        int n = 0;
        int n2 = 0;
        int n3 = width;
        int n4 = split.length - 1;
        int n5 = split.length;
        int n6 = height / n4;
        int n7 = width / n5;
        int n8 = 0;
        int n9 = 0;
        pen.setColor(new Color(Integer.parseInt(lineColor.substring(1, 3), 16), Integer.parseInt(lineColor.substring(3, 5), 16), Integer.parseInt(lineColor.substring(5, 7), 16)));
        for (int i2 = 1; i2 < split.length; ++i2) {
            n8 = n6 * i2;
            if (n5 > 2) {
                n8 = n8 + n6 / n4 - 10;
            }
            if (i2 > 1) {
                n8 = height;
            }
            if (i2 == n5 - 1) {
                n3 = n7 * (n5 - n9);
            }
            pen.drawLine(n, n2, n3, n8);
            ++n9;
        }
    }

    public static void formBottomToTop(Integer width, Integer height, String[] split, Graphics2D pen) {
        int n = 0;
        int n2 = height;
        int n3 = width;
        int n4 = split.length - 1;
        int n5 = split.length;
        int n6 = height / n4;
        int n7 = width / n5;
        int n8 = 0;
        int n9 = 0;
        for (int i2 = 1; i2 < split.length; ++i2) {
            if (n5 > 2) {
                n8 = height - n6 - n6 / n4;
            }
            if (i2 > 1) {
                n8 = 0;
            }
            if (i2 == n5 - 1) {
                n3 = n7 * (n5 - n9);
            }
            pen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pen.drawLine(n, n2, n3, n8);
            ++n9;
        }
    }

    public static void paintingTopFont(Integer width, Integer height, String[] split, Graphics2D pen, String fontFamily, int fontSize, int italic, int blob, String lineColor) {
        int n = split.length - 1;
        int n2 = split.length;
        int n3 = width / n2;
        pen.setColor(new Color(Integer.parseInt(lineColor.substring(1, 3), 16), Integer.parseInt(lineColor.substring(3, 5), 16), Integer.parseInt(lineColor.substring(5, 7), 16)));
        if (n2 == 2) {
            Font font = ExcelUtil.getJwtFont(fontFamily, italic + blob, fontSize);
            pen.setFont(font);
            double d2 = (double)height.intValue() * 0.3;
            pen.drawString(split[1], n3, (int)d2);
            double d3 = (double)height.intValue() * 0.8;
            pen.drawString(split[0], 4, (int)d3);
        } else if (n2 == 3) {
            Font font = ExcelUtil.getJwtFont(fontFamily, italic + blob, fontSize);
            pen.setFont(font);
            double d4 = (double)height.intValue() * 0.3;
            double d5 = (double)width.intValue() / 1.5;
            pen.drawString(split[2], (int)d5, (int)d4);
            double d6 = (double)height.intValue() * 0.9;
            pen.drawString(split[1], (int)d5, (int)d6);
            double d7 = (double)height.intValue() * 0.8;
            pen.drawString(split[0], 4, (int)d7);
        }
    }

    public static void paintingBottomFont(Integer width, Integer height, String[] split, Graphics2D pen, String fontFamily, int fontSize, int italic, int blob) {
        int n = split.length - 1;
        int n2 = split.length;
        int n3 = width / n2;
        if (n2 == 2) {
            Font font = ExcelUtil.getJwtFont(fontFamily, italic + blob, fontSize);
            pen.setFont(font);
            double d2 = (double)height.intValue() * 0.8;
            pen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pen.drawString(split[1], n3, (int)d2);
            double d3 = (double)height.intValue() * 0.4;
            pen.drawString(split[0], 4, (int)d3);
        } else if (n2 == 3) {
            Font font = ExcelUtil.getJwtFont(fontFamily, italic + blob, fontSize);
            pen.setFont(font);
            double d4 = (double)height.intValue() * 0.4;
            pen.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            pen.drawString(split[0], 4, (int)d4);
            pen.setColor(Color.BLACK);
            double d5 = (double)height.intValue() * 0.24;
            double d6 = (double)width.intValue() / 1.5;
            pen.drawString(split[1], (int)d6, (int)d5);
            double d7 = (double)height.intValue() * 0.8;
            pen.drawString(split[2], (int)d6, (int)d7);
        }
    }

    public static void paintLine(Drawing drawing, ClientAnchor anchor, String lineType, String color) {
        XSSFDrawing xSSFDrawing = (XSSFDrawing)drawing;
        XSSFClientAnchor xSSFClientAnchor = (XSSFClientAnchor)anchor;
        XSSFSimpleShape xSSFSimpleShape = xSSFDrawing.createSimpleShape(xSSFClientAnchor);
        xSSFSimpleShape.setShapeType(1);
        xSSFSimpleShape.setFillColor(0, 0, 0);
        xSSFSimpleShape.setLineStyle(0);
        if (oConvertUtils.isNotEmpty(color)) {
            int n = Integer.parseInt(color.substring(1, 3), 16);
            int n2 = Integer.parseInt(color.substring(3, 5), 16);
            int n3 = Integer.parseInt(color.substring(5, 7), 16);
            xSSFSimpleShape.setLineStyleColor(n, n2, n3);
        } else {
            xSSFSimpleShape.setLineStyleColor(0, 0, 0);
        }
        if (!lineType.equals("lefttop")) {
            xSSFSimpleShape.getCTShape().getSpPr().getXfrm().setFlipV(true);
        }
        xSSFSimpleShape.setLineWidth(1.0);
    }

    public static String dateformat(Date date, String format) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(format);
        return simpleDateFormat.format(date);
    }

    public static int sameNumber(String str, String str1) {
        int n = 0;
        for (int i2 = 0; i2 < str.length(); ++i2) {
            int n2 = str.indexOf(str1, i2);
            if (i2 != n2) continue;
            ++n;
        }
        return n;
    }

    private static Font getJwtFont(String fontFamily, Integer style, Integer fontSize) {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
        if (fontFamily.equals(JmConst.FONT_FAMILY)) {
            fontFamily = "\u5fae\u8f6f\u96c5\u9ed1";
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!fontFamily.equals(stringArray[i2])) continue;
            Font font = new Font(fontFamily, (int)style, fontSize);
            return font;
        }
        String string = "jmreport/font/SIMSUN.TTC,0".substring(0, "jmreport/font/SIMSUN.TTC,0".length() - 2);
        URL uRL = ClassLoader.getSystemResource(string);
        String string2 = "<dependency>\n  <groupId>org.jeecgframework.jimureport</groupId>\n  <artifactId>jimureport-font</artifactId>\n  <version>1.1.0</version>\n</dependency>";
        try {
            InputStream inputStream = uRL.openStream();
            Font font = null;
            try {
                font = Font.createFont(0, inputStream);
            }
            catch (FontFormatException fontFormatException) {
                log.warn("\u5b57\u4f53\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u539f\u56e0\u538b\u7f29\u6587\u4ef6\u635f\u574f");
            }
            Font font2 = font.deriveFont((int)style, fontSize.intValue());
            return font2;
        }
        catch (IOException iOException) {
            throw new JimuReportException("\u8bf7\u5f15\u5165jimureport-font jar\u5305\uff1a\n" + string2);
        }
        catch (NullPointerException nullPointerException) {
            throw new JimuReportException("\u8bf7\u5f15\u5165jimureport-font jar\u5305\uff1a\n" + string2);
        }
    }
}

