/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;

public class GoogleBarCodeUtils {
    private static final int BARCODEHEIGHT = 75;
    private static final int BARCODEWIDTH = 20;
    private static final int FRONT_COLOR = 0;
    private static final int BACKGROUND_COLOR = 0xFFFFFF;

    public static byte[] createCodeToFile(String codeContent, String type, Integer width, Integer height) {
        try {
            int n;
            codeContent = codeContent.trim();
            HashMap<EncodeHintType, Object> hashMap = new HashMap<EncodeHintType, Object>();
            hashMap.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hashMap.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hashMap.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = null;
            if (type.equals("qrcode")) {
                MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
                n = 0;
                n = width > height ? width.intValue() : height.intValue();
                bitMatrix = multiFormatWriter.encode(codeContent, BarcodeFormat.QR_CODE, n, n, hashMap);
                bitMatrix = GoogleBarCodeUtils.deleteWhite(bitMatrix);
                width = bitMatrix.getWidth();
                height = bitMatrix.getHeight();
            } else if (type.equals("barcode")) {
                width = new Code128Writer().encode(codeContent).length;
                int n2 = 1;
                n = width * n2;
                bitMatrix = new MultiFormatWriter().encode(codeContent, BarcodeFormat.CODE_128, width.intValue(), height.intValue(), hashMap);
            }
            BufferedImage bufferedImage = new BufferedImage(width, height, 4);
            for (int i2 = 0; i2 < width; ++i2) {
                for (n = 0; n < height; ++n) {
                    bufferedImage.setRGB(i2, n, bitMatrix.get(i2, n) ? 0 : 0xFFFFFF);
                }
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bufferedImage, "jpg", byteArrayOutputStream);
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static BufferedImage insertWords(BufferedImage image, String words, Integer width, Integer height) {
        if (oConvertUtils.isNotEmpty(words)) {
            BufferedImage bufferedImage = new BufferedImage(width, 75, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            GoogleBarCodeUtils.setGraphics2D(graphics2D);
            GoogleBarCodeUtils.setColorWhite(graphics2D, width, height);
            graphics2D.drawImage(image, 0, 0, image.getWidth(), image.getHeight(), null);
            Color color = new Color(0, 0, 0);
            graphics2D.setColor(color);
            graphics2D.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 18));
            int n = graphics2D.getFontMetrics().stringWidth(words);
            int n2 = (width - n) / 2;
            int n3 = height + 20;
            graphics2D.drawString(words, n2, n3);
            graphics2D.dispose();
            bufferedImage.flush();
            return bufferedImage;
        }
        return null;
    }

    private static void setGraphics2D(Graphics2D g2d) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        BasicStroke basicStroke = new BasicStroke(1.0f, 1, 0);
        g2d.setStroke(basicStroke);
    }

    private static void setColorWhite(Graphics2D g2d, Integer width, Integer height) {
        g2d.setColor(new Color(255, 255, 255));
        g2d.fillRect(0, 0, width + 20, height + 75);
        g2d.setColor(new Color(255, 255, 255));
    }

    public static BitMatrix deleteWhite(BitMatrix matrix) {
        int[] nArray = matrix.getEnclosingRectangle();
        int n = nArray[2] + 1;
        int n2 = nArray[3] + 1;
        BitMatrix bitMatrix = new BitMatrix(n, n2);
        bitMatrix.clear();
        for (int i2 = 0; i2 < n; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                try {
                    if (!matrix.get(i2 + nArray[0], i3 + nArray[1])) continue;
                    bitMatrix.set(i2, i3);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    arrayIndexOutOfBoundsException.printStackTrace();
                }
            }
        }
        return bitMatrix;
    }

    public static void main(String[] args) {
        byte[] byArray = GoogleBarCodeUtils.createCodeToFile("http://www.baidu.com", "barcode", 168, 26);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File("D://images/baidu.jpg")));
            bufferedOutputStream.write(byArray);
            bufferedOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

