/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.common.util;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectResult;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Date;
import java.util.UUID;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.jeecg.modules.jmreport.common.util.CommonUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OssBootUtil {
    private static final Logger log = LoggerFactory.getLogger(OssBootUtil.class);
    private static String endPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String staticDomain;
    private static OSSClient ossClient;

    public static void setEndPoint(String endPoint) {
        OssBootUtil.endPoint = endPoint;
    }

    public static void setAccessKeyId(String accessKeyId) {
        OssBootUtil.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        OssBootUtil.accessKeySecret = accessKeySecret;
    }

    public static void setBucketName(String bucketName) {
        OssBootUtil.bucketName = bucketName;
    }

    public static void setStaticDomain(String staticDomain) {
        OssBootUtil.staticDomain = staticDomain;
    }

    public static String getStaticDomain() {
        return staticDomain;
    }

    public static String getEndPoint() {
        return endPoint;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static OSSClient getOssClient() {
        return ossClient;
    }

    public static String upload(MultipartFile file, String fileDir, String customBucket) {
        String string = null;
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = bucketName;
        if (oConvertUtils.isNotEmpty(customBucket)) {
            string2 = customBucket;
        }
        try {
            String string3;
            if (!ossClient.doesBucketExist(string2)) {
                ossClient.createBucket(string2);
            }
            if ("" == (string3 = file.getOriginalFilename())) {
                string3 = file.getName();
            }
            string3 = CommonUtils.getFileName(string3);
            String string4 = string3.substring(0, string3.lastIndexOf(".")) + "_" + System.currentTimeMillis() + string3.substring(string3.indexOf("."));
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileDir = CommonUtils.filter(fileDir);
            stringBuilder = stringBuilder.append(fileDir + string4);
            string = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + stringBuilder : "https://" + string2 + "." + endPoint + "/" + stringBuilder;
            PutObjectResult putObjectResult = ossClient.putObject(string2, stringBuilder.toString(), file.getInputStream());
            if (putObjectResult != null) {
                log.debug("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + stringBuilder);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return string;
    }

    public static String upload(MultipartFile file, String fileDir) {
        return OssBootUtil.upload(file, fileDir, null);
    }

    public static String upload(FileItemStream file, String fileDir) {
        String string = null;
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        StringBuilder stringBuilder = new StringBuilder();
        try {
            String string2 = file.getName().substring(file.getName().lastIndexOf(46));
            String string3 = UUID.randomUUID().toString().replace("-", "") + string2;
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileDir = CommonUtils.filter(fileDir);
            stringBuilder = stringBuilder.append(fileDir + string3);
            string = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + stringBuilder : "https://" + bucketName + "." + endPoint + "/" + stringBuilder;
            PutObjectResult putObjectResult = ossClient.putObject(bucketName, stringBuilder.toString(), file.openStream());
            ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            if (putObjectResult != null) {
                log.debug("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + stringBuilder);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        return string;
    }

    public static void deleteUrl(String url) {
        OssBootUtil.deleteUrl(url, null);
    }

    public static void deleteUrl(String url, String bucket) {
        String string = bucketName;
        if (oConvertUtils.isNotEmpty(bucket)) {
            string = bucket;
        }
        String string2 = "";
        string2 = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" : "https://" + string + "." + endPoint + "/";
        url = url.replace(string2, "");
        ossClient.deleteObject(string, url);
    }

    public static void delete(String fileName) {
        ossClient.deleteObject(bucketName, fileName);
    }

    public static InputStream getOssFile(String objectName, String bucket) {
        BufferedInputStream bufferedInputStream = null;
        try {
            String string = bucketName;
            if (oConvertUtils.isNotEmpty(bucket)) {
                string = bucket;
            }
            OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
            OSSObject oSSObject = ossClient.getObject(string, objectName);
            bufferedInputStream = new BufferedInputStream(oSSObject.getObjectContent());
        }
        catch (Exception exception) {
            log.error("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + exception.getMessage());
        }
        return bufferedInputStream;
    }

    public static InputStream getOssFile(String objectName) {
        return OssBootUtil.getOssFile(objectName, null);
    }

    public static String getObjectURL(String bucketName, String objectName, Date expires) {
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        try {
            if (ossClient.doesObjectExist(bucketName, objectName)) {
                URL uRL = ossClient.generatePresignedUrl(bucketName, objectName, expires);
                return URLDecoder.decode(uRL.toString(), "UTF-8");
            }
        }
        catch (Exception exception) {
            log.error("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + exception.getMessage());
        }
        return null;
    }

    private static OSSClient initOSS(String endpoint, String accessKeyId, String accessKeySecret) {
        if (ossClient == null) {
            ossClient = new OSSClient(endpoint, (CredentialsProvider)new DefaultCredentialProvider(accessKeyId, accessKeySecret), new ClientConfiguration());
        }
        return ossClient;
    }

    public static String upload(InputStream stream, String relativePath) {
        String string = null;
        String string2 = relativePath;
        OssBootUtil.initOSS(endPoint, accessKeyId, accessKeySecret);
        string = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + relativePath : "https://" + bucketName + "." + endPoint + "/" + string2;
        PutObjectResult putObjectResult = ossClient.putObject(bucketName, string2.toString(), stream);
        ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
        if (putObjectResult != null) {
            log.debug("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + string2);
        }
        return string;
    }

    static {
        ossClient = null;
    }
}

