/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.jeecg.modules.jmreport.common.util.JimuSpringContextUtils;
import org.jeecg.modules.jmreport.common.util.oConvertUtils;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmreportDataSourceCachePool {
    private static final Logger log = LoggerFactory.getLogger(JmreportDataSourceCachePool.class);
    private static Map<String, DataSource> dbSources = new HashMap<String, DataSource>();
    private static Map<String, JmreportDynamicDataSourceVo> dynamicDataSourceVoHashMap = new HashMap<String, JmreportDynamicDataSourceVo>();

    public static JmreportDynamicDataSourceVo getCacheDynamicDataSourceModel(String dbKey) {
        JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = dynamicDataSourceVoHashMap.get(dbKey);
        if (oConvertUtils.isNotEmpty(jmreportDynamicDataSourceVo)) {
            return jmreportDynamicDataSourceVo;
        }
        IJmReportDbSourceService iJmReportDbSourceService = JimuSpringContextUtils.getBean(IJmReportDbSourceService.class);
        JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo2 = iJmReportDbSourceService.getByDbKey(dbKey);
        if (jmreportDynamicDataSourceVo2 != null) {
            dynamicDataSourceVoHashMap.put(dbKey, jmreportDynamicDataSourceVo2);
        }
        log.info("\u83b7\u53d6\u52a8\u6001DB\u6570\u636e\u6e90: {}", (Object)jmreportDynamicDataSourceVo2.toString());
        return jmreportDynamicDataSourceVo2;
    }

    public static DataSource getCacheBasicDataSource(String dbKey) {
        return dbSources.get(dbKey);
    }

    public static void putCacheBasicDataSource(String dbKey, DataSource db) {
        dbSources.put(dbKey, db);
    }

    public static void deleteCacheDataSource(String dbKey) {
        dbSources.remove(dbKey);
        dynamicDataSourceVoHashMap.remove(dbKey);
    }
}

