/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.dyndb;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.mongodb.MongoClient;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoDatabase;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.jeecg.modules.jmreport.common.constant.JmConst;
import org.jeecg.modules.jmreport.common.util.ExcelUtil;
import org.jeecg.modules.jmreport.desreport.service.IJmReportDbSourceService;
import org.jeecg.modules.jmreport.dyndb.vo.JmreportDynamicDataSourceVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;

@Component(value="JmreporNoSqlDbUtil")
public class JmreportNoSqlUtil {
    private static final Logger log = LoggerFactory.getLogger(JmreportNoSqlUtil.class);
    @Resource
    private IJmReportDbSourceService jmReportDbSourceService;

    public List<Map<String, Object>> findList(String sql, String dbKey) {
        JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = this.jmReportDbSourceService.getByDbKey(dbKey);
        List<Map<String, Object>> list = null;
        try {
            if (JmConst.MONGODB.equals(jmreportDynamicDataSourceVo.getDbType())) {
                list = this.getListByMongodb(sql, jmreportDynamicDataSourceVo);
            }
            if (JmConst.REDIS.equals(jmreportDynamicDataSourceVo.getDbType())) {
                list = this.getListByRedis(sql, jmreportDynamicDataSourceVo);
            }
            return list;
        }
        catch (Exception exception) {
            log.info(exception.getMessage());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getListByRedis(String sql, JmreportDynamicDataSourceVo dataSource) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        String string = dataSource.getDbUrl();
        String string2 = dataSource.getDbPassword();
        Jedis jedis = null;
        jedis = string.indexOf(":") != -1 ? new Jedis(HostAndPort.parseString((String)string)) : new Jedis(string);
        try {
            if (StringUtils.isNotBlank((CharSequence)string2)) {
                jedis.auth(string2);
            }
            log.info("redis \u8fde\u63a5\u6210\u529f......");
            String string3 = jedis.get(sql);
            JSONArray jSONArray = JSONArray.parseArray((String)string3);
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                Map map = (Map)jSONArray.get(i2);
                arrayList.add(map);
            }
            ArrayList<Map<String, Object>> arrayList2 = arrayList;
            return arrayList2;
        }
        catch (Exception exception) {
            log.info(exception.getMessage());
            exception.printStackTrace();
        }
        finally {
            jedis.close();
        }
        return arrayList;
    }

    public List<Map<String, Object>> getListByMongodb(String sql, JmreportDynamicDataSourceVo dataSource) {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        try {
            MongoDatabase mongoDatabase = this.getMogodb(dataSource);
            String string = JmreportNoSqlUtil.mongodbCommandFind(mongoDatabase, sql);
            JSONObject jSONObject = JSONObject.parseObject((String)string);
            JSONArray jSONArray = jSONObject.getJSONObject("cursor").getJSONArray("firstBatch");
            for (int i2 = 0; i2 < jSONArray.size(); ++i2) {
                Map map = (Map)jSONArray.get(i2);
                arrayList.add(map);
            }
            return arrayList;
        }
        catch (Exception exception) {
            log.info(exception.getMessage());
            exception.printStackTrace();
            return arrayList;
        }
    }

    private MongoDatabase getMogodb(JmreportDynamicDataSourceVo dataSource) {
        try {
            String string = dataSource.getDbUsername();
            String string2 = dataSource.getDbPassword();
            String string3 = dataSource.getDbUrl();
            Map<String, String> map = this.getDbUrlInfo(string3);
            ArrayList<ServerAddress> arrayList = new ArrayList<ServerAddress>();
            ServerAddress serverAddress = new ServerAddress(map.get("host"), Integer.parseInt(map.get("port")));
            arrayList.add(serverAddress);
            ArrayList<MongoCredential> arrayList2 = new ArrayList<MongoCredential>();
            MongoCredential mongoCredential = MongoCredential.createScramSha1Credential((String)string, (String)string, (char[])string2.toCharArray());
            arrayList2.add(mongoCredential);
            MongoClient mongoClient = new MongoClient(arrayList, arrayList2);
            MongoDatabase mongoDatabase = mongoClient.getDatabase(map.get("dbName"));
            return mongoDatabase;
        }
        catch (Exception exception) {
            log.info("\u6570\u636e\u6e90\u4fe1\u606f\u5f02\u5e38");
            return null;
        }
    }

    private Map<String, String> getDbUrlInfo(String dbUrl) throws Exception {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = dbUrl.lastIndexOf(58);
        int n2 = dbUrl.lastIndexOf(47);
        String string = n != -1 ? dbUrl.substring(0, n) : dbUrl;
        String string2 = n != -1 ? dbUrl.substring(n + 1, n2) : "";
        String string3 = n2 != -1 ? dbUrl.substring(n2 + 1) : "";
        hashMap.put("host", string);
        hashMap.put("port", string2);
        hashMap.put("dbName", string3);
        return hashMap;
    }

    public static String mongodbCommandFind(MongoDatabase mongoDatabase, String queryGt) throws Exception {
        Document document;
        Object object;
        String string = ".*\\.find\\(\\{(.*)\\}\\).*";
        boolean bl = Pattern.matches(string, queryGt);
        if (!bl) {
            throw new Exception("\u6b64\u63a5\u53e3\u4ec5\u6267\u884c\u67e5\u8be2\u8bed\u53e5\uff0c\u4e14\u9700\u8981\u5236\u5b9a\u67e5\u8be2\u6761\u4ef6");
        }
        String string2 = "getCollection\\('(\\w+?)'\\)";
        String string3 = "\\.find\\((.*?)\\)";
        String string4 = "\\.sort\\((.*?)\\)";
        String string5 = "\\.limit\\((.*?)\\)";
        String string6 = "'(\\w+?)':1";
        String string7 = JmreportNoSqlUtil.GetWithRegExps(queryGt, string2).get(0);
        String string8 = JmreportNoSqlUtil.GetWithRegExps(queryGt, string3).get(0);
        String string9 = JmreportNoSqlUtil.GetWithRegExps(queryGt, string4).size() > 0 ? JmreportNoSqlUtil.GetWithRegExps(queryGt, string4).get(0) : null;
        String string10 = JmreportNoSqlUtil.GetWithRegExps(queryGt, string5).size() > 0 ? JmreportNoSqlUtil.GetWithRegExps(queryGt, string5).get(0) : null;
        String string11 = string8.split("\\},")[0] + "}";
        Document document2 = new Document();
        document2.append("find", (Object)string7);
        if (string8.split("\\},").length > 1) {
            object = string8.split("\\},")[1];
            document = JmreportNoSqlUtil.GetWithRegExps((String)object, string6);
            Document document3 = new Document();
            for (int i2 = 0; i2 < document.size(); ++i2) {
                document3.put((String)document.get(i2), (Object)1);
            }
            document2.append("projection", (Object)document3);
        }
        object = Document.parse((String)string11);
        document2.append("filter", object);
        if (string9 != null && !string9.equals("")) {
            document = Document.parse((String)string9);
            document2.append("sort", (Object)document);
        }
        if (string10 != null && !string10.equals("")) {
            document2.append("limit", (Object)Integer.valueOf(string10));
        }
        document = mongoDatabase.runCommand((Bson)document2);
        return document.toJson();
    }

    private static List<String> GetWithRegExps(String s, String regExp) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(s);
        while (matcher.find()) {
            arrayList.add(matcher.group(1));
        }
        return arrayList;
    }

    public String getDbType(String dbKey) {
        JmreportDynamicDataSourceVo jmreportDynamicDataSourceVo = this.jmReportDbSourceService.getByDbKey(dbKey);
        return jmreportDynamicDataSourceVo.getDbType();
    }

    public boolean isNoSql(String dbKey) {
        String string = this.getDbType(dbKey);
        return ExcelUtil.isHave(JmConst.NO_SQL, string);
    }

    public static void main(String[] args) throws Exception {
        URL uRL = new URL("http://127.0.0.1:9040/test");
        String string = uRL.getPath();
        int n = uRL.getPort();
        String string2 = uRL.getHost();
        System.out.println(string);
        System.out.println(n);
        System.out.println(string2);
        String string3 = "127.0.0.1:9040/test";
        int n2 = string3.lastIndexOf(58);
        int n3 = string3.lastIndexOf(47);
        String string4 = n2 != -1 ? string3.substring(0, n2) : string3;
        String string5 = n2 != -1 ? string3.substring(n2 + 1, n3) : "";
        String string6 = n3 != -1 ? string3.substring(n3 + 1) : "";
        System.out.println(string4);
        System.out.println(string5);
        System.out.println(string6);
        System.out.println(JmreportNoSqlUtil.getIP(new URI("http://10.10.14.199:8080/dsideal_yy/")));
        System.out.println(JmreportNoSqlUtil.getIP(new URI("http://127.0.0.1:9040/system/verList?loginName=1&password=AD07FB25AA2D3A9F96EE12F25E0BE902")));
        System.out.println(JmreportNoSqlUtil.getIP(new URI("http://127.0.0.1:9040/test")));
    }

    private static URI getIP(URI uri) {
        URI uRI = null;
        try {
            uRI = new URI(null, null, null, uri.getPort(), null, null, null);
        }
        catch (Throwable throwable) {
            uRI = null;
        }
        return uRI;
    }
}

