/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package com.idrsolutions.image.jpeg2000;

/**
 *
 */
public class EnumeratedSpace {

    private static final byte[] LUT;
    private byte oldC, oldM, oldY, oldK;
    private byte red = (byte) 255, green = (byte) 255, blue = (byte) 255;

    public EnumeratedSpace() {
        
    }

    public byte[] getRGB(byte cyan, byte magenta, byte yellow, byte key) {
        
        if((cyan|magenta|yellow|key)==0){
            return new byte[]{(byte)255,(byte)255,(byte)255};
        }

        if (cyan == oldC && magenta == oldM && yellow == oldY && key == oldK) {
            return new byte[]{red, green, blue};
        }
        oldC = cyan;
        oldM = magenta;
        oldY = yellow;
        oldK = key;

        final int cc = (cyan & 0xff) << 8;
        final int mm = (magenta & 0xff) << 8;
        final int yy = (yellow & 0xff) << 8;
        final int kk = (key & 0xff) << 8;

        final int curC = (cc + 0x1000) >> 0xd;
        final int curM = (mm + 0x1000) >> 0xd;
        final int curY = (yy + 0x1000) >> 0xd;
        final int curK = (kk + 0x1000) >> 0xd;

        int nextC = cc >> 0xd;
        int nextM = mm >> 0xd;
        int nextY = yy >> 0xd;
        int nextK = kk >> 0xd;

        if (nextC == curC) {
            nextC = nextC == 8 ? nextC - 1 : nextC + 1;
        }
        if (nextM == curM) {
            nextM = nextM == 8 ? nextM - 1 : nextM + 1;
        }
        if (nextY == curY) {
            nextY = nextY == 8 ? nextY - 1 : nextY + 1;
        }
        if (nextK == curK) {
            nextK = nextK == 8 ? nextK - 1 : nextK + 1;
        }
        final int gapC = nextC - curC;
        final int gapM = nextM - curM;
        final int gapY = nextY - curY;
        final int gapK = nextK - curK;

        final int pos = 3 * (curC * 729 + curM * 81 + curY * 9 + curK);

        final int cp = pos + gapC * 2187;
        final int mp = pos + gapM * 243;
        final int yp = pos + gapY * 27;
        final int kp = pos + gapK * 3;

        final int L0 = LUT[pos] & 0xff, L1 = LUT[pos + 1] & 0xff, L2 = LUT[pos + 2] & 0xff;

        final int scaleC = (cc - (curC << 13)) * -gapC / 0x20;
        final int scaleM = (mm - (curM << 13)) * -gapM / 0x20;
        final int scaleY = (yy - (curY << 13)) * -gapY / 0x20;
        final int scaleK = (kk - (curK << 13)) * -gapK / 0x20;

        final int r = ((L0 << 8) + (L0 - (LUT[cp] & 0xff)) * scaleC)
                + ((L0 - (LUT[mp] & 0xff)) * scaleM)
                + ((L0 - (LUT[yp] & 0xff)) * scaleY)
                + ((L0 - (LUT[kp] & 0xff)) * scaleK);
        final int g = ((L1 << 8) + (L1 - (LUT[cp + 1] & 0xff)) * scaleC)
                + ((L1 - (LUT[mp + 1] & 0xff)) * scaleM)
                + ((L1 - (LUT[yp + 1] & 0xff)) * scaleY)
                + ((L1 - (LUT[kp + 1] & 0xff)) * scaleK);
        final int b = ((L2 << 8) + (L2 - (LUT[cp + 2] & 0xff)) * scaleC)
                + ((L2 - (LUT[mp + 2] & 0xff)) * scaleM)
                + ((L2 - (LUT[yp + 2] & 0xff)) * scaleY)
                + ((L2 - (LUT[kp + 2] & 0xff)) * scaleK);

        red = (byte) (r < 0 ? 0 : r >> 8);
        green = (byte) (g < 0 ? 0 : g >> 8);
        blue = (byte) (b < 0 ? 0 : b >> 8);

        return new byte[]{red, green, blue};
    }
    
    public static int[] getStaticRGB(int cyan,int magenta, int yellow, int key) {
        if((cyan|magenta|yellow|key)==0){
            return new int[]{255,255,255};
        }
        
        final int cc = cyan << 8;
        final int mm = magenta << 8;
        final int yy = yellow << 8;
        final int kk = key << 8;

        final int curC = (cc + 0x1000) >> 0xd;
        final int curM = (mm + 0x1000) >> 0xd;
        final int curY = (yy + 0x1000) >> 0xd;
        final int curK = (kk + 0x1000) >> 0xd;

        int nextC = cc >> 0xd;
        int nextM = mm >> 0xd;
        int nextY = yy >> 0xd;
        int nextK = kk >> 0xd;

        if (nextC == curC) {
            nextC = nextC == 8 ? nextC - 1 : nextC + 1;
        }
        if (nextM == curM) {
            nextM = nextM == 8 ? nextM - 1 : nextM + 1;
        }
        if (nextY == curY) {
            nextY = nextY == 8 ? nextY - 1 : nextY + 1;
        }
        if (nextK == curK) {
            nextK = nextK == 8 ? nextK - 1 : nextK + 1;
        }
        final int gapC = nextC - curC;
        final int gapM = nextM - curM;
        final int gapY = nextY - curY;
        final int gapK = nextK - curK;

        final int pos = 3 * (curC * 729 + curM * 81 + curY * 9 + curK);

        final int cp = pos + gapC * 2187;
        final int mp = pos + gapM * 243;
        final int yp = pos + gapY * 27;
        final int kp = pos + gapK * 3;

        final int L0 = LUT[pos] & 0xff, L1 = LUT[pos + 1] & 0xff, L2 = LUT[pos + 2] & 0xff;

        final int scaleC = (cc - (curC << 13)) * -gapC / 0x20;
        final int scaleM = (mm - (curM << 13)) * -gapM / 0x20;
        final int scaleY = (yy - (curY << 13)) * -gapY / 0x20;
        final int scaleK = (kk - (curK << 13)) * -gapK / 0x20;

        int r = ((L0 << 8) + (L0 - (LUT[cp] & 0xff)) * scaleC)
                + ((L0 - (LUT[mp] & 0xff)) * scaleM)
                + ((L0 - (LUT[yp] & 0xff)) * scaleY)
                + ((L0 - (LUT[kp] & 0xff)) * scaleK);
        int g = ((L1 << 8) + (L1 - (LUT[cp + 1] & 0xff)) * scaleC)
                + ((L1 - (LUT[mp + 1] & 0xff)) * scaleM)
                + ((L1 - (LUT[yp + 1] & 0xff)) * scaleY)
                + ((L1 - (LUT[kp + 1] & 0xff)) * scaleK);
        int b = ((L2 << 8) + (L2 - (LUT[cp + 2] & 0xff)) * scaleC)
                + ((L2 - (LUT[mp + 2] & 0xff)) * scaleM)
                + ((L2 - (LUT[yp + 2] & 0xff)) * scaleY)
                + ((L2 - (LUT[kp + 2] & 0xff)) * scaleK);

        r =  (r < 0 ? 0 : r >> 8);
        g =  (g < 0 ? 0 : g >> 8);
        b =  (b < 0 ? 0 : b >> 8);

        return new int[]{r, g, b};
    }

    private static final String ColorSpaceProfile
            = "FFFFFFE1E2E4C7C8CAADAEB29395987B7D8063"
            + "6366454647221E1FFFFDE5E2E0CBC8C7B6ADAD9E9594877D7C7163635A46453F2"
            + "11D18FFFBCCE4DFB6C9C6A3AEAC8E96937A7D7B65636250464436201C10FFF9B3"
            + "E6DEA0CBC590AEAA7C9691697D7A5863614546442E1F1C06FFF79AE5DC8ACBC37"
            + "AB0A96B96915B7D794A6460394643231D1A00FFF680E7D972CDC265B0A7589690"
            + "4B7D783C64602C4642181C1A00FFF460E7D957CBC04EAFA742968F387D772B645"
            + "F1D4542071A1A00FFF333E8D733CCBF2BB0A526968E1C7D7611635E0044410018"
            + "1900FFF100E7D700CBBE00B0A400968D007E7500635D00444100181900FCE4EED"
            + "EC9D3C5B4BEAB9CA693858F7B6F7763585E473D4222161AFEE2D5E0C9BFC7B3AB"
            + "AC9B949385807B6E6A625753463B39211512FEE0BFE0C7ACC8B199AD9A8593847"
            + "37B6D5E62564A463B31201509FFDEA8E3C696C8AF87AD99769482637B6D526256"
            + "40453A281F1300FFDD91E3C481C9AE73AD97639481557C6C45625534453A1E1E1"
            + "300FFDB79E3C36DC9AE61AE96539481467C6B37625428453A131C1200FFDA5CE5"
            + "C252CAAD4BAE963F9580337C6A276254184439031A1200FFD936E4C134C9AC2EA"
            + "E9424947F1B7B690E625300443800191200FFD800E5C002CAAB04AD9400947E00"
            + "7C6900625300443800181100F9CCDFDBB5C7C3A0B2AA8C9C9277867B6370624D5"
            + "846343D220B14FAC9C8DDB4B2C59FA1AB8B8B9377787B6263624D4E453334220B"
            + "0AFCC9B4DFB3A2C59F90AA8A7D92756B7A6159624C4545322C200B02FCC79EDEB"
            + "18FC79E7FAB896E93755D7A604C614B3A453224200A00FDC689DFB17BC69C6EAB"
            + "885F9274507A6041614B2F4532191E0A00FEC573E1AF68C69C5CAC874F9373427"
            + "B5F34624A2545310F1D0A00FEC459E0AF50C79A46AC863B9272307A5F24614A15"
            + "4431001B0900FFC339E1AD34C69A2CAC852493711A7B5E0E624A004431001A0A0"
            + "0FEC20FE1AC0CC69907AC84039271007B5D006249004431001A0900F6B2D1DA9F"
            + "BAC28CA6A87A9190687D79556761415145293722000CF8B0BADB9DA6C38B95A87"
            + "98290676F79555B61414745292E220004F9AFA8DC9C96C48B87A979749067647A"
            + "545362413F462927210000F9AF94DC9B85C48A77A978679165577953476141364"
            + "5291F200000F9AD80DE9A73C38966AA775891654A7A533B61402B4428141E0000"
            + "FAAC6CDD9A62C38856AA764991643D7A5230613F2045280B1C0000FAAB55DD994"
            + "CC48843AA753891632C795221613F114428001C0000FBAB3ADE9832C5872BA975"
            + "2292631979510A603F004428001B0000FAAA1ADE9713C4860DA974049163007A5"
            + "100613F004328001A0000F499C2D788ADC0799BA768878F597379486061364B46"
            + "1F31220006F599ADD8889BC0788AA76879905867794755613642451F2A220000F"
            + "6989DD9878CC1787EA7676D8F585C79484C61363A451F23210000F5968BDA867D"
            + "C1776FA76760905750794742603531441F1A200000F6977ADA856CC27660A8665"
            + "19056457847375F3527441E111F0000F89667DA855BC17651A866458F56387846"
            + "2B60351C441F061D0000F79551DA8448C2753EA8653490562A79461D60340D441"
            + "E001C0000F79437DB8332C2752BA76520905516784508603400431E001B0000F7"
            + "931DDA8318C27414A8640B905500784500603400431E001A0000F282B3D672A0B"
            + "E658FA6577D8F486B783A58602A4445112C230000F381A1D7728FBF6580A65771"
            + "8F4960783A4F60293C451225210000F38192D87282C06575A657658F4856793A4"
            + "5602A3445121D1F0000F38082D87273BF6566A556588E484B783A3C5F2A2B4413"
            + "151E0000F47F70D97165C06359A6554B8E483F77393260292344130D1E0000F47"
            + "F60D87056BF634BA656408F48347839285F29184314011D0000F57E4DD87144BF"
            + "643BA655318E472677391A5F290A4314001C0000F47E37D87030BF6328A6551F8"
            + "F47147739065F2A004314001C0000F57E21D9701AC06316A6540B8E4600773900"
            + "5F29004214001B0000F166A7D55A95BD4F85A542738D366277295160193F45002"
            + "61E0000F16695D55A85BD4F77A542678E375877294760193545001F1C0000F166"
            + "87D65A79BE4F6CA5425C8D374E772A3F601A2E4500181C0000F16578D65A6BBD4"
            + "F5FA543538D36447629365F1B274400101B0000F1666AD55A5DBD4E52A443468D"
            + "373A762A2D5E1B1D4302061B0000F2655AD6594FBE4F45A6433B8D372F7629235"
            + "F1B134303001A0000F26648D5593FBF4F38A4432D8D3722762A165E1C06430300"
            + "1A0000F26433D6592DBE4E26A4431E8D3712762A035F1C004204001A0000F3642"
            + "1D65A1BBE4E16A5430D8D3700762B005E1D004205001A0000ED4599D33A87BB33"
            + "79A329698D1C5A760F49600038440021190000EF4389D43C7BBD326EA3295E8D1"
            + "D4F7611415F003045001A190000F0457CD33C6FBC3262A32A558D1F487612395E"
            + "0029440013190000F04670D43D63BC3457A3294A8C1F3E7614305E022044000B1"
            + "80000EF4662D43E56BC354DA42A408C20347614285E0318430003170000EF4755"
            + "D43D4ABB3541A32C368C222B76161E5F030E430000170000EF4643D43E3BBC353"
            + "3A32D2A8D221F7516115E0502420000170000EF4732D53E2BBC3625A42D1C8B22"
            + "107516025E0700410000170000F04722D43F1DBD3618A32E0F8B24027519005E0"
            + "800420000170000ED008CD1007CBA0070A200618D00527600435F003144001B14"
            + "0000ED007ED20071BB0063A300568B004876003A5F002A430014140000ED0172D"
            + "10166BB005AA3004E8B00407600325F002343000D140000EC1066D1075BBA0050"
            + "A200448B003875002B5E001B430006140000EE0F59D10D4FBA0645A2003A8B002"
            + "F7500225D0014420002140000ED144ED20C44BB043BA300318B002674001A5E00"
            + "0B420000140000ED1940D21238BA0B30A204278A001B75000E5D0000420000140"
            + "000EE1930D2162BBA0F23A2081A8C000E7500005D0000410000140000EE1C23D2"
            + "151EBB0F18A208108B01027500005D0000410000160000DBF2FCC3D6E1ACBFC99"
            + "4A5AF7F8E966A777E545F653A4248181B20DEEFE2C4D5CAADBDB496A59E818D87"
            + "6B7671555E5A3A423F151A18DFEDCBC6D3B6AFBCA398A48D818C796B7565555D5"
            + "03A4036151A12E2ECB3C9D2A0B1BB8F99A27D828B6A6C7459555C453A402D1419"
            + "08E3EA99C9D08BB2B97C9AA16B838A5B6C734B555B3A3A3F23111900E5E982CBC"
            + "F74B2B8689AA05A83894C6D723E555A2E3A3F19101800E6E764CACD5AB3B7509A"
            + "9F458388396D712E565A203A3F0A0E1800E6E641CCCC3AB4B6349B9D2C8487236"
            + "E7118565909393E000B1800E8E613CCCC13B4B5119B9D0A8386026D7000555900"
            + "393E000A1700DAD8ECC2C0D3ACABBC9595A4807F8D6A6A7754545E3B394219121"
            + "ADDD6D3C4BFBEAEAAAA969494807E7F6B696A5553543B383A171112DED5BEC5BD"
            + "AAAFA999979385817E716C695E55524A3B383116110BE0D3A8C7BC97AFA887989"
            + "275817C636B67525452403B3729151101E0D291C7BB82B0A675989165817B566B"
            + "67465551353A371F131100E3D07BC8BA6EB1A562998F54827A466C66395550293"
            + "A3614121000E3D061CAB956B1A44D998E41827A366C652A55501B3A3607101000"
            + "E4CE42CAB83AB2A3329A8D2A8379216D6515564F053A36000D1000E4CE1DCAB71"
            + "9B2A3149A8D0F8379056C6400554F003A35000D1000D9C1DDC1ACC6AC99B29585"
            + "9A8072846B5E6F554A593B313D190816DBBFC6C3ABB2AD999F95848B8071776B5"
            + "E6455494F3B303419070EDDBFB4C4AAA0AE989096847D81716B6B5D595549453B"
            + "302D170704DEBD9FC5A98EAE977F97836E81705E6C5D4E55483C3A2F25160700D"
            + "FBC8AC5A87BAF966D97825F826F516C5C415548313B2F1B150700E0BB76C6A769"
            + "B0955D98814F826E446C5B365547263B2F11120700E0BB5DC7A653B0944998803"
            + "E816D336C5A275547193A2E03100800E2BA40C8A539B19332997F28826C1F6C5A"
            + "135546033A2E00100800E3B923C8A51EB09219987F12826C076C5900554600392"
            + "E000E0800D8A9CDC096B8AB86A495749080637C6B5167553F513C27371A000FD9"
            + "A8BAC196A5AC869596748280636F6B515C553E483B272F190006DBA8A8C29596A"
            + "D85879674758062636B5052563E3F3B2627180000DBA694C39585AD8577967367"
            + "8062586B5048553D363B2620170000DCA681C49474AE846797725981614B6B4F3"
            + "C553D2C3B2616150000DEA46EC59363AF835797714B81603F6B4F31553D213A26"
            + "0C130000DEA458C5924FAE824597713A815F2F6B4E23553C143A2600120000DFA"
            + "43FC69137AF8130977027815F1D6B4E10553C013A2600110000DFA324C69120AE"
            + "811A976F11815F076B4E00543C003925000F0000D793C0BF82ACAA74999464857"
            + "F55736B456055334B3C1C32190008D992ADC0829AAB738A9564798054676B4455"
            + "5533423C1C2A190000D9919DC1818CAD737D95646D80545C6B444C55333A3B1C2"
            + "3170000DA918CC1817DAC726E9563608053516B43415433313B1D1B160000DB90"
            + "79C2806CAC71609562538053456B44375532283B1C12140000DC8F68C3805DAD7"
            + "2529662457F523A6B432D55321E3B1C07130000DC8F54C37F4AAD714195613780"
            + "522C6A43205432103A1C00120000DD8E3EC47E35AD702E96612580521A6B420E5"
            + "432003A1C00100000DE8E26C47E22AE701B9660118052066A4200543200391D00"
            + "100000D67BB3BF6E9FA9628F93547C7E466A6B37585527453C0F2D170002D87BA"
            + "1C06E90AA62819454707F465F6B374F55273D3C0F25140000D97A91C06E82AA61"
            + "749554657F46556A37465527353B101E130000D97B83C06D74AB60679553597F4"
            + "64B6A373C55282D3B1017110000D97A72C16D65AC605B95524D8045406A373254"
            + "27233B110E110000DA7A62C26C57AB604D9552417F45346A37285428193B12030"
            + "F0000DB7A50C16C46AC5F3D9552337F45286A371C54270C3A11000D0000DB793B"
            + "C26C34AC602C9552237F44186A370B5428003912000D0000DB7928C16C21AC5F1"
            + "A9551138044066A36005427003912000D0000D563A5BD5794A94C849340737E34"
            + "626A275155173F3C0027100000D66295BF5785AA4C779441677F35586A2748551"
            + "8373C00200F0000D76388BF5779AA4D6C94415D7E354F6A284055182F3B00190E"
            + "0000D76379C0576CAA4D609441527E35456A28375519273B00120D0000D8636AB"
            + "F575FAA4C539441477E353A6A292D551A1E3B00080B0000D8625BC05852AA4D47"
            + "94413C7F3530692924531A153A01020B0000D9634BC05742AA4C3994412F7E352"
            + "4692918531A08390200090000D96239C05731AB4D299341207E3515692908541B"
            + "00390300090000D96228C15722AB4C1B9441137E3506692900531B00390400090"
            + "000D34398BD3A88A8327A9327697F1C596A0E4A5500383B0021090000D5448ABE"
            + "3B7BA9336D94285F7E1E506A10415500303B001B090000D6457DBE3B6FA833639"
            + "429567E1F486A123A5500293B0014070000D74670BE3D64A93458932A4C7E203F"
            + "6A13315401223A000D070000D64663BE3E58A9354D932B417D20356A142854031"
            + "A3A0004070000D64756BE3D4BA93541922B367E212C69151F5304113900000700"
            + "00D74747BF3E3EA93535932C2C7E2221691614530504390000070000D74736BF3"
            + "E2FA93627932C1E7E2314691706530600380000050000D74729BF3F22AA361B93"
            + "2D117E2306691700530800380000050000D20D8CBD017DA7006E9200607E00516"
            + "A00435500333B001C040000D4127EBE0771A800649200567E00496A003B54002B"
            + "3B0016040000D41573BE0D67A8035B92004E7D00416900345400243A001004000"
            + "0D51867BD135BA809529200457D003969002C54001D3A0007040000D51B5CBC15"
            + "51A80E4792013B7D00306900245400153A0004040000D51E50BD1645A8113D920"
            + "5327D002768001B53000C390000040000D61E43BD1939A814329209287D001D68"
            + "0011530002380000040000D62035BD1B2CA91426920D1C7C02116800045300003"
            + "80000040000D62129BE1B21A8171B920D127D0305690000530000380000040000"
            + "B9E5FAA4CCDF92B6C77F9EAE6C889559717D465A642E3E470A1921BDE3E1A8CAC"
            + "994B5B3819D9C6D87865A717146595A2E3E3E081819C0E2CAAACAB697B3A2829C"
            + "8D6E85795B70654759502E3D36071813C2E0B3ADC8A099B290849B7D70856B5C6"
            + "F594758452E3D2D06170AC4DF9BAEC68B9AB07C84996B71835B5C6E4B48573A2F"
            + "3C25041700C6DD83AFC5759BAF6985985B71824C5C6D3F48562F2E3C1A031700C"
            + "8DC68B0C45E9CAF5486974871813B5D6C2F4855212E3B0D001700C9DB49B3C341"
            + "9DAD398796307281275E6C1C48550F2F3B00001600CBDB2AB2C3259DAD2087961"
            + "A7280105E6B064955002E3A00001600BACDE9A5B7D194A3BB808EA36D798C5B65"
            + "7647505E3036420C0F1BBDCCD3A9B6BD97A3A9838D936F797E5C6569484F54303"
            + "63A0B0F13C0CABEABB5AA98A198838D857078715D645E484F4A3035320A0F0BC3"
            + "C9A9ACB39799A087848B757177645D6352484E40303529090E03C3C892AEB3839"
            + "A9F75858A657176565D6246494D35303420080F00C6C77DAFB16F9B9E64858955"
            + "7175475D6139484D2A2F3416050E00C7C665B0B1599B9D4F8688447174385E612"
            + "C494C1E2F340A020F00C8C548B2B03F9D9C3887882E7274255E601A494C0B2F33"
            + "00000E00C9C52DB1AF269C9B1F8787197273115E6005494B002E3300000E00BBB"
            + "7DAA7A5C59593B0817F996F6D845C5A6F494659312E3E0F0416BEB7C5AAA4B197"
            + "929F827F8B706D775D5A6348464E312D350E040FC0B6B3ABA3A1999190847E7D7"
            + "16C6B5D5958494645312D2D0D0506C3B59FACA28E98917F847D6F716B5E5D584D"
            + "49453B302D250B0500C3B48BADA17C998F6E857D60716A515E5842494431312C1"
            + "C090600C4B376AEA06A9A8E5E857C517169445E5736494427302C12050500C5B2"
            + "60B09F569B8D4B867B407269355E572849441A302C05020600C7B246B09E3E9C8"
            + "D36867A2C7268235E56174943082F2C00020600C7B12DB29E289C8C20877A1A72"
            + "68105E56044943002F2C00000700BCA1CCA890B79581A4827090705F7B5D4E674"
            + "A3C51322438100010BEA0B9AA90A5978094846F82705F6E5D4E5C4A3B48322430"
            + "100008C0A0A7AB8F96998086846F75705E645E4D524A3B3F3224280E0000C19F9"
            + "5AC8F86997F77856E67715E575D4D48493B363224200C0000C39F83AD8E75997F"
            + "68846E5A715D4C5D4C3D4A3B2D312417090000C49E71AE8D659B7E59856D4C715"
            + "D405E4C334A3A2331240E060000C59D5CAE8D509A7D47866C3C725C325E4B2549"
            + "3A16302401050000C59D44AF8C3B9B7C33866C29715B205E4B154939053023000"
            + "50000C69C2EB08C289B7C20866B18725B0E5E4B02493900302400030000BD8CBF"
            + "A87EAC96709A8361867052735E42604A314B3319320C000ABF8BADAA7D9A986F8"
            + "A8460797151675E42554A3042321A2A0C0001C08B9DAB7D8C986F7D84606D7151"
            + "5C5E414C4A303A321A23090000C18B8CAC7C7D996E70855F607150525E41424A3"
            + "132321A1C070000C28A7BAC7B6D996E61855F547150465E41384A3028321A1406"
            + "0000C28A69AD7B5E996D53855E46704F3B5E402E4A301F321A09040000C48A57A"
            + "E7A4D996D43855D38714F2E5E4022493012311B00040000C48941AE7A399A6C31"
            + "855D27714F1D5E40124A3003311B00020000C5892FAF7A289B6C20855D17724F0"
            + "E5E4001493000301B00020000BD77B1A86A9F965E8E83517C71436B5E35594A25"
            + "45330B2D060003BF77A1AA6A90985E818451707143605E354F4A253D330D26060"
            + "000C07792AA6A83985E758450657043555E35464A2535320E1F040000C07783AB"
            + "6A75995E6984505971434B5E363D4A262D330E17030000C17672AB6A66995D5A8"
            + "4504E7143415E35344A2524320F10010000C27663AC6959995D4E845042714336"
            + "5E352A4A261B321005010000C27652AD6948995D3F844F3571432A5E351E4A260"
            + "F311000000000C3753FAD69379A5D2F854F2571421B5E350F4926003010000000"
            + "00C3752EAD68279A5C20854F1671420D5E3500492600301100000000BD60A6A85"
            + "593964A84833E737133635E26524A153F330028010000BE6096AA5585984B7784"
            + "3F687133585E26484B1637330021010000C06089AA5579984A6C84405E71344F5"
            + "E27404A173032001A000000C0607AAB566D984B60843F537134455E27384A1829"
            + "320013000000C1606BAB5560984B5484404871343C5E272F4A182032010A00000"
            + "0C1605DAC5552984B48853F3D7133315E2725491917310202000000C2604EAC55"
            + "44984B3B843F317134275E281A49190B300300000000C2603CAD5534994B2C844"
            + "0237034195E280C491A00300400000000C3602EAD55269A4A1F853F1671340B5D"
            + "2800491A002F0500000000BC4399A83A8997317A83276A711C5A5E0D4B4B00393"
            + "30023000000BE448AAA3B7B98326E842960711D505E10424B003132001B000000"
            + "BF457EAA3B70973464842A56711E495F113A4B002A320015000000C04671AA3D6"
            + "4973459842A4D711F405E13324A012332000E000000C04664AA3E5997354D832B"
            + "427020365E142A4A021B310005000000C04757AB3D4D983543832C3970212D5E1"
            + "5214A0413310001000000C1474AAB3E40983537842C2D7122225E161749050730"
            + "0000000000C1463AAC3E3298362A842C207023165D170A4906002F0000000000C"
            + "1462DAC3E2699361F842C157023095E17004907002F0000000000BD1A8DA90F7E"
            + "9602708300617100525E00434B003332001D000000BE1C80AA127297086584005"
            + "871004A5E003C4B002C320017000000BF1E75AA1768980B5C84014F7100435F00"
            + "354B0025320011000000BF2169AA1A5D97125384064670003A5E002D4B001E310"
            + "008000000BF225DAA1B5297144883083D7000315E00264A0017310004000000BF"
            + "2452AA1D4797163F830B347000295D001D4A000E300001000000BF2645AA1F3C9"
            + "71833830E2970011F5D0013490003300000000000C02538AB1F2F98192883111E"
            + "7004135D00074900002F0000000000C0262DAB2124981A1E8312156F07095D000"
            + "04900002F000000000095DAF885C2DE77ADC66697AD568294466C7D355564203B"
            + "470016219AD8DF89C1C87AACB26A969C598085496B703655591F3B3F00161A9FD"
            + "7CA8DC0B57EABA16C958D5A80794A6B64375550203A37001613A1D5B390BEA07E"
            + "AA8F6D947D5C7F6B4A6A59385445203A2E00150BA3D39C90BD8B81A87D6E936C5"
            + "D7E5C4B694C39533A213A25001501A7D38593BC7882A7696E915C5D7D4E4C6840"
            + "3A533021391B001500A9D26C95BB6083A65670904A5E7C3E4D67313A522321390"
            + "F001500AAD15097BA4785A53E728F345F7B2A4D67203A5112213800001500ADD0"
            + "3798BA3186A529728F225F7A194D660E3A51002138000015009AC3E889AECF7A9"
            + "CB96988A359748C496175384C5E233342000D1C9EC2D18DAEBB7D9BA76D87925B"
            + "747D4B6069394B53233239000C15A1C1BD90ADA9809A976E86845D73714D5F5E3"
            + "A4B4A233232000C0DA4C0A891AB978199866F85755E72644C5F523A4B4024322A"
            + "000C05A5BF9393AA838298757184665F71564D5E473A4A36233221000D00A7BD7"
            + "E94A9718497647183566070494D5D3B3B492B233117000C00AABD6896A85B8596"
            + "51728245606F394E5C2E3B491F23310B000D00ABBC4E98A84486953C738232606"
            + "F294E5C1D3C490F233100000C00ADBB3799A72F869527738121616E184F5C0D3C"
            + "4800233000000C009DAFD98B9DC47D8DAF6D7A995C68844C566E3B4358252B3D0"
            + "10117A1AEC4909CB07F8C9E6E79895E68764D55623B434E252B35000210A3AEB2"
            + "929CA0828B8F70797C5F676A4E55583C4245252A2E000207A6AD9F939A8E828A7"
            + "F71786F60675F4E544D3C423B252B25000200A6AC8B949A7D8389707178606066"
            + "514E54423C4132252A1D000300A7AB7895996B85895F7276516165454F54383C4"
            + "128252A13000300AAAA6397985786884D7376426165374F532A3D411C252A0700"
            + "0300ACAA4B9897418687397375306164264F531B3D400C242A00000300ACA9379"
            + "A972E87862874742061631550520A3D4000242900000300A09ACB8F8BB67F7CA4"
            + "6F6B8F5F5B7A4E4B673C3951272138010012A39AB8928AA5827B94716B81605A6"
            + "E4F4A5C3D3848272230020009A59AA7938995837A86726A75605A644F4A523D38"
            + "40272128020001A69996958985847A77726A68615A584F4A483D3837272221000"
            + "000A8988495887584796872695A61594C4F493E3D382E262219000000A9977296"
            + "876585795A72684D6159415049333D3824262210000000AA965E9787538678497"
            + "3683E6258335048273D3818262203000000AC964899863F87773773672D625824"
            + "5048183D3709262200000000AC963699862F87772674671E6257155048083E370"
            + "0252200000000A286BE9178AB816C99715D86614E73503F603E2E4B2917330000"
            + "0BA586AD93789A836B8A725C78614E67503F553E2E4228172B000002A6869D947"
            + "88C846A7D725C6D614D5D513F4D3E2E3A281824000000A8858C95777D846A7073"
            + "5C61624D52513E433E2E3228181D000000A8857B96776E856A61735B54624D465"
            + "13E393E2E29281814000000A9846B96765E856954735B48624C3C503E2F3E2E20"
            + "27190B000000AB845998764F876945735A3A624C2F503E243E2E1527190000000"
            + "0AB844599753C876834745A2A624C21513D153E2E06261900000000AC84369976"
            + "2D876826745A1C624C12513D063E2E00261900000000A473B192679F825B8F724"
            + "E7D61416B5133593F224529092E000004A673A1946790845B81734E7062416051"
            + "334F3F233D290B26000000A77392966683845B75734E656241565133473F23362"
            + "90C20000000A87284966776855B69744E5B62404C52333D3F242E290D18000000"
            + "A97274966667865A5B744E4F6241425133353F2425280E11000000A9726597655"
            + "9865A4F744D4362403851332C3F241D280F07000000AA725598654B875A41744D"
            + "3662402C5133203F2411270F00000000AC714298653A875931744D2863401E513"
            + "3123E2403261000000000AB713399652C885924744D1C6340125133053E240026"
            + "1000000000A55EA6935293844884733D736231635224524013402A0029000000A"
            + "75D96965386854978743E68633158522448401437290021000000A95D8996537A"
            + "86496D743D5E63325052254140153129001B000000A95E7B96536E854961743D5"
            + "36332465226393F172A290014000000A95E6D965461864955743E4963333D5126"
            + "303F172129010B000000AA5E6096535486494A743D3E633233522627401718280"
            + "304000000AB5D4F98524687493D743E3362332851261C3F180E270400000000AB"
            + "5E4098533787492F743E2562321B51260F3F1801270400000000AC5D3399522A8"
            + "74923753E1A6333105127033F1900260500000000A64499943B8985317973276A"
            + "631C5B520D4B41003A2A0024000000A8448B963B7C86326E742860631E5152104"
            + "240003229001D000000A9457E963B71863365752A57641E4952113B41002B2900"
            + "17000000A94673963D66863459742A4D63204152133440002429000F000000A94"
            + "665963D5A86344F742B4463203752152B40021C290006000000AA4659973E4F86"
            + "3545742C3A63212E511522400314290002000000AA474C983E42863539742B2E6"
            + "3212452161840050A280000000000AB463D983E3487352C742C2363221852160C"
            + "3F0600270000000000AB4731993E29873621752D1962220D5117003F070027000"
            + "0000000A7218E95187F860A7174006164005353004441003428001E000000A921"
            + "81961A7386116674035964004B53003C41002D280018000000A92476971B68861"
            + "35D740750640043530036410026290011000000A9276B961E5E861654740B4763"
            + "003B53002E40001F280009000000A9275F971F53861849740F3E6401335300264"
            + "00018280005000000A92953972149861A4075113663042A52001E400010280001"
            + "000000AA2A4798223E861C3575132C6306215200153F0004270000000000AB2A3"
            + "B982332861D2A7515206309165200093F0000260000000000AC2A30982428871D"
            + "20751517630A0C5200003F00002600000000006BCFF660B9DC56A5C44990AB3C7"
            + "B932E677D20526409384700142173CEDD68B8C65CA4B24E8F9A407B8533666F22"
            + "51590A383F00141B7ACCC86CB7B45FA3A1528E8C447A7836666524514F0B38370"
            + "014147DCBB36FB5A061A28F558D7C46796B3765592650450E372E00130A80CA9C"
            + "71B48C66A17D578C6C47785C38644C274F3B0E372600140384C88775B379679F6"
            + "A588B5D49774F396441294F310F361C00130086C86F77B262699E57598A4C4A76"
            + "403A6333294E2510361100130089C7557AB14B6C9E425B89384B762E3B62232A4"
            + "E161036030013008CC63E7DB1376D9E2F5C89284C75203B62152A4E0610360000"
            + "120076BAE76AA7CE5D95B85182A1436F8B365C7527485D113042000A1D7BB9CF6"
            + "EA6BA6294A7558191476F7D385C68284853123039000A1680B8BC71A5A8669397"
            + "588083496E713A5B5E2A474A13303200090F83B7A874A497689286597F75496D6"
            + "43A5A532A474114302A00090586B69478A3836991765A7E664B6C563B5A482B47"
            + "37132F2200090088B5807AA2736B90665C7D574C6B4A3D593C2C462D142F18000"
            + "8008BB46A7CA15F6D90535D7C474D6B3C3D592F2C4621142F0D0008008EB3527D"
            + "A0486F8F3F5E7C364D6A2C3D58202C4512142E000008008FB33E7FA0366F8E2F5"
            + "E7C274E6A1D3E58122D4503142E000008007CA7D87096C26386AE577599496483"
            + "3A526E2B405817283D00001881A6C37496AF67869E5974894B63763C52622C3F4"
            + "E17283500001184A6B17795A06A858F5A737C4C636B3D51582D3F4518282E0000"
            + "0988A69F79948F6B847E5C736F4D625E3E514E2E3F3C1728260000008AA48C7A9"
            + "37D6C836F5D72614F62523F50432E3E3218281D0000008BA37A7C926D6E83605E"
            + "72534F61463F51392E3E291828150000008DA3657E915A6F824F5F71444F60383"
            + "F502C2F3E1E17280A00000090A24F7F914670813C5F70334F6029404F1E2F3D0F"
            + "17280000000091A23C81913471812E6070254F5F1B404F102F3D0117270000000"
            + "08393CA7585B56977A25B678E4D577A3E47662F36511A1F380000128793B77884"
            + "A46B76935D66804E576E3F475C2F36481A1F3000000A8A93A67B83956C76855E6"
            + "6744F56644047523036401B1F290000028B92957C83866F75775E65674F565840"
            + "46483035371B1F210000008D92847D83756F75685F655B50564D41463E30352E1"
            + "A1F190000008F91737E826570745A60644E5055414146343135251B2011000000"
            + "90906080815570734B61644051553441452831351A1A1F0500000092904C81814"
            + "372733A61633052542642451B31350C1A200000000092903B82803372722B6263"
            + "2352541942450D3135001A20000000008781BD7A73AA6B67985E59854F4A72403"
            + "C5F312B4B1D143300000C8A81AB7C73996E678A5F5978514A67423C56322C431C"
            + "152B0000038C819C7D738C6F677D60596D514A5D433C4C322C3B1D16240000008"
            + "E808C7F737D706670615861524A53433C43322C331D161D0000008E807C7F726F"
            + "716662625855524A47423C3A322C2A1D1615000000907F6C80726071655562574"
            + "9524A3D433C30322C211C170C000000917F5B81725173654762573C524930433B"
            + "25322C161D1701000000937F4982713F73653762572D534923433B18322C0A1C1"
            + "800000000937F3A83713173642A635621534917433B0A322C001B18000000008A"
            + "6EB17C639F6E588E604B7D523E6B4230593321461E082E0000058E6FA07F63907"
            + "15882624B70523E6044315033213D1E0A270000008F6F92806383725876624B65"
            + "533E564431473421361E0B20000000906F8480637671586A634B5B533E4D44313"
            + "E34222E1E0C19000000906F7581626872575C634B50533E434431353322261E0D"
            + "12000000916F6782625B725750634B44533F3944322D33221E1E0E08000000926"
            + "E5783624C735743634B38533E2D4431213423131E0F02000000946E4683623C74"
            + "5634634A2B543E214531153423061D0F00000000946E38846130755728644B1F5"
            + "43E164431093323001C0F000000008E5BA67E5094714784623B73532F63452252"
            + "3511402000290000008F5B96805187724778633C6855305945234935133820002"
            + "2000000915B8981517A73476D643C5E55305145234135133120001C000000925C"
            + "7C82516E734762643C5455314745243935152A200015000000935B6E825161734"
            + "756643C4A54313E45243035162220000D000000935C6182515574484C643C3F55"
            + "313445252835161A1F0105000000945C5283514774473E643C3554312A45251E3"
            + "417101F0200000000945B43845139754731643C2754311E4525123417021E0200"
            + "000000955B3684512E764727653C1D5531134525063417001D03000000008F449"
            + "9803B8973317A63276B551C5B460D4B36003A20002400000092448C833B7D7433"
            + "6F642861551D52460F4336003220001D00000093447F833B72753366652958561"
            + "E4A46113C36002C200017000000934673833C6774345B642A4E55204146133536"
            + "0126200011000000934667833D5B753551652B4556203946142C36021E2000070"
            + "0000094465B843D50753446652B3B55213046152435041620000300000094464E"
            + "843E4475353A652B3055222646161A35060C1F0000000000954740843E3676362"
            + "E652C2555221B45170F3507011E0000000000964635863D2C763624652C1C5523"
            + "114517043408001E000000000091268F821D80751272650362570054480045360"
            + "0351E001F000000932682841E7475166765085957004C48003E36002E1E001800"
            + "0000942877841F6975175E650D515700444700373600271E0012000000942A6C8"
            + "42260751955660F4956023C47002F3600211E000B000000942B60852355751C4B"
            + "6612405705344700283600191E0005000000952C5584244B761D4265143756082"
            + "C4600203500121D0002000000952D4A852540761F3766152D550A224600163500"
            + "061C0000000000962E3D852734761F2C661722550C1846000C3400001C0000000"
            + "000962E3385282A772023661819550D0E4600013400001B000000000035C6F431"
            + "B1DA299EC3208AAB1676930B627C004E6400364700122245C4DC40AFC4369DB02"
            + "D899A20758513626F004E5900353F00111B50C3C645AFB33C9C9F32888B267478"
            + "196265044D5000353700111554C1B14BAD9F409B8E37877C29746B1B6159094C4"
            + "600352F00110B59C19D4FAC8C469A7D39866D2C735C20604C0D4C3B0034270010"
            + "045EBF8755AB7948986C3C855E2F7250205F410F4C3100341D00100062BE7157A"
            + "A644C98593E844D317141235F34124B25003412000F0067BE595AA9504E974640"
            + "843C337131255E26144B19003405000F006ABD455DA93D50973542832D3471242"
            + "55E19134A0B003300000F004CB2E5449FCD3D8EB7327CA0286A8A1C58740C455D"
            + "002D4200051D56B1CF4E9EB8438EA6387B912D6A7D1F5869104553002D3A00061"
            + "65DB0BB519EA8478D963D7B832F697123575E14444A002D3300051062AFA8549D"
            + "964B8C863F7A75326864255753154441002D2A00040764AE95599B844C8B75417"
            + "966356857275648174337002D2200030067AD825C9B73508A6644785835674B28"
            + "563D18432D002D190003006BAC6C5F9A6052895546774937663D2A55311943220"
            + "02D0E0003006EAC5661994C55894346773938662E2A54231A4215002C01000300"
            + "70AB4362993B56893447772C3A66222C55161B4207002C000003005AA0D75190C"
            + "14681AD3D7097315F83254F6D163D5700263D00001960A0C2568FAE4B809D4170"
            + "89355F75284E62193C4E002635000011649FB1598F9F4F808F436F7C375F6B2A4"
            + "E591B3C4602262E000009689E9F5C8E8F517F7F456E6E385E5E2B4E4E1C3C3C02"
            + "26260000016B9D8C5E8D7D527E70476E613B5E522D4D431D3B3304251E0000006"
            + "E9C7A618C6D557D61486D533A5D472D4D391D3C2A0526160000006F9C67638B5B"
            + "577D51496C453C5C3A2E4D2D1E3B1F05260C000000739C52658C49587C3F4A6C3"
            + "53C5C2C2E4C201F3B12062500000000749B41668B3A597C314B6C293D5C20304C"
            + "151F3B06052500000000648DC9587FB54F72A245638E39537A2C44661E3351071"
            + "C38000013698DB65E7FA35372924762803B536E2E445B1F33480A1C3000000B6C"
            + "8DA6607F955571854962743C53632E44522033400B1D290000026F8D95627E865"
            + "870774A61673D53583043482133380B1D22000000708C84647D765970694B615B"
            + "3E524D31443E21332F0C1D1A000000738C74667D675A6F5B4C604E3E524131433"
            + "42233260D1D12000000758B61677C575B6F4D4E60413F513631432922331B0C1D"
            + "07000000778A4E697C455C6E3C4E5F3241512832431D22330F0D1E00000000788"
            + "A406A7C365D6E2F4E5F2641511D3242112232020D1D000000006B7CBD606FA955"
            + "63984955843D477230395F22294B0E123300000D6F7CAB646F995863894B55783"
            + "F4867323A552429420F132B000004717C9C656F8B5A637D4D556D40475D33394D"
            + "242A3B111425000000737C8C676F7D5A63704E5561404752343943242A3210141"
            + "E000000757B7D686E6F5C62634F5556414748333A3B252A2B111516000000767B"
            + "6E696E615D62564E544A42473E343931252A2211160E000000787B5D6A6D525E6"
            + "14850543D424732343926252A18111602000000797A4B6C6D425F613A50543042"
            + "472534391A252A0C1016000000007A7B3E6C6D345F612D51542443461A34390E2"
            + "52A000F1600000000716BB166609F59558D4E487C413C6B342E59251E4612052E"
            + "000006746BA06860905C5581504870433C60352F50261F3E130727000000766B9"
            + "36960835D5576504865433C57362F47271F36130820000000776B846A60765E55"
            + "6A51495B433C4D362F3F27202F140919000000776B766A5F695E555D514850443"
            + "C44362F36272027140B12000000796B686B605C5F5450514845443D3A36302E27"
            + "211F140C090000007B6B586C5F4D605444524839443C2E362F23272114130D020"
            + "000007B6A486E5F3F60543652482D453C23373017272109120E000000007D6A3C"
            + "6E5E3262542A534822453C1937300C272100110D000000007659A5694F945D458"
            + "4513973442D63372052290F401500290000007859966B4F87604579523A69462E"
            + "593822492911381500220000007959896C4F7B60456D523A5F462F51382242291"
            + "23115001C0000007A5A7C6D4F6E604563533A55462F4838233A29132A15001600"
            + "00007B5A6F6E4F62614557533B4B462F3F38233229142315000E0000007B5A626"
            + "E4F5761464C543A4046303538242928151A1500050000007D59546F4F49614540"
            + "543B3646302B38241F2816111401010000007D5945704F3C624633543B2A46302"
            + "03824142916051302000000007E5939704F31634629543B2046301638240A2816"
            + "0012020000000079439A6C3A8A61327C54276B471C5C3A0C4C2B003B140025000"
            + "0007C448C6F3B7E623270542862471D533A0F432A003314001E0000007C44816F"
            + "3B72633366562958471E4B3A113C2A002D1400180000007D46746F3C6763335C5"
            + "5294F471F423A13352A03261400110000007D46686F3D5D633451552B4548203A"
            + "3A142D2A041F1400080000007E465C6F3D51633447552A3C4721313915252A061"
            + "71400030000007E464F703D4663353C552B3247212739161C29070D1300000000"
            + "007F4742713E38643530562C2747221D391712290802120000000000804637723"
            + "E2E643627562C1E4722143917072909001200000000007C29916F208063177256"
            + "0A644900553C00472B00361100200000007E2A83712175641968560E5A49004D3"
            + "C003F2C002F1200190000007F2B7871226A651A5F5611524902453B00382B0029"
            + "1200130000007F2D6D712561651C5556134A49053D3B00302B002213000B00000"
            + "07F2E62722656641E4C5715414909363B00292B001A1200050000007F2F577127"
            + "4C651F43561638480B2D3B00212B001312000200000080304B722741652138561"
            + "72E480C243A00182A000911000000000081303F72293666212E571824480E1A3A"
            + "010E2A000210000000000080303572292C66222557191B480F113A01032900000"
            + "F000000000000BDF200A9D90097C20084AA007193005E7B004A63003347000F22"
            + "01BBDB01A7C30096AF008399007184005E6F004A5900323F000D1C01BAC601A7B"
            + "200959E00828B006F77005D64004A50003237000D1601B9B001A59F01948E0081"
            + "7B006F6A005D5900494600322F000D0D01B89D01A48D01937D00806E006E5D005"
            + "C4D00493C003227000C0519B68919A37A11926D008060006E51005C4200493300"
            + "321E000A002AB57223A3661E915B0E7F50006D43005B35004827003213000A003"
            + "4B55C2BA253209149137E3F006C34005A2800481B003207000A0039B54A30A242"
            + "259039187E31076C28005A1D00480F003100000A0001AAE30198CB0088B600779"
            + "F00658900547300415C002B4200011D01A9CE0197B80188A500769000667D0054"
            + "69004153002B3A0000161DA8BA1597A70E879604768300657000535E00414B002"
            + "B3300001029A7A72196961F8686137575046464005353004141002A2B00000830"
            + "A7952995852185761974670D6358005349004138002A230000003AA5823194732"
            + "A84671F735912634B00523D00402E002A1A0000003EA46E3793612D845723734B"
            + "16623F055232004024002A1000000045A4593C934E32834625723B1A62310A512"
            + "5004018002A0400000047A4473F933F35833728722F1C62260D511A00400C002A"
            + "000000001C99D6188AC1177BAB106B96005B82004B6D003A5700233D000019309"
            + "9C2298AAE227B9C1B6B88105B75014B6200394E0023350000113799B12F899E2A"
            + "7A8E216B7C165B6A064B5800394600232E0000093D989E35888F2D7A7F246A6F1"
            + "85A5E0A4A4E00393D00232700000243978D3B877E3179702769621D5A530E4A44"
            + "00393400231F00000047967B3E876E3678622A69541F5947104A3A00392B00231"
            + "60000004A966940865C3778532D684722593B14492F00392000230D0000004E95"
            + "5445864B3B78422F673822582E16492201391400230100000050954546853D3C7"
            + "73531672C24582317491802380A0023000000003A88C8327AB42D6DA2265E8D1B"
            + "50790F4166003051001A380000134288B63B7AA3346D922A5E8020506D14415B0"
            + "23048001A3100000B4688A53E7A95376C852E5E74235063154152043140001A29"
            + "0000034C87954279853A6C77305E67244F58174149073138001B220000004E878"
            + "54578763C6B6A325D5C274F4D1A413F08312F001B1A0000005286754778683E6B"
            + "5C335D4F274E421B40350A3027001B12000000548663497757406A4D355C422A4"
            + "E371C402A0B301D001C090000005785514C7748426A3E375C342B4E2A1D401F0C"
            + "3011001C000000005886434D773A446A33385C2A2C4E201E40140C3006001C000"
            + "000004978BD406BA83960972F52852645721A375F0B274B00103300000E4E78AB"
            + "456B993E5F893352772845661D37550F274200112C00000451789C476B8C405F7"
            + "D35526D2A455D1F374D10273B00122500000055788D4A6B7E415F703652612B45"
            + "5220374311273300131E00000056777E4C6A70425F643851552D454821373B122"
            + "82B00131600000059776E4E6A62455E5738514B2E443E21373112282300140F00"
            + "000059775F506A53465E493A513F2E44332237271328190014040000005C764E5"
            + "26A44465D3B3B51312F442722371C13280E0014000000005D7641526937485D30"
            + "3C51272F441D2237121428020014000000005368B14A5D9F41528E38467C2D396"
            + "A212C59141C4601042E0000085668A14E5D914452803A4670303A60232D50151D"
            + "3E0106280000005968934F5D834552763B46662F3A57242D48171D37030721000"
            + "0005A6884505D7747526A3C465B303A4D252D3E171E2F04071A0000005C687652"
            + "5D6948525D3D4550323A44252D37171E270408120000005E6869525C5D4852523"
            + "D4646323A3A262E2E171F1F060A0B0000005F685A545C4F4A52463E463A323A30"
            + "252E24171F16040B0300000060674A555C414B51383F462F323A25262E19181F0"
            + "B030B0000000061673E565C354C512D3F4524333A1B262E0F171F00030B000000"
            + "005A57A5514D944843843E3774322C63271F52190E4001002A0000015D5796534"
            + "D874A43793F3869342D5A28204A1910390300230000005F578A554D7B4B436D3F"
            + "395F352D512921421A113204001C0000005F587C554D6F4B43633F3956352D482"
            + "9213A1A122B050116000000615870574D644C445840394C352E3F2922321A1323"
            + "05020E000000635763574E584C444D413941352E3629232A1B141B06020500000"
            + "0645755584D4B4D4441413936352E2C2923201B1513050302000000645847594D"
            + "3D4E443542392C352F212923161B150705030000000065573C5A4D344F442C423"
            + "A22352F1929230D1A160005030000000061439B563A8A4D327D42276C371C5C2B"
            + "0C4C1D003B02002500000063438D583B7F4E3271442862381D532C0F441D00340"
            + "3001E000000644481593B73503367442959381E4B2C103D1E002D040018000000"
            + "6445765A3C6850335C43294F381F422C12351D02260400120000006545685A3D5"
            + "D4F3352432A4638203B2C142E1D041F06000900000066455D5A3D53503448442A"
            + "3D3821322B14261D05170700040000006646505B3D4750343D442B333820282C1"
            + "51D1E060E0700000000006746445C3D3A513532452B2938221F2B16131D070307"
            + "00000000006846395C3D30523528452B203822162B170A1D08000600000000006"
            + "52D915B2381501A74450F653B00562E00471F0037000021000000682C845C2476"
            + "521C6947115B3A034D2E003F1F003002001A000000682E795D256B521E6046145"
            + "33A06462E003920002904001400000068306E5D2862521F5746164A3B093E2D00"
            + "311F002306000D0000006830635C295852204D4617413A0B362E002A20001B070"
            + "0050000006932585D294D5222444718393A0D2E2D01231F001507000200000069"
            + "324C5E294253223947192F3A0F252D021920000B0700000000006A32405E2A375"
            + "3232F471A263A101B2D04111F00040700000000006A33365F2A2D532326471B1E"
            + "3A10132D05071E000006000000000000B5F000A2D80090C1007EA8006D92005B7"
            + "B00476200304700092200B3DA00A1C30090AE007E99006C84005A6E0047580030"
            + "3F00081D00B2C5009FB1008F9F007D8B006B77005A6300474F00303700081600B"
            + "1B1009E9E008E8D007C7B006B6A00595800474600302F00080E00B09D009E8D00"
            + "8D7E007B6D006A5D00594E00463C002F2700070500AF8A009D7B008D6E007B600"
            + "0695100584300463300301E00060000AD73009B68008C5C007A50006943005837"
            + "004528002F1400060000AD5E009B55008B4B00794000683500582A00461C002F0"
            + "900060000AD4C009B46008A3D007A3500682C005720004512002F0000060000A4"
            + "E20093CB0083B500729E006188005073003F5C00284100001E00A2CD0091B8008"
            + "2A400728F00617C005168003F5300283A00001700A2BB0091A700829600718300"
            + "607000505D003E4A00283200001000A0A70090960081860070740060640050520"
            + "03E4100282B00000700A094008F85008076006F67006058005049003E38002823"
            + "000000009E82008E75007F68006F59005F4C004F3E003E2E00281A000000009E6"
            + "F008D63007F58006F4C005F3F004F33003E25002812000000009E5B008D51007E"
            + "48006E3E005E32004F27003E19002805000000009D4A008D42007E3B006E31005"
            + "E28004E1D003D0F0028000000000094D60085C00077AB00679600578100486C00"
            + "375600203D0000190093C10084AD00769B00678800577400486200374E0020350"
            + "000110093B000849E00768E00667C00576A00485800374500212E00000900929F"
            + "00838E00757F00666F00575F00474F00373D00212700000200918C00827E00757"
            + "000656200565300474400373400211F00000000907C00826F0074630065540056"
            + "4800473B00372B00211700000000906A00815E00735300654800553C004730003"
            + "72200210E000000038F5600814D00734400643A00553000462400361600210300"
            + "0000128F480D803F00733900642F00552500461A00360D0021000000000084C80"
            + "076B30069A1005B8C004C79003E65002E510018380000130083B60076A3006992"
            + "005B80004D6E003E5B002E4800193000000B0083A5007595006885005B74004D6"
            + "3003E52002E40001929000004008395007486006877005B68004D59003E49002E"
            + "380019220000000A828502747700686A005A5B004C4E003E40002E30001A1B000"
            + "0001782761474680D675D03594F004C43003E36002E27001A130000002181651B"
            + "735913674F095943004B38003D2B002E1D001A0A0000002980532373491B66400"
            + "F5937004C2D003E21002E12001A000000002B814526733D1E663611592D024B22"
            + "003D17002E09001A000000000174BC0168A8005C97004F8400427100345E00244"
            + "B000E3400000E1174AB1068990E5C89084F7700436600355500254300102C0000"
            + "041F749B1B688C155C7D0D4F6D03425D00354D00253B00102600000025738D1E6"
            + "77E1A5C70104F6205425300354300263300111F00000029737E2567701F5C6416"
            + "4F560A424800353B00262C00111700000030736F296663225B58184E4C0E423F0"
            + "0353200262400120F00000033735F2E6655255B4A1A4E3F10423400352800261A"
            + "0012050000003772502F6645285A3C1E4E3313422903351D00260F00110000000"
            + "038724232663A285B32204E291242200435150026050011000000002766B2255A"
            + "9F1E4F8E15447C0E376A002A59001A4600042E0000083066A12A5A91234F801A4"
            + "470133760032B4F001B3E0006280000003266932C5A84254F761E446614385707"
            + "2B48001C370006220000003565852F5A76294F6A20445B15384E092B3F001C2F0"
            + "0061A00000039657732596A2A4F5E224351183844092C37001D28000613000000"
            + "3C6469325A5E2D505324444718383B0B2C2E001D2000070C0000003F655B375A5"
            + "02E4F4625443B1A38310C2C25011D1700070300000040654B385943304F392544"
            + "301B38250F2C1A001D0C0007000000004265403A5937314F2F2744261B381D0E2"
            + "C12011E020007000000003956A5334B942D41852636741C2B64101D53000D4000"
            + "002A0000033C5697374B872F42792737691E2C5A121F4A0310390001230000003"
            + "E568B384B7B31426E28375F1E2C51131F4204113300011D00000041567D384C70"
            + "3142632737561F2C4813203B05122C0001170000004356713A4B6433425829384"
            + "D1F2D4014203306122300010E0000004556633D4C5834424E2B3842202D371421"
            + "2A07131B0001060000004556563D4C4B3543422B3837212D2D152222081414000"
            + "2020000004756483F4B3E3642372D382D212D2316221707140800020000000047"
            + "563E404B3537422E2D3824212E1B16220F08140000020000000045439C3D3A8C3"
            + "5327D2D276C231C5D190C4D0C003B00002500000047448E3F3B7E3832722F2862"
            + "251C541A0F440C003500001E0000004844823F3B743832682F285A261E4B1B103"
            + "D0D002E000018000000494576413B6939335C2F2950251E431A12350E01270000"
            + "120000004A456A413C5D393352302946261F3B1A132E0D022000000A0000004C4"
            + "55F423D543A3449302A3D2520321A14260E04180000040000004C4551443C483A"
            + "343E302A332620291B151E0E04100000010000004C4544443D3C3C3433312B292"
            + "621201B15140E05050000000000004E463B453D323C342A312B222721181B160D"
            + "0E07010000000000004B2E924426833C1E753213662904571D00480D003700002"
            + "10000004E2F844627773D1E6935145C2A054E1E00400D003100001B0000004F30"
            + "7A46286C3E20603416542A09471E003A0E002A0000140000004F326F462A633E2"
            + "15834174A290B3F1D00320E002400000E000000503263462A593D224E34194329"
            + "0E371E002A0F001C000006000000513359472B4E3E234534193A2A0F2F1E03240"
            + "F001600000300000051334D472C443F243B351A312910261F041B10000C000000"
            + "000000513441482B383F2430351B2729111D1E04120E000300000000000051343"
            + "7492C2F402427351C202A12151F06090E000000000000000000AEEF009CD6008B"
            + "C00079A800699100577B004462002E4600032300ACD9009BC2008BAD007998006"
            + "88200576E004558002E3F00041C00ABC50099AF008A9E00798B00677600566400"
            + "444F002E3700041600AAB100989E00888D00777C00676A005658004446002D2F0"
            + "0030E00A99D00988D00887E00776D00665E00564E00443C002E2700030500A78A"
            + "00967C00876F007661006652005544004434002E1F00030000A77600966800875"
            + "E007651006545005438004329002D1500030000A66100955700864D0075430065"
            + "3800552C00431E002D0A00030000A54F00954900854000753800652E005522004"
            + "415002E01000300009EE1008DC9007EB4006D9E005E88004E72003C5B00264200"
            + "001E009CCB008CB7007DA4006D8F005E7C004E68003D53002639000017009CBA0"
            + "08CA6007D96006D82005D6F004D5D003C4A002632000011009BA7008A95007C86"
            + "006D75005D64004C53003C4100262B000009009993008A86007C78006B67005C5"
            + "8004D49003C38002623000000009983008976007A69006B5A005B4C004C3F003C"
            + "2F00271C00000000996F008864007B5A006B4D005C41004C34003C25002612000"
            + "00000985D008852007A4A006A3F005B34004C28003B1A00260600000000974E00"
            + "884500793D006A34005B2B004C20003B11002600000000008FD50080BF0073AB0"
            + "0649500548000456C003456001E3D000019008EC1007FAD00729A006386005474"
            + "00456200344D001F35000012008DB0007F9E00728D00627A00546900455800354"
            + "5001F2E000009008D9F007E8E00717F00626E00535F00454E00353C0020270000"
            + "02008C8C007E7E007070006262005353004445003434001F1F000000008C7C007"
            + "D7000706400615600534800443B00342C001F17000000008B6A007D60006F5500"
            + "614800533E004431003423001F0F000000008A58007C4F006F4600603B0052300"
            + "04426003418001F04000000008B4C007C42006F3A00603200522800441D00340F"
            + "001F000000000081C80072B30066A000578B004A78003C65002C5100163800001"
            + "3007FB50072A300669200587F004A6D003C5B002C4800173000000B007FA60071"
            + "94006585005773004A63003C52002C4000172A000004007F96007186006577005"
            + "768004A59003C49002C38001723000000007D8600707600646A00575C00494E00"
            + "3C40002C3000171B000000007D7600706900645E005650004944003C36002C270"
            + "01714000000007D65006F5A00635000564500493A003B2D002C1E00170B000000"
            + "007C55006F4B00634200563800492D003B22002C14001701000000007D48006F3"
            + "E00633800562E004924003C1A002C0C0017000000000072BC0065A7005996004D"
            + "8300407100325F00224B000C3400000E0071AA006599005989004D78004066003"
            + "255002343000C2C00000400719C00648B00597D004D6D00405C00334D00233C00"
            + "0C2600000000708D00647E005971004D62004053003344002333000C1E0000000"
            + "0707F006470005964004C5700404A00333B00232C000D1800000000706F006464"
            + "005858004C4C004040003334002425000D11000000006F6000635500584C004C4"
            + "000403500332900241B000D06000000006F5100634700583E004C3400402B0033"
            + "1F002411000D00000000006F4500633C005834004B2B003F22003315002407000"
            + "D000000000063B100589E004D8D00427B00356A00285900194700052F00000800"
            + "63A0005890004D81004270003661002950001A3E0005280000000063930057840"
            + "04E75004266003657002A48001A37000522000000006386005877004D6B00425C"
            + "00364E002A40001B3000051B00000000637800576B004E5E004251003644002A3"
            + "7001B2800061400000000626900575E004D5400414700373B002A2F001C210006"
            + "0C00000000625D005751004D4800423D003631002A25001C18000604000000006"
            + "24D005744004D3B004131003627002A1B001D0E00060000000001624107573800"
            + "4D3100422900361E002A13001D030006000000000054A6004A950040860035750"
            + "02964001C53000B4000002A000003005497004A87004079003569002A5A001E4B"
            + "000E3A00002400000000548A004A7C01406E00365F002B51001E43000F3300011"
            + "D0000000E547E0C4A70024163003655002C49001F3B00102C0001170000001054"
            + "710D4A6406415900364D002C41001F33001124000110000000185464124A580D4"
            + "14E023744002C3700202B00121C0001060000001A5457184A4C11414307363900"
            + "2C2E0020230013150002030000001E544A1C4A401441370C372E002C230020180"
            + "0120900010000000020543F1C4A3615412F0D3626002C1C002010001201000100"
            + "0000001E439B143A8B14317E0C276E001B5E000D4D00003C00002500000023438"
            + "E1E3A7E173272102863071D55000F4500003400001E0000002344831E3B741B32"
            + "6812285A091D4C00113E00022E000018000000254577213B6A1B335E152950091"
            + "E4300123600032700001200000028456B243B5E1C33541229480A1F3C00132F00"
            + "042000000A0000002A455F243B541D334A13293F0A1F340014270004190000040"
            + "000002B4553263C4920333E172A350B1F2A00141F0005110000010000002D4546"
            + "273C3C213334182A2B0D20210015150005060000000000002F453B293C3322332"
            + "B182A230C211A01160E0005010000000000002E30922A28832420761B16671106"
            + "580500490000370000210000003030852C287725206B1C165D14084F070041000"
            + "03100001B00000030327B2C296D2521611E1753150B4708003A00002A00001500"
            + "000031336F2D2A632622571D194B140D3F08003300002400000E0000003434642"
            + "C2B5926234F1D1A44130F380A012B00001C00000600000034345A2F2C4F272446"
            + "1E1B3B14102F09022400001600000200000034354E2E2C4427253C201B3116112"
            + "70A031C00000C0000000000003535422F2C39282430201B2716121E0904120000"
            + "03000000000000363539302D31292529211C201613170B060A010000000000000000";

    static {
        LUT = javax.xml.bind.DatatypeConverter.parseHexBinary(ColorSpaceProfile);
    }

}
