/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty.plus.annotation;

import java.lang.reflect.Method;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.mortbay.jetty.plus.annotation.PojoWrapper;

public class PojoContextListener
implements ServletContextListener,
PojoWrapper {
    private Object _pojo;
    private Method _contextDestroyedMethod;
    private Method _contextInitializedMethod;
    private static final Class[] __params = new Class[]{ServletContextEvent.class};

    public PojoContextListener(Object pojo) throws IllegalArgumentException {
        if (pojo == null) {
            throw new IllegalArgumentException("Pojo is null");
        }
        this._pojo = pojo;
        try {
            this._contextDestroyedMethod = this._pojo.getClass().getDeclaredMethod("contextDestroyed", __params);
            this._contextInitializedMethod = this._pojo.getClass().getDeclaredMethod("contextInitialized", __params);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e.getLocalizedMessage());
        }
    }

    public Object getPojo() {
        return this._pojo;
    }

    public void contextDestroyed(ServletContextEvent event) {
        try {
            this._contextDestroyedMethod.invoke(this._pojo, event);
        }
        catch (Exception e) {
            event.getServletContext().log("Error invoking contextInitialized", (Throwable)e);
        }
    }

    public void contextInitialized(ServletContextEvent event) {
        try {
            this._contextInitializedMethod.invoke(this._pojo, event);
        }
        catch (Exception e) {
            event.getServletContext().log("Error invoking contextInitialized", (Throwable)e);
        }
    }
}

