/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItemContainer;
import org.mybatis.generator.api.dom.kotlin.KotlinNamedItemVisitor;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;

public class KotlinType
extends KotlinNamedItemContainer {
    private final List<KotlinProperty> constructorProperties = new ArrayList<KotlinProperty>();
    private final Type type;
    private final Set<String> superTypes = new HashSet<String>();

    private KotlinType(Builder builder) {
        super(builder);
        this.type = Objects.requireNonNull(builder.type);
        this.constructorProperties.addAll(builder.constructorProperties);
        this.superTypes.addAll(builder.superTypes);
    }

    public List<KotlinProperty> getConstructorProperties() {
        return this.constructorProperties;
    }

    public Type getType() {
        return this.type;
    }

    public Set<String> getSuperTypes() {
        return this.superTypes;
    }

    public void addConstructorProperty(KotlinProperty property) {
        this.constructorProperties.add(property);
    }

    public void addSuperType(String superType) {
        this.superTypes.add(superType);
    }

    @Override
    public <R> R accept(KotlinNamedItemVisitor<R> visitor) {
        return visitor.visit(this);
    }

    public static Builder newClass(String name) {
        return new Builder(Type.CLASS, name);
    }

    public static Builder newInterface(String name) {
        return new Builder(Type.INTERFACE, name);
    }

    public static Builder newObject(String name) {
        return new Builder(Type.OBJECT, name);
    }

    public static class Builder
    extends KotlinNamedItemContainer.NamedItemContainerBuilder<Builder> {
        private final Type type;
        private final List<KotlinProperty> constructorProperties = new ArrayList<KotlinProperty>();
        private final List<String> superTypes = new ArrayList<String>();

        private Builder(Type type, String name) {
            super(name);
            this.type = type;
        }

        public Builder withConstructorProperty(KotlinProperty kotlinProperty) {
            this.constructorProperties.add(kotlinProperty);
            return this;
        }

        public Builder withSuperType(String superType) {
            this.superTypes.add(superType);
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public KotlinType build() {
            return new KotlinType(this);
        }
    }

    public static enum Type {
        CLASS("class"),
        INTERFACE("interface"),
        OBJECT("object");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

