/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.kotlin.render;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.api.dom.kotlin.render.KotlinArgRenderer;
import org.mybatis.generator.api.dom.kotlin.render.KotlinRenderingUtilities;

public class KotlinFunctionRenderer {
    public List<String> render(KotlinFunction function) {
        ArrayList<String> answer = new ArrayList<String>(function.getAnnotations());
        answer.add(this.renderFirstLine(function));
        answer.addAll(function.getCodeLines().stream().map(KotlinRenderingUtilities::kotlinIndent).collect(Collectors.toList()));
        if (!function.getCodeLines().isEmpty() && !function.isOneLineFunction()) {
            answer.add("}");
        }
        return answer;
    }

    private String renderFirstLine(KotlinFunction function) {
        String firstLine = KotlinRenderingUtilities.renderModifiers(function.getModifiers()) + "fun " + function.getName() + "(";
        firstLine = firstLine + this.renderArguments(function);
        firstLine = firstLine + ")";
        firstLine = firstLine + this.renderReturnType(function);
        if (!function.getCodeLines().isEmpty()) {
            firstLine = function.isOneLineFunction() ? firstLine + " =" : firstLine + " {";
        }
        return firstLine;
    }

    private String renderArguments(KotlinFunction function) {
        KotlinArgRenderer argRenderer = new KotlinArgRenderer();
        return function.getArguments().stream().map(argRenderer::render).collect(Collectors.joining(", "));
    }

    private String renderReturnType(KotlinFunction function) {
        return function.getExplicitReturnType().map(s -> ": " + s).orElse("");
    }
}

