/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.internal;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.ConnectionFactory;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.JavaFormatter;
import org.mybatis.generator.api.JavaTypeResolver;
import org.mybatis.generator.api.KotlinFormatter;
import org.mybatis.generator.api.Plugin;
import org.mybatis.generator.api.XmlFormatter;
import org.mybatis.generator.api.dom.DefaultJavaFormatter;
import org.mybatis.generator.api.dom.DefaultKotlinFormatter;
import org.mybatis.generator.api.dom.DefaultXmlFormatter;
import org.mybatis.generator.codegen.mybatis3.IntrospectedTableMyBatis3Impl;
import org.mybatis.generator.codegen.mybatis3.IntrospectedTableMyBatis3SimpleImpl;
import org.mybatis.generator.config.CommentGeneratorConfiguration;
import org.mybatis.generator.config.ConnectionFactoryConfiguration;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.config.JavaTypeResolverConfiguration;
import org.mybatis.generator.config.PluginConfiguration;
import org.mybatis.generator.config.TableConfiguration;
import org.mybatis.generator.internal.DefaultCommentGenerator;
import org.mybatis.generator.internal.JDBCConnectionFactory;
import org.mybatis.generator.internal.types.JavaTypeResolverDefaultImpl;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.runtime.dynamic.sql.IntrospectedTableMyBatis3DynamicSqlImpl;
import org.mybatis.generator.runtime.kotlin.IntrospectedTableKotlinImpl;

public class ObjectFactory {
    private static final List<ClassLoader> externalClassLoaders = new ArrayList<ClassLoader>();

    private ObjectFactory() {
    }

    public static void reset() {
        externalClassLoaders.clear();
    }

    public static synchronized void addExternalClassLoader(ClassLoader classLoader) {
        externalClassLoaders.add(classLoader);
    }

    public static Class<?> externalClassForName(String type) throws ClassNotFoundException {
        for (ClassLoader classLoader : externalClassLoaders) {
            try {
                Class<?> clazz = Class.forName(type, true, classLoader);
                return clazz;
            }
            catch (Exception exception) {
            }
        }
        return ObjectFactory.internalClassForName(type);
    }

    public static Object createExternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = ObjectFactory.externalClassForName(type);
            answer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static Class<?> internalClassForName(String type) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            clazz = Class.forName(type, true, cl);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (clazz == null) {
            clazz = Class.forName(type, true, ObjectFactory.class.getClassLoader());
        }
        return clazz;
    }

    public static URL getResource(String resource) {
        URL url;
        for (ClassLoader classLoader : externalClassLoaders) {
            url = classLoader.getResource(resource);
            if (url == null) continue;
            return url;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        url = cl.getResource(resource);
        if (url == null) {
            url = ObjectFactory.class.getClassLoader().getResource(resource);
        }
        return url;
    }

    public static Object createInternalObject(String type) {
        Object answer;
        try {
            Class<?> clazz = ObjectFactory.internalClassForName(type);
            answer = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(Messages.getString("RuntimeError.6", type), e);
        }
        return answer;
    }

    public static JavaTypeResolver createJavaTypeResolver(Context context, List<String> warnings) {
        String type;
        JavaTypeResolverConfiguration config = context.getJavaTypeResolverConfiguration();
        if (config != null && config.getConfigurationType() != null) {
            type = config.getConfigurationType();
            if ("DEFAULT".equalsIgnoreCase(type)) {
                type = JavaTypeResolverDefaultImpl.class.getName();
            }
        } else {
            type = JavaTypeResolverDefaultImpl.class.getName();
        }
        JavaTypeResolver answer = (JavaTypeResolver)ObjectFactory.createInternalObject(type);
        answer.setWarnings(warnings);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        answer.setContext(context);
        return answer;
    }

    public static Plugin createPlugin(Context context, PluginConfiguration pluginConfiguration) {
        Plugin plugin = (Plugin)ObjectFactory.createInternalObject(pluginConfiguration.getConfigurationType());
        plugin.setContext(context);
        plugin.setProperties(pluginConfiguration.getProperties());
        return plugin;
    }

    public static CommentGenerator createCommentGenerator(Context context) {
        CommentGeneratorConfiguration config = context.getCommentGeneratorConfiguration();
        String type = config == null || config.getConfigurationType() == null ? DefaultCommentGenerator.class.getName() : config.getConfigurationType();
        CommentGenerator answer = (CommentGenerator)ObjectFactory.createInternalObject(type);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        return answer;
    }

    public static ConnectionFactory createConnectionFactory(Context context) {
        ConnectionFactoryConfiguration config = context.getConnectionFactoryConfiguration();
        String type = config == null || config.getConfigurationType() == null ? JDBCConnectionFactory.class.getName() : config.getConfigurationType();
        ConnectionFactory answer = (ConnectionFactory)ObjectFactory.createInternalObject(type);
        if (config != null) {
            answer.addConfigurationProperties(config.getProperties());
        }
        return answer;
    }

    public static JavaFormatter createJavaFormatter(Context context) {
        String type = context.getProperty("javaFormatter");
        if (!StringUtility.stringHasValue(type)) {
            type = DefaultJavaFormatter.class.getName();
        }
        JavaFormatter answer = (JavaFormatter)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }

    public static KotlinFormatter createKotlinFormatter(Context context) {
        String type = context.getProperty("kotlinFormatter");
        if (!StringUtility.stringHasValue(type)) {
            type = DefaultKotlinFormatter.class.getName();
        }
        KotlinFormatter answer = (KotlinFormatter)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }

    public static XmlFormatter createXmlFormatter(Context context) {
        String type = context.getProperty("xmlFormatter");
        if (!StringUtility.stringHasValue(type)) {
            type = DefaultXmlFormatter.class.getName();
        }
        XmlFormatter answer = (XmlFormatter)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }

    public static IntrospectedTable createIntrospectedTable(TableConfiguration tableConfiguration, FullyQualifiedTable table, Context context) {
        IntrospectedTable answer = ObjectFactory.createIntrospectedTableForValidation(context);
        answer.setFullyQualifiedTable(table);
        answer.setTableConfiguration(tableConfiguration);
        return answer;
    }

    public static IntrospectedTable createIntrospectedTableForValidation(Context context) {
        String type = context.getTargetRuntime();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedTableMyBatis3DynamicSqlImpl.class.getName();
        } else if ("MyBatis3".equalsIgnoreCase(type)) {
            type = IntrospectedTableMyBatis3Impl.class.getName();
        } else if ("MyBatis3Simple".equalsIgnoreCase(type)) {
            type = IntrospectedTableMyBatis3SimpleImpl.class.getName();
        } else if ("MyBatis3DynamicSql".equalsIgnoreCase(type)) {
            type = IntrospectedTableMyBatis3DynamicSqlImpl.class.getName();
        } else if ("MyBatis3Kotlin".equalsIgnoreCase(type)) {
            type = IntrospectedTableKotlinImpl.class.getName();
        }
        IntrospectedTable answer = (IntrospectedTable)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }

    public static IntrospectedColumn createIntrospectedColumn(Context context) {
        String type = context.getIntrospectedColumnImpl();
        if (!StringUtility.stringHasValue(type)) {
            type = IntrospectedColumn.class.getName();
        }
        IntrospectedColumn answer = (IntrospectedColumn)ObjectFactory.createInternalObject(type);
        answer.setContext(context);
        return answer;
    }
}

