/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.plugins;

import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.internal.util.StringUtility;

public class CachePlugin
extends PluginAdapter {
    @Override
    public boolean validate(List<String> warnings) {
        return true;
    }

    @Override
    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement element = new XmlElement("cache");
        this.context.getCommentGenerator().addComment(element);
        for (CacheProperty cacheProperty : CacheProperty.values()) {
            this.addAttributeIfExists(element, introspectedTable, cacheProperty);
        }
        document.getRootElement().addElement(element);
        return true;
    }

    private void addAttributeIfExists(XmlElement element, IntrospectedTable introspectedTable, CacheProperty cacheProperty) {
        String property = introspectedTable.getTableConfigurationProperty(cacheProperty.getPropertyName());
        if (property == null) {
            property = this.properties.getProperty(cacheProperty.getPropertyName());
        }
        if (StringUtility.stringHasValue(property)) {
            element.addAttribute(new Attribute(cacheProperty.getAttributeName(), property));
        }
    }

    public static enum CacheProperty {
        EVICTION("cache_eviction", "eviction"),
        FLUSH_INTERVAL("cache_flushInterval", "flushInterval"),
        READ_ONLY("cache_readOnly", "readOnly"),
        SIZE("cache_size", "size"),
        TYPE("cache_type", "type");

        private final String propertyName;
        private final String attributeName;

        private CacheProperty(String propertyName, String attributeName) {
            this.propertyName = propertyName;
            this.attributeName = attributeName;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getAttributeName() {
            return this.attributeName;
        }
    }
}

