/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.HashSet;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.FragmentGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodParts;

public class BasicSelectOneMethodGenerator
extends AbstractMethodGenerator {
    private final FullyQualifiedJavaType recordType;
    private final String resultMapId;
    private final FragmentGenerator fragmentGenerator;
    private final boolean reuseResultMap;

    private BasicSelectOneMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.resultMapId = builder.resultMapId;
        this.fragmentGenerator = builder.fragmentGenerator;
        this.reuseResultMap = builder.reuseResultMap;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.select.render.SelectStatementProvider");
        imports.add(parameterType);
        FullyQualifiedJavaType adapter = new FullyQualifiedJavaType("org.mybatis.dynamic.sql.util.SqlProviderAdapter");
        imports.add(adapter);
        FullyQualifiedJavaType annotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.SelectProvider");
        imports.add(annotation);
        FullyQualifiedJavaType returnType = new FullyQualifiedJavaType("java.util.Optional");
        returnType.addTypeArgument(this.recordType);
        imports.add(returnType);
        Method method = new Method("selectOne");
        method.setAbstract(true);
        imports.add(this.recordType);
        method.setReturnType(returnType);
        method.addParameter(new Parameter(parameterType, "selectStatement"));
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.addAnnotation("@SelectProvider(type=SqlProviderAdapter.class, method=\"select\")");
        MethodAndImports.Builder builder = MethodAndImports.withMethod(method).withImports(imports);
        if (this.introspectedTable.isConstructorBased()) {
            MethodParts methodParts = this.fragmentGenerator.getAnnotatedConstructorArgs();
            this.acceptParts(builder, method, methodParts);
        } else if (this.reuseResultMap) {
            FullyQualifiedJavaType rmAnnotation = new FullyQualifiedJavaType("org.apache.ibatis.annotations.ResultMap");
            builder.withImport(rmAnnotation);
            method.addAnnotation("@ResultMap(\"" + this.resultMapId + "\")");
        } else {
            MethodParts methodParts = this.fragmentGenerator.getAnnotatedResults();
            this.acceptParts(builder, method, methodParts);
        }
        return builder.build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return this.context.getPlugins().clientBasicSelectOneMethodGenerated(method, interfaze, this.introspectedTable);
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder> {
        private FullyQualifiedJavaType recordType;
        private String resultMapId;
        private FragmentGenerator fragmentGenerator;
        private boolean reuseResultMap;

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withResultMapId(String resultMapId) {
            this.resultMapId = resultMapId;
            return this;
        }

        public Builder withFragmentGenerator(FragmentGenerator fragmentGenerator) {
            this.fragmentGenerator = fragmentGenerator;
            return this;
        }

        public Builder withReuseResultMap(boolean reuseResultMap) {
            this.reuseResultMap = reuseResultMap;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public BasicSelectOneMethodGenerator build() {
            return new BasicSelectOneMethodGenerator(this);
        }
    }
}

