/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin;

import java.util.Collections;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.FullyQualifiedTable;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.JavaToKotlinTypeConverter;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinModifier;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.codegen.AbstractKotlinGenerator;
import org.mybatis.generator.internal.util.messages.Messages;

public class KotlinDataClassGenerator
extends AbstractKotlinGenerator {
    public KotlinDataClassGenerator(String project) {
        super(project);
    }

    @Override
    public List<KotlinFile> getKotlinFiles() {
        FullyQualifiedTable table = this.introspectedTable.getFullyQualifiedTable();
        this.progressCallback.startTask(Messages.getString("Progress.8", table.toString()));
        CommentGenerator commentGenerator = this.context.getCommentGenerator();
        FullyQualifiedKotlinType type = new FullyQualifiedKotlinType(this.introspectedTable.getKotlinRecordType());
        KotlinFile kf = new KotlinFile(type.getShortNameWithoutTypeArguments());
        kf.setPackage(type.getPackageName());
        KotlinType dataClass = ((KotlinType.Builder)KotlinType.newClass(type.getShortNameWithoutTypeArguments()).withModifier(KotlinModifier.DATA)).build();
        kf.addNamedItem(dataClass);
        commentGenerator.addFileComment(kf);
        commentGenerator.addModelClassComment(dataClass, this.introspectedTable);
        List<IntrospectedColumn> introspectedColumns = this.introspectedTable.getAllColumns();
        for (IntrospectedColumn introspectedColumn : introspectedColumns) {
            FullyQualifiedKotlinType kotlinType = JavaToKotlinTypeConverter.convert(introspectedColumn.getFullyQualifiedJavaType());
            KotlinProperty kp = KotlinProperty.newVar(introspectedColumn.getJavaProperty()).withDataType(kotlinType.getShortNameWithTypeArguments() + "?").withInitializationString("null").build();
            dataClass.addConstructorProperty(kp);
            kf.addImports(kotlinType.getImportList());
        }
        if (this.context.getPlugins().kotlinDataClassGenerated(kf, dataClass, this.introspectedTable)) {
            return this.listOf(kf);
        }
        return Collections.emptyList();
    }
}

