/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin;

import java.util.List;
import java.util.Objects;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.JavaToKotlinTypeConverter;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinProperty;
import org.mybatis.generator.api.dom.kotlin.KotlinType;
import org.mybatis.generator.codegen.mybatis3.MyBatis3FormattingUtilities;
import org.mybatis.generator.config.Context;
import org.mybatis.generator.internal.util.JavaBeansUtil;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class KotlinDynamicSqlSupportClassGenerator {
    private final IntrospectedTable introspectedTable;
    private final Context context;
    private final List<String> warnings;
    private KotlinFile kotlinFile;
    private KotlinType innerClass;
    private KotlinType outerObject;
    private KotlinProperty tableProperty;

    public KotlinDynamicSqlSupportClassGenerator(Context context, IntrospectedTable introspectedTable, List<String> warnings) {
        this.introspectedTable = Objects.requireNonNull(introspectedTable);
        this.context = Objects.requireNonNull(context);
        this.warnings = Objects.requireNonNull(warnings);
        this.generate();
    }

    private void generate() {
        FullyQualifiedJavaType type = new FullyQualifiedJavaType(this.introspectedTable.getMyBatisDynamicSqlSupportType());
        this.kotlinFile = this.buildBasicFile(type);
        this.outerObject = this.buildOuterObject(this.kotlinFile, type);
        this.tableProperty = this.calculateTableProperty();
        this.outerObject.addNamedItem(this.tableProperty);
        this.innerClass = this.buildInnerClass();
        List<IntrospectedColumn> columns = this.introspectedTable.getAllColumns();
        for (IntrospectedColumn column : columns) {
            this.handleColumn(this.kotlinFile, this.outerObject, this.innerClass, this.getTablePropertyName(), column);
        }
        this.outerObject.addNamedItem(this.innerClass);
    }

    public KotlinFile getKotlinFile() {
        return this.kotlinFile;
    }

    public String getTablePropertyName() {
        return this.tableProperty.getName();
    }

    public KotlinType getInnerClass() {
        return this.innerClass;
    }

    public KotlinType getOuterObject() {
        return this.outerObject;
    }

    public String getTablePropertyImport() {
        return this.getSupportObjectImport() + "." + this.tableProperty.getName();
    }

    public String getSupportObjectImport() {
        return this.kotlinFile.getPackage().map(s -> s + ".").orElse("") + this.outerObject.getName();
    }

    private KotlinFile buildBasicFile(FullyQualifiedJavaType type) {
        KotlinFile kf = new KotlinFile(type.getShortNameWithoutTypeArguments());
        kf.setPackage(type.getPackageName());
        this.context.getCommentGenerator().addFileComment(kf);
        return kf;
    }

    private KotlinType buildOuterObject(KotlinFile kotlinFile, FullyQualifiedJavaType type) {
        KotlinType outerObject = KotlinType.newObject(type.getShortNameWithoutTypeArguments()).build();
        kotlinFile.addImport("org.mybatis.dynamic.sql.AliasableSqlTable");
        kotlinFile.addImport("org.mybatis.dynamic.sql.util.kotlin.elements.column");
        kotlinFile.addImport("java.sql.JDBCType");
        kotlinFile.addNamedItem(outerObject);
        return outerObject;
    }

    private KotlinType buildInnerClass() {
        String domainObjectName = this.introspectedTable.getMyBatisDynamicSQLTableObjectName();
        return KotlinType.newClass(domainObjectName).withSuperType("AliasableSqlTable<" + domainObjectName + ">(\"" + StringUtility.escapeStringForKotlin(this.introspectedTable.getFullyQualifiedTableNameAtRuntime()) + "\", ::" + domainObjectName + ")").build();
    }

    private KotlinProperty calculateTableProperty() {
        String tableType = this.introspectedTable.getMyBatisDynamicSQLTableObjectName();
        String fieldName = JavaBeansUtil.getValidPropertyName(this.introspectedTable.getMyBatisDynamicSQLTableObjectName());
        return KotlinProperty.newVal(fieldName).withInitializationString(tableType + "()").build();
    }

    private void handleColumn(KotlinFile kotlinFile, KotlinType outerObject, KotlinType innerClass, String tableFieldName, IntrospectedColumn column) {
        FullyQualifiedKotlinType kt = JavaToKotlinTypeConverter.convert(column.getFullyQualifiedJavaType());
        kotlinFile.addImports(kt.getImportList());
        String fieldName = column.getJavaProperty();
        if (fieldName.equals(tableFieldName)) {
            this.warnings.add(Messages.getString("Warning.29", fieldName, this.getSupportObjectImport()));
        } else {
            KotlinProperty prop = KotlinProperty.newVal(fieldName).withInitializationString(tableFieldName + "." + fieldName).build();
            outerObject.addNamedItem(prop);
        }
        KotlinProperty property = KotlinProperty.newVal(fieldName).withInitializationString(this.calculateInnerInitializationString(column, kt)).build();
        innerClass.addNamedItem(property);
    }

    private String calculateInnerInitializationString(IntrospectedColumn column, FullyQualifiedKotlinType kt) {
        StringBuilder initializationString = new StringBuilder();
        initializationString.append(String.format("column<%s>(name = \"%s\", jdbcType = JDBCType.%s", kt.getShortNameWithTypeArguments(), StringUtility.escapeStringForKotlin(MyBatis3FormattingUtilities.getEscapedColumnName(column)), column.getJdbcTypeName()));
        if (StringUtility.stringHasValue(column.getTypeHandler())) {
            initializationString.append(String.format(", typeHandler = \"%s\"", column.getTypeHandler()));
        }
        if (StringUtility.isTrue(column.getProperties().getProperty("forceJavaTypeIntoMapping"))) {
            initializationString.append(String.format(", javaType = %s::class", kt.getShortNameWithoutTypeArguments()));
        }
        initializationString.append(')');
        return initializationString.toString();
    }
}

