/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFragmentGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionParts;

public class BasicSelectOneMethodGenerator
extends AbstractKotlinFunctionGenerator {
    private final FullyQualifiedKotlinType recordType;
    private final String resultMapId;
    private final KotlinFragmentGenerator fragmentGenerator;
    private final boolean reuseResultMap;

    private BasicSelectOneMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.resultMapId = builder.resultMapId;
        this.fragmentGenerator = builder.fragmentGenerator;
        this.reuseResultMap = builder.reuseResultMap;
    }

    @Override
    public KotlinFunctionAndImports generateMethodAndImports() {
        KotlinFunctionAndImports functionAndImports = KotlinFunctionAndImports.withFunction(((KotlinFunction.Builder)KotlinFunction.newOneLineFunction("selectOne").withExplicitReturnType(this.recordType.getShortNameWithTypeArguments() + "?").withArgument(KotlinArg.newArg("selectStatement").withDataType("SelectStatementProvider").build()).withAnnotation("@SelectProvider(type=SqlProviderAdapter::class, method=\"select\")")).build()).withImport("org.mybatis.dynamic.sql.select.render.SelectStatementProvider").withImport("org.mybatis.dynamic.sql.util.SqlProviderAdapter").withImport("org.apache.ibatis.annotations.SelectProvider").withImports(this.recordType.getImportList()).build();
        this.addFunctionComment(functionAndImports);
        if (this.reuseResultMap) {
            functionAndImports.getImports().add("org.apache.ibatis.annotations.ResultMap");
            functionAndImports.getFunction().addAnnotation("@ResultMap(\"" + this.resultMapId + "\")");
        } else {
            KotlinFunctionParts functionParts = this.fragmentGenerator.getAnnotatedResults();
            this.acceptParts(functionAndImports, functionParts);
        }
        return functionAndImports;
    }

    @Override
    public boolean callPlugins(KotlinFunction kotlinFunction, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientBasicSelectOneMethodGenerated(kotlinFunction, kotlinFile, this.introspectedTable);
    }

    public static class Builder
    extends AbstractKotlinFunctionGenerator.BaseBuilder<Builder> {
        private FullyQualifiedKotlinType recordType;
        private String resultMapId;
        private KotlinFragmentGenerator fragmentGenerator;
        private boolean reuseResultMap;

        public Builder withRecordType(FullyQualifiedKotlinType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withResultMapId(String resultMapId) {
            this.resultMapId = resultMapId;
            return this;
        }

        public Builder withFragmentGenerator(KotlinFragmentGenerator fragmentGenerator) {
            this.fragmentGenerator = fragmentGenerator;
            return this;
        }

        public Builder withReuseResultMap(boolean reuseResultMap) {
            this.reuseResultMap = reuseResultMap;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public BasicSelectOneMethodGenerator build() {
            return new BasicSelectOneMethodGenerator(this);
        }
    }
}

