/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.kotlin.elements;

import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.kotlin.FullyQualifiedKotlinType;
import org.mybatis.generator.api.dom.kotlin.KotlinArg;
import org.mybatis.generator.api.dom.kotlin.KotlinFile;
import org.mybatis.generator.api.dom.kotlin.KotlinFunction;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.dynamic.sql.elements.Utils;
import org.mybatis.generator.runtime.kotlin.elements.AbstractKotlinFunctionGenerator;
import org.mybatis.generator.runtime.kotlin.elements.KotlinFunctionAndImports;

public class InsertMultipleMethodGenerator
extends AbstractKotlinFunctionGenerator {
    private final FullyQualifiedKotlinType recordType;
    private final String mapperName;
    private final String supportObjectImport;

    private InsertMultipleMethodGenerator(Builder builder) {
        super(builder);
        this.recordType = builder.recordType;
        this.mapperName = builder.mapperName;
        this.supportObjectImport = builder.supportObjectImport;
    }

    @Override
    public KotlinFunctionAndImports generateMethodAndImports() {
        String functionShortName;
        String functionImport;
        if (!Utils.generateMultipleRowInsert(this.introspectedTable)) {
            return null;
        }
        if (Utils.canRetrieveMultiRowGeneratedKeys(this.introspectedTable)) {
            functionImport = "org.mybatis.dynamic.sql.util.kotlin.mybatis3.insertMultipleWithGeneratedKeys";
            functionShortName = "insertMultipleWithGeneratedKeys";
        } else {
            functionImport = "org.mybatis.dynamic.sql.util.kotlin.mybatis3.insertMultiple";
            functionShortName = "insertMultiple";
        }
        KotlinFunctionAndImports functionAndImports = KotlinFunctionAndImports.withFunction(KotlinFunction.newOneLineFunction(this.mapperName + ".insertMultiple").withArgument(KotlinArg.newArg("records").withDataType("Collection<" + this.recordType.getShortNameWithTypeArguments() + ">").build()).build()).withImport(functionImport).withImports(this.recordType.getImportList()).build();
        this.addFunctionComment(functionAndImports);
        KotlinFunction function = functionAndImports.getFunction();
        function.addCodeLine(functionShortName + "(this::insertMultiple, records, " + this.tableFieldName + ") {");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        for (IntrospectedColumn column : columns) {
            AbstractKotlinFunctionGenerator.FieldNameAndImport fieldNameAndImport = AbstractKotlinFunctionGenerator.calculateFieldNameAndImport(this.tableFieldName, this.supportObjectImport, column);
            functionAndImports.getImports().add(fieldNameAndImport.importString());
            function.addCodeLine("    map(" + fieldNameAndImport.fieldName() + ") toProperty \"" + column.getJavaProperty() + "\"");
        }
        function.addCodeLine("}");
        return functionAndImports;
    }

    @Override
    public boolean callPlugins(KotlinFunction kotlinFunction, KotlinFile kotlinFile) {
        return this.context.getPlugins().clientInsertMultipleMethodGenerated(kotlinFunction, kotlinFile, this.introspectedTable);
    }

    public static class Builder
    extends AbstractKotlinFunctionGenerator.BaseBuilder<Builder> {
        private FullyQualifiedKotlinType recordType;
        private String mapperName;
        private String supportObjectImport;

        public Builder withRecordType(FullyQualifiedKotlinType recordType) {
            this.recordType = recordType;
            return this;
        }

        public Builder withMapperName(String mapperName) {
            this.mapperName = mapperName;
            return this;
        }

        public Builder withSupportObjectImport(String supportObjectImport) {
            this.supportObjectImport = supportObjectImport;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        public InsertMultipleMethodGenerator build() {
            return new InsertMultipleMethodGenerator(this);
        }
    }
}

