/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.builder.BuilderException;

public class ParameterExpressionParser {
    public static Map<String, String> parse(String expression) {
        HashMap<String, String> map = new HashMap<String, String>();
        ParameterExpressionParser.parse(expression.toCharArray(), 0, map);
        return map;
    }

    private static void parse(char[] expression, int p, Map<String, String> map) {
        if (expression[p = ParameterExpressionParser.skipWS(expression, p)] == '(') {
            ParameterExpressionParser.expression(expression, p + 1, map);
        } else {
            ParameterExpressionParser.property(expression, p, map);
        }
    }

    private static void expression(char[] expression, int left, Map<String, String> map) {
        int match = 1;
        int right = left + 1;
        while (match > 0) {
            if (expression[right] == ')') {
                --match;
            } else if (expression[right] == '(') {
                ++match;
            }
            ++right;
        }
        map.put("expression", new String(expression, left, right - left - 1));
        ParameterExpressionParser.jdbcTypeOpt(expression, right, map);
    }

    private static void property(char[] expression, int p, Map<String, String> map) {
        int left = ParameterExpressionParser.skipWS(expression, p);
        if (left < expression.length) {
            int right = ParameterExpressionParser.skipUntil(expression, left, ',', ':');
            map.put("property", new String(expression, left, right - left));
            ParameterExpressionParser.jdbcTypeOpt(expression, right, map);
        }
    }

    private static int skipWS(char[] expression, int p) {
        for (int i = p; i < expression.length; ++i) {
            char c = expression[i];
            if (ParameterExpressionParser.isWhitespaceBreak(c) || c == ' ') continue;
            return i;
        }
        return expression.length;
    }

    private static int skipUntil(char[] expression, int p, char to) {
        for (int i = p; i < expression.length; ++i) {
            char c = expression[i];
            if (!ParameterExpressionParser.isWhitespaceBreak(c) && c != to) continue;
            return i;
        }
        return expression.length;
    }

    private static int skipUntil(char[] expression, int p, char to1, char to2) {
        for (int i = p; i < expression.length; ++i) {
            char c = expression[i];
            if (!ParameterExpressionParser.isWhitespaceBreak(c) && c != to1 && c != to2) continue;
            return i;
        }
        return expression.length;
    }

    private static boolean isWhitespaceBreak(char c) {
        return c == '\t' || c == '\n' || c == '\r';
    }

    private static void jdbcTypeOpt(char[] expression, int p, Map<String, String> map) {
        if ((p = ParameterExpressionParser.skipWS(expression, p)) < expression.length) {
            if (expression[p] == ':') {
                ParameterExpressionParser.jdbcType(expression, p + 1, map);
            } else if (expression[p] == ',') {
                ParameterExpressionParser.option(expression, p + 1, map);
            } else {
                throw new BuilderException("Parsing error in {" + new String(expression) + "} in position " + p);
            }
        }
    }

    private static void jdbcType(char[] expression, int p, Map<String, String> map) {
        int left = ParameterExpressionParser.skipWS(expression, p);
        int right = ParameterExpressionParser.skipUntil(expression, left, ',');
        if (right <= left) {
            throw new BuilderException("Parsing error in {" + new String(expression) + "} in position " + p);
        }
        map.put("jdbcType", new String(expression, left, right - left));
        ParameterExpressionParser.option(expression, right + 1, map);
    }

    private static void option(char[] expression, int p, Map<String, String> map) {
        int left = ParameterExpressionParser.skipWS(expression, p);
        if (left < expression.length) {
            int right = ParameterExpressionParser.skipUntil(expression, left, '=');
            String name = new String(expression, left, right - left);
            left = ParameterExpressionParser.skipWS(expression, right) + 1;
            right = ParameterExpressionParser.skipUntil(expression, left, ',');
            String value = new String(expression, left, right - left);
            map.put(name, value);
            ParameterExpressionParser.option(expression, right + 1, map);
        }
    }
}

