/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.common.DependencyResolver;
import org.neo4j.common.DependencySatisfier;
import org.neo4j.exceptions.UnsatisfiedDependencyException;

public class Dependencies
extends DependencyResolver.Adapter
implements DependencySatisfier {
    private final DependencyResolver parent;
    private final MutableSetMultimap<Class<?>, Object> typeDependencies;

    public Dependencies() {
        this.typeDependencies = Multimaps.mutable.set.empty();
        this.parent = null;
    }

    public Dependencies(DependencyResolver parent) {
        this.typeDependencies = Multimaps.mutable.set.empty();
        Objects.requireNonNull(parent);
        this.parent = parent;
    }

    public <T> T resolveDependency(Class<T> type, DependencyResolver.SelectionStrategy selector) {
        MutableSet options = this.typeDependencies.get(type);
        if (options.notEmpty()) {
            return (T)selector.select(type, (Iterable)options);
        }
        if (this.parent != null) {
            return (T)this.parent.resolveDependency(type, selector);
        }
        throw new UnsatisfiedDependencyException(type);
    }

    public <T> Iterable<T> resolveTypeDependencies(Class<T> type) {
        MutableSet options = this.typeDependencies.get(type);
        if (this.parent != null) {
            options = Sets.mutable.ofAll((Iterable)options);
            this.parent.resolveTypeDependencies(type).forEach(arg_0 -> options.add(arg_0));
        }
        return options;
    }

    public <T> Supplier<T> provideDependency(Class<T> type) {
        return () -> this.resolveDependency(type);
    }

    public <T> T satisfyDependency(T dependency) {
        Class<?> type = dependency.getClass();
        this.typeDependencies.put(type, dependency);
        this.addSuperclasses(type, dependency);
        this.addInterfaces(type, dependency);
        return dependency;
    }

    public boolean containsDependency(Class<?> type) {
        if (this.typeDependencies.containsKey(type)) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.containsDependency(type);
        }
        return false;
    }

    private <T> void addInterfaces(Class<?> type, T dependency) {
        List interfaces = ClassUtils.getAllInterfaces(type);
        if (interfaces != null) {
            interfaces.remove(type);
            for (Class iType : interfaces) {
                this.typeDependencies.put((Object)iType, dependency);
            }
        }
    }

    private <T> void addSuperclasses(Class<?> type, T dependency) {
        List allSuperclasses = ClassUtils.getAllSuperclasses(type);
        if (allSuperclasses != null) {
            for (Class aClass : allSuperclasses) {
                this.typeDependencies.put((Object)aClass, dependency);
            }
        }
    }

    public void satisfyDependencies(Object ... dependencies) {
        for (Object dependency : dependencies) {
            this.satisfyDependency(dependency);
        }
    }
}

