/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.helpers.collection;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.collection.RawIterator;
import org.neo4j.function.Predicates;
import org.neo4j.function.ThrowingFunction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.CombiningIterator;
import org.neo4j.internal.helpers.collection.CombiningResourceIterator;
import org.neo4j.internal.helpers.collection.FilterIterable;
import org.neo4j.internal.helpers.collection.MapIterable;
import org.neo4j.internal.helpers.collection.PrefetchingIterator;
import org.neo4j.internal.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.internal.helpers.collection.RawMapIterator;
import org.neo4j.internal.helpers.collection.WrappingResourceIterator;

public final class Iterators {
    private Iterators() {
        throw new AssertionError((Object)"no instance");
    }

    public static <T> T firstOrNull(Iterator<T> iterator) {
        try {
            T t = iterator.hasNext() ? (T)iterator.next() : null;
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T firstOrDefault(Iterator<T> iterator, T defaultValue) {
        try {
            T t = iterator.hasNext() ? iterator.next() : defaultValue;
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T first(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.firstOrNull(iterator));
    }

    static <T> T lastOrNull(Iterator<T> iterator) {
        try {
            T result = null;
            while (iterator.hasNext()) {
                result = iterator.next();
            }
            T t = result;
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T last(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.lastOrNull(iterator));
    }

    public static <T> T singleOrNull(Iterator<T> iterator) {
        try {
            T t = Iterators.single(iterator, null);
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> T single(Iterator<T> iterator) {
        return Iterators.assertNotNull(iterator, Iterators.singleOrNull(iterator));
    }

    static <T> T fromEnd(Iterator<T> iterator, int n) {
        return Iterators.assertNotNull(iterator, Iterators.fromEndOrNull(iterator, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T fromEndOrNull(Iterator<T> iterator, int n) {
        try {
            ArrayDeque<T> trail = new ArrayDeque<T>(n);
            while (iterator.hasNext()) {
                if (trail.size() > n) {
                    trail.removeLast();
                }
                trail.addFirst(iterator.next());
            }
            T t = trail.size() == n + 1 ? (T)trail.getLast() : null;
            return t;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static boolean iteratorsEqual(Iterator<?> first, Iterator<?> other) {
        try {
            while (first.hasNext() && other.hasNext()) {
                if (Objects.equals(first.next(), other.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = first.hasNext() == other.hasNext();
            return bl;
        }
        finally {
            Iterators.tryCloseResource(first);
            Iterators.tryCloseResource(other);
        }
    }

    private static <T> T assertNotNull(Iterator<T> iterator, T result) {
        if (result == null) {
            throw new NoSuchElementException("No element found in " + iterator);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T single(Iterator<T> iterator, T itemIfNone) {
        try {
            T result;
            T t = result = iterator.hasNext() ? iterator.next() : itemIfNone;
            if (iterator.hasNext()) {
                throw new NoSuchElementException("More than one element in " + iterator + ". First element is '" + result + "' and the second element is '" + iterator.next() + "'");
            }
            T t2 = result;
            return t2;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <C extends Collection<T>, T> C addToCollection(Iterator<T> iterator, C collection) {
        try {
            while (iterator.hasNext()) {
                collection.add(iterator.next());
            }
            C c = collection;
            return c;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    private static <C extends Collection<T>, T> C addToCollectionUnique(Iterator<T> iterator, C collection) {
        try {
            while (iterator.hasNext()) {
                Iterators.addUnique(collection, iterator.next());
            }
            C c = collection;
            return c;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    private static <T, C extends Collection<T>> void addUnique(C collection, T item) {
        if (!collection.add(item)) {
            throw new IllegalStateException("Encountered an already added item:" + item + " when adding items uniquely to a collection:" + collection);
        }
    }

    static <C extends Collection<T>, T> C addToCollectionUnique(Iterable<T> iterable, C collection) {
        return Iterators.addToCollectionUnique(iterable.iterator(), collection);
    }

    public static <T> Iterable<T> loop(Iterator<T> iterator) {
        return () -> iterator;
    }

    public static <T> long count(Iterator<T> iterator) {
        return Iterators.count(iterator, Predicates.alwaysTrue());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Iterator<T> iterator, Predicate<T> filter) {
        try {
            long result = 0L;
            while (iterator.hasNext()) {
                if (!filter.test(iterator.next())) continue;
                ++result;
            }
            long l = result;
            return l;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> Collection<T> asCollection(Iterator<T> iterable) {
        return Iterators.addToCollection(iterable, new ArrayList());
    }

    public static <T> List<T> asList(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new ArrayList());
    }

    public static <T, EX extends Exception> List<T> asList(RawIterator<T, EX> iterator) throws EX {
        try {
            ArrayList<T> out = new ArrayList<T>();
            while (iterator.hasNext()) {
                out.add(iterator.next());
            }
            ArrayList<T> arrayList = out;
            return arrayList;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> Set<T> asSet(Iterator<T> iterator) {
        return Iterators.addToCollection(iterator, new HashSet());
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    @SafeVarargs
    public static <T> Set<T> set(T ... items) {
        return Iterators.asSet(items);
    }

    @SafeVarargs
    public static <T> Set<T> asUniqueSet(T ... items) {
        HashSet set = new HashSet();
        for (T item : items) {
            Iterators.addUnique(set, item);
        }
        return set;
    }

    public static <T> Set<T> asUniqueSet(Iterator<T> iterator) {
        try {
            HashSet set = new HashSet();
            while (iterator.hasNext()) {
                Iterators.addUnique(set, iterator.next());
            }
            HashSet hashSet = set;
            return hashSet;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> SortedSet<T> asSortedSet(Comparator<T> comparator, T ... items) {
        TreeSet<T> set = new TreeSet<T>(comparator);
        Collections.addAll(set, items);
        return set;
    }

    static Iterator<Long> asIterator(final long ... array) {
        return new Iterator<Long>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public Long next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }
        };
    }

    public static Iterator<Integer> asIterator(final int ... array) {
        return new Iterator<Integer>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < array.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }
        };
    }

    @SafeVarargs
    private static <T> Iterator<T> asIterator(final int maxItems, final T ... array) {
        return new Iterator<T>(){
            int index;

            @Override
            public boolean hasNext() {
                return this.index < maxItems;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return array[this.index++];
            }
        };
    }

    public static <T> Iterator<T> iterator(final T item) {
        if (item == null) {
            return Collections.emptyIterator();
        }
        return new Iterator<T>(){
            T myItem;
            {
                this.myItem = item;
            }

            @Override
            public boolean hasNext() {
                return this.myItem != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object toReturn = this.myItem;
                this.myItem = null;
                return toReturn;
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(T ... items) {
        return Iterators.asIterator(items.length, items);
    }

    @SafeVarargs
    public static <T> Iterator<T> iterator(int maxItems, T ... items) {
        return Iterators.asIterator(maxItems, items);
    }

    public static <T> Iterator<T> appendTo(final Iterator<T> iterator, final T ... appended) {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return iterator.hasNext() || this.index < appended.length;
            }

            @Override
            public T next() {
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                if (this.index < appended.length) {
                    return appended[this.index++];
                }
                Iterators.tryCloseResource(iterator);
                throw new NoSuchElementException();
            }
        };
    }

    public static <T> Iterator<T> prependTo(final Iterator<T> iterator, final T ... prepended) {
        return new Iterator<T>(){
            private int index;

            @Override
            public boolean hasNext() {
                return this.index < prepended.length || iterator.hasNext();
            }

            @Override
            public T next() {
                if (this.index < prepended.length) {
                    return prepended[this.index++];
                }
                if (iterator.hasNext()) {
                    return iterator.next();
                }
                Iterators.tryCloseResource(iterator);
                throw new NoSuchElementException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String toString(Iterator<T> iterator, Function<T, String> toString, int maxItems) {
        try {
            StringJoiner joiner = new StringJoiner(", ", "[", "]");
            while (iterator.hasNext() && maxItems > 0) {
                String str = toString.apply(iterator.next());
                joiner.add(str);
                --maxItems;
            }
            if (iterator.hasNext()) {
                joiner.add("...");
            }
            String string = joiner.toString();
            return string;
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static <T> ResourceIterator<T> emptyResourceIterator() {
        return EmptyResourceIterator.EMPTY_RESOURCE_ITERATOR;
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterable<T> iterable) {
        if (iterable instanceof ResourceIterable) {
            return ((ResourceIterable)iterable).iterator();
        }
        return Iterators.asResourceIterator(iterable.iterator());
    }

    public static <T> ResourceIterator<T> asResourceIterator(Iterator<T> iterator) {
        if (iterator instanceof ResourceIterator) {
            return (ResourceIterator)iterator;
        }
        return new WrappingResourceIterator<T>(iterator);
    }

    public static <T> ResourceIterator<T> resourceIterator(final Iterator<T> iterator, final Resource resource) {
        return new PrefetchingResourceIterator<T>(){

            public void close() {
                resource.close();
            }

            @Override
            protected T fetchNextOrNull() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    @SafeVarargs
    public static <T> T[] array(T ... items) {
        return items;
    }

    public static <X> Iterator<X> filter(Predicate<? super X> specification, Iterator<X> i) {
        return new FilterIterable.FilterIterator<X>(i, specification);
    }

    public static <FROM, TO> Iterator<TO> map(Function<? super FROM, ? extends TO> function, Iterator<FROM> from) {
        return new MapIterable.MapIterator<FROM, TO>(from, function);
    }

    public static <FROM, TO, EX extends Exception> RawIterator<TO, EX> map(ThrowingFunction<? super FROM, ? extends TO, EX> function, RawIterator<FROM, EX> from) {
        return new RawMapIterator<FROM, TO, EX>(from, function);
    }

    public static <T, EX extends Exception> RawIterator<T, EX> asRawIterator(final Iterator<T> iter) {
        return new RawIterator<T, EX>(){

            @Override
            public boolean hasNext() {
                return iter.hasNext();
            }

            @Override
            public T next() {
                return iter.next();
            }
        };
    }

    public static <T, EX extends Exception> RawIterator<T, EX> asRawIterator(Stream<T> stream) {
        return Iterators.asRawIterator(stream.iterator());
    }

    @SafeVarargs
    public static <T> Iterator<T> concat(Iterator<? extends T> ... iterators) {
        return Iterators.concat(Arrays.asList(iterators).iterator());
    }

    public static <T> ResourceIterator<T> concatResourceIterators(Iterator<ResourceIterator<T>> iterators) {
        return new CombiningResourceIterator<T>(iterators);
    }

    public static <T> Iterator<T> concat(Iterator<Iterator<T>> iterators) {
        return new CombiningIterator<T>(iterators);
    }

    public static <T> PrefetchingIterator<T> prefetching(final Iterator<T> iterator) {
        return iterator instanceof PrefetchingIterator ? (PrefetchingIterator)iterator : new PrefetchingIterator<T>(){

            @Override
            protected T fetchNextOrNull() {
                return iterator.hasNext() ? (Object)iterator.next() : null;
            }
        };
    }

    public static <T> Stream<T> stream(Iterator<T> iterator) {
        return Iterators.stream(iterator, 0);
    }

    public static <T> Stream<T> stream(Iterator<T> iterator, int characteristics) {
        Objects.requireNonNull(iterator);
        Spliterator<T> spliterator = Spliterators.spliteratorUnknownSize(iterator, characteristics);
        Stream<T> stream = StreamSupport.stream(spliterator, false);
        if (iterator instanceof Resource) {
            Resource resource = (Resource)iterator;
            return (Stream)stream.onClose(() -> ((Resource)resource).close());
        }
        return stream;
    }

    public static <T> void forEachRemaining(Iterator<T> iterator, Consumer<? super T> consumer) {
        try {
            iterator.forEachRemaining(consumer);
        }
        finally {
            Iterators.tryCloseResource(iterator);
        }
    }

    public static void tryCloseResource(Iterator<?> iterator) {
        if (iterator instanceof Resource) {
            Resource closeable = (Resource)iterator;
            closeable.close();
        }
    }

    private static void tryCloseResource(RawIterator<?, ?> iterator) {
        if (iterator instanceof Resource) {
            Resource closeable = (Resource)iterator;
            closeable.close();
        }
    }

    private static class EmptyResourceIterator<E>
    implements ResourceIterator<E> {
        private static final ResourceIterator<Object> EMPTY_RESOURCE_ITERATOR = new EmptyResourceIterator<Object>();

        private EmptyResourceIterator() {
        }

        public void close() {
        }

        public boolean hasNext() {
            return false;
        }

        public E next() {
            throw new NoSuchElementException();
        }
    }
}

