/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.asm;

import org.nutz.repo.org.objectweb.asm.MethodVisitor;
import org.nutz.repo.org.objectweb.asm.Type;

abstract class NormalMethodAdapter {
    final String desc;
    final int access;
    final MethodVisitor mv;
    final Type[] argumentTypes;

    NormalMethodAdapter(MethodVisitor mv, String desc, int access) {
        this.mv = mv;
        this.desc = desc;
        this.access = access;
        this.argumentTypes = Type.getArgumentTypes(this.desc);
    }

    abstract void visitCode();

    void loadArgs() {
        this.loadArgs(0, this.argumentTypes.length);
    }

    void loadArgs(int arg, int count) {
        int index = 1;
        int i = 0;
        while (i < count) {
            Type t = this.argumentTypes[arg + i];
            this.loadInsn(t, index);
            index += t.getSize();
            ++i;
        }
    }

    void loadInsn(Type type, int index) {
        this.mv.visitVarInsn(type.getOpcode(21), index);
    }
}

