/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.interceptor;

import org.nutz.aop.AopCallback;
import org.nutz.aop.InterceptorChain;
import org.nutz.aop.MethodInterceptor;
import org.nutz.lang.Lang;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class LoggingMethodInterceptor
implements MethodInterceptor {
    private static final Log LOG = Logs.get();
    protected boolean logBeforeInvoke = LOG.isDebugEnabled();
    protected boolean logAfterInvoke = LOG.isDebugEnabled();
    protected boolean logWhenException = LOG.isDebugEnabled();
    protected boolean logWhenError = LOG.isDebugEnabled();

    public void setLogEvent(boolean logBeforeInvoke, boolean logAfterInvoke, boolean logWhenException, boolean logWhenError) {
        this.logBeforeInvoke = logBeforeInvoke && LOG.isDebugEnabled();
        this.logAfterInvoke = logAfterInvoke && LOG.isDebugEnabled();
        this.logWhenException = logWhenException && LOG.isDebugEnabled();
        this.logWhenError = logWhenError && LOG.isDebugEnabled();
    }

    @Override
    public void filter(InterceptorChain chain) {
        try {
            try {
                if (this.logBeforeInvoke) {
                    LOG.debugf("[beforeInvoke] Obj = %s , Method = %s , args = %s", LoggingMethodInterceptor.toString(chain.getCallingObj()), chain.getCallingMethod(), LoggingMethodInterceptor.str(chain.getArgs()));
                }
                chain.doChain();
            }
            catch (Exception e) {
                if (this.logWhenException) {
                    LOG.debugf("[whenException] Obj = %s , Throwable = %s , Method = %s , args = %s", LoggingMethodInterceptor.toString(chain.getCallingObj()), e, chain.getCallingMethod(), LoggingMethodInterceptor.str(chain.getArgs()));
                }
                throw Lang.wrapThrow(e);
            }
            catch (Throwable e) {
                if (this.logWhenError) {
                    LOG.debugf("[whenError] Obj = %s , Throwable = %s , Method = %s , args = %s", LoggingMethodInterceptor.toString(chain.getCallingObj()), e, chain.getCallingMethod(), LoggingMethodInterceptor.str(chain.getArgs()));
                }
                throw Lang.wrapThrow(e);
            }
        }
        catch (Throwable throwable) {
            if (this.logAfterInvoke) {
                LOG.debugf("[afterInvoke] Obj = %s , Return = %s , Method = %s , args = %s", LoggingMethodInterceptor.toString(chain.getCallingObj()), chain.getReturn(), chain.getCallingMethod(), LoggingMethodInterceptor.str(chain.getArgs()));
            }
            throw throwable;
        }
        if (this.logAfterInvoke) {
            LOG.debugf("[afterInvoke] Obj = %s , Return = %s , Method = %s , args = %s", LoggingMethodInterceptor.toString(chain.getCallingObj()), chain.getReturn(), chain.getCallingMethod(), LoggingMethodInterceptor.str(chain.getArgs()));
        }
    }

    protected static final String toString(Object object) {
        if (object != null && object instanceof AopCallback) {
            return "[" + object.getClass().getName() + "]";
        }
        String str = String.valueOf(object);
        if (str.length() > 100) {
            str = String.valueOf(str.substring(0, 97)) + "...";
        }
        return str;
    }

    protected static final String str(Object ... args) {
        if (args == null || args.length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            sb.append(LoggingMethodInterceptor.toString(object)).append(",");
            ++n2;
        }
        sb.replace(sb.length() - 1, sb.length(), "]");
        return sb.toString();
    }
}

