/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.aop.matcher;

import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.nutz.aop.MethodMatcher;
import org.nutz.lang.Maths;

public class RegexMethodMatcher
implements MethodMatcher {
    private Pattern active;
    private Pattern ignore;
    private int mods;

    public RegexMethodMatcher(String active) {
        this(active, null);
    }

    public RegexMethodMatcher(String active, String ignore) {
        this(active, ignore, 5);
    }

    public RegexMethodMatcher(String active, String ignore, int mods) {
        if (active != null) {
            this.active = Pattern.compile(active);
        }
        if (ignore != null) {
            this.ignore = Pattern.compile(ignore);
        }
        this.mods = mods;
    }

    @Override
    public boolean match(Method method) {
        int mod = method.getModifiers();
        String name = method.getName();
        if (this.ignore != null && this.ignore.matcher(name).find()) {
            return false;
        }
        if (this.active != null && !this.active.matcher(name).find()) {
            return false;
        }
        if (this.mods <= 0) {
            return true;
        }
        if (mod == 0) {
            mod |= 0x80;
        }
        return Maths.isMask(mod, this.mods);
    }
}

