/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.castor;

import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.nutz.castor.FailToCastObjectException;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;

public abstract class Castor<FROM, TO> {
    protected Class<?> fromClass;
    protected Class<?> toClass;

    protected Castor() {
        Class<?> myType = this.getClass();
        Class<?> mySuper = myType.getSuperclass();
        Type[] myParams = Mirror.getTypeParams(myType);
        Type[] superParams = Mirror.getTypeParams(mySuper);
        if (superParams != null && superParams.length == 2) {
            Class[] args = new Class[2];
            int n = 0;
            int i = 0;
            while (i < superParams.length) {
                args[i] = superParams[i] instanceof Class ? (Class)superParams[i] : (Class)myParams[n++];
                ++i;
            }
            this.fromClass = args[0];
            this.toClass = args[1];
        } else {
            this.fromClass = (Class)myParams[0];
            this.toClass = (Class)myParams[1];
        }
    }

    public Class<?> getFromClass() {
        return this.fromClass;
    }

    public Class<?> getToClass() {
        return this.toClass;
    }

    public abstract TO cast(FROM var1, Class<?> var2, String ... var3) throws FailToCastObjectException;

    protected static Collection<?> createCollection(Object src, Class<?> toType) throws FailToCastObjectException {
        AbstractCollection coll;
        block6: {
            coll = null;
            try {
                coll = (ArrayList)toType.newInstance();
            }
            catch (Exception e) {
                if (Modifier.isAbstract(toType.getModifiers())) {
                    if (toType.isAssignableFrom(ArrayList.class)) {
                        coll = new ArrayList(Array.getLength(src));
                    } else if (toType.isAssignableFrom(HashSet.class)) {
                        coll = new HashSet();
                    }
                }
                if (coll != null) break block6;
                throw new FailToCastObjectException(String.format("Castors don't know how to implement '%s'", toType.getName()), Lang.unwrapThrow(e));
            }
        }
        return coll;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Castor)) {
            return false;
        }
        Castor castor = (Castor)obj;
        return this.toString().equals(castor.toString());
    }

    public String toString() {
        return String.valueOf(this.fromClass.getName()) + "2" + this.toClass.getName();
    }

    public static final String key(Class<?> fromClass, Class<?> toClass) {
        return String.valueOf(fromClass.getName()) + "2" + toClass.getName();
    }
}

