/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.castor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.nutz.castor.Castor;
import org.nutz.castor.DefaultCastorSetting;
import org.nutz.castor.FailToCastObjectException;
import org.nutz.castor.castor.Array2Array;
import org.nutz.castor.castor.Array2Collection;
import org.nutz.castor.castor.Array2Map;
import org.nutz.castor.castor.Array2Object;
import org.nutz.castor.castor.Array2String;
import org.nutz.castor.castor.Boolean2Number;
import org.nutz.castor.castor.Boolean2String;
import org.nutz.castor.castor.Calendar2Datetime;
import org.nutz.castor.castor.Calendar2Long;
import org.nutz.castor.castor.Calendar2String;
import org.nutz.castor.castor.Calendar2Timestamp;
import org.nutz.castor.castor.Character2Number;
import org.nutz.castor.castor.Class2Mirror;
import org.nutz.castor.castor.Class2String;
import org.nutz.castor.castor.Collection2Array;
import org.nutz.castor.castor.Collection2Collection;
import org.nutz.castor.castor.Collection2Map;
import org.nutz.castor.castor.Collection2Object;
import org.nutz.castor.castor.Collection2String;
import org.nutz.castor.castor.DateTimeCastor;
import org.nutz.castor.castor.Datetime2Calendar;
import org.nutz.castor.castor.Datetime2Long;
import org.nutz.castor.castor.Datetime2SqlDate;
import org.nutz.castor.castor.Datetime2SqlTime;
import org.nutz.castor.castor.Datetime2String;
import org.nutz.castor.castor.Datetime2Timpestamp;
import org.nutz.castor.castor.Enum2Number;
import org.nutz.castor.castor.Enum2String;
import org.nutz.castor.castor.File2String;
import org.nutz.castor.castor.Map2Array;
import org.nutz.castor.castor.Map2Collection;
import org.nutz.castor.castor.Map2Enum;
import org.nutz.castor.castor.Map2Object;
import org.nutz.castor.castor.Map2String;
import org.nutz.castor.castor.Mirror2Class;
import org.nutz.castor.castor.Mirror2String;
import org.nutz.castor.castor.Number2Boolean;
import org.nutz.castor.castor.Number2Byte;
import org.nutz.castor.castor.Number2Calendar;
import org.nutz.castor.castor.Number2Char;
import org.nutz.castor.castor.Number2Character;
import org.nutz.castor.castor.Number2Datetime;
import org.nutz.castor.castor.Number2Double;
import org.nutz.castor.castor.Number2Enum;
import org.nutz.castor.castor.Number2Float;
import org.nutz.castor.castor.Number2Integer;
import org.nutz.castor.castor.Number2Long;
import org.nutz.castor.castor.Number2Short;
import org.nutz.castor.castor.Number2String;
import org.nutz.castor.castor.Number2Timestamp;
import org.nutz.castor.castor.Object2Class;
import org.nutz.castor.castor.Object2List;
import org.nutz.castor.castor.Object2Map;
import org.nutz.castor.castor.Object2Mirror;
import org.nutz.castor.castor.Object2Object;
import org.nutz.castor.castor.Object2String;
import org.nutz.castor.castor.SqlDate2String;
import org.nutz.castor.castor.SqlDate2Timestamp;
import org.nutz.castor.castor.SqlTime2String;
import org.nutz.castor.castor.SqlTime2Timestamp;
import org.nutz.castor.castor.String2Array;
import org.nutz.castor.castor.String2BigDecimal;
import org.nutz.castor.castor.String2Boolean;
import org.nutz.castor.castor.String2Byte;
import org.nutz.castor.castor.String2Calendar;
import org.nutz.castor.castor.String2Character;
import org.nutz.castor.castor.String2Class;
import org.nutz.castor.castor.String2Collection;
import org.nutz.castor.castor.String2Datetime;
import org.nutz.castor.castor.String2Double;
import org.nutz.castor.castor.String2Email;
import org.nutz.castor.castor.String2Enum;
import org.nutz.castor.castor.String2File;
import org.nutz.castor.castor.String2Float;
import org.nutz.castor.castor.String2Integer;
import org.nutz.castor.castor.String2Long;
import org.nutz.castor.castor.String2Map;
import org.nutz.castor.castor.String2Mirror;
import org.nutz.castor.castor.String2Number;
import org.nutz.castor.castor.String2Object;
import org.nutz.castor.castor.String2Pattern;
import org.nutz.castor.castor.String2Set;
import org.nutz.castor.castor.String2Short;
import org.nutz.castor.castor.String2SqlDate;
import org.nutz.castor.castor.String2SqlTime;
import org.nutz.castor.castor.String2TimeZone;
import org.nutz.castor.castor.String2Timestamp;
import org.nutz.castor.castor.TimeZone2String;
import org.nutz.castor.castor.Timestamp2Calendar;
import org.nutz.castor.castor.Timestamp2Datetime;
import org.nutz.castor.castor.Timestamp2Long;
import org.nutz.castor.castor.Timestamp2SqlDate;
import org.nutz.castor.castor.Timestamp2SqlTime;
import org.nutz.castor.castor.Timestamp2String;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.TypeExtractor;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Castors {
    private static final Log log = Logs.get();
    private TypeExtractor extractor;
    private Object setting;
    private HashMap<Class<?>, Method> settingMap;
    private Map<String, Castor<?, ?>> map = new ConcurrentHashMap();
    private static List<Class<?>> defaultCastorList = new ArrayList(120);
    private static Castors one;

    static {
        defaultCastorList.add(Array2Array.class);
        defaultCastorList.add(Array2Collection.class);
        defaultCastorList.add(Array2Map.class);
        defaultCastorList.add(Array2Object.class);
        defaultCastorList.add(Array2String.class);
        defaultCastorList.add(Boolean2Number.class);
        defaultCastorList.add(Boolean2String.class);
        defaultCastorList.add(Calendar2Datetime.class);
        defaultCastorList.add(Calendar2Long.class);
        defaultCastorList.add(Calendar2String.class);
        defaultCastorList.add(Calendar2Timestamp.class);
        defaultCastorList.add(Character2Number.class);
        defaultCastorList.add(Class2Mirror.class);
        defaultCastorList.add(Class2String.class);
        defaultCastorList.add(Collection2Array.class);
        defaultCastorList.add(Collection2Collection.class);
        defaultCastorList.add(Collection2Map.class);
        defaultCastorList.add(Collection2Object.class);
        defaultCastorList.add(Collection2String.class);
        defaultCastorList.add(DateTimeCastor.class);
        defaultCastorList.add(Datetime2Calendar.class);
        defaultCastorList.add(Datetime2Long.class);
        defaultCastorList.add(Datetime2SqlDate.class);
        defaultCastorList.add(Datetime2SqlTime.class);
        defaultCastorList.add(Datetime2String.class);
        defaultCastorList.add(Datetime2Timpestamp.class);
        defaultCastorList.add(Enum2Number.class);
        defaultCastorList.add(Enum2String.class);
        defaultCastorList.add(File2String.class);
        defaultCastorList.add(Map2Array.class);
        defaultCastorList.add(Map2Collection.class);
        defaultCastorList.add(Map2Enum.class);
        defaultCastorList.add(Map2Object.class);
        defaultCastorList.add(Map2String.class);
        defaultCastorList.add(Mirror2Class.class);
        defaultCastorList.add(Mirror2String.class);
        defaultCastorList.add(Number2Boolean.class);
        defaultCastorList.add(Number2Byte.class);
        defaultCastorList.add(Number2Calendar.class);
        defaultCastorList.add(Number2Char.class);
        defaultCastorList.add(Number2Character.class);
        defaultCastorList.add(Number2Datetime.class);
        defaultCastorList.add(Number2Double.class);
        defaultCastorList.add(Number2Enum.class);
        defaultCastorList.add(Number2Float.class);
        defaultCastorList.add(Number2Integer.class);
        defaultCastorList.add(Number2Long.class);
        defaultCastorList.add(Number2Short.class);
        defaultCastorList.add(Number2String.class);
        defaultCastorList.add(Number2Timestamp.class);
        defaultCastorList.add(Object2Class.class);
        defaultCastorList.add(Object2List.class);
        defaultCastorList.add(Object2Map.class);
        defaultCastorList.add(Object2Mirror.class);
        defaultCastorList.add(Object2Object.class);
        defaultCastorList.add(Object2String.class);
        defaultCastorList.add(SqlDate2String.class);
        defaultCastorList.add(SqlDate2Timestamp.class);
        defaultCastorList.add(SqlTime2String.class);
        defaultCastorList.add(SqlTime2Timestamp.class);
        defaultCastorList.add(String2Array.class);
        defaultCastorList.add(String2BigDecimal.class);
        defaultCastorList.add(String2Boolean.class);
        defaultCastorList.add(String2Byte.class);
        defaultCastorList.add(String2Calendar.class);
        defaultCastorList.add(String2Character.class);
        defaultCastorList.add(String2Class.class);
        defaultCastorList.add(String2Collection.class);
        defaultCastorList.add(String2Datetime.class);
        defaultCastorList.add(String2Double.class);
        defaultCastorList.add(String2Email.class);
        defaultCastorList.add(String2Enum.class);
        defaultCastorList.add(String2File.class);
        defaultCastorList.add(String2Float.class);
        defaultCastorList.add(String2Integer.class);
        defaultCastorList.add(String2Long.class);
        defaultCastorList.add(String2Map.class);
        defaultCastorList.add(String2Mirror.class);
        defaultCastorList.add(String2Number.class);
        defaultCastorList.add(String2Object.class);
        defaultCastorList.add(String2Pattern.class);
        defaultCastorList.add(String2Set.class);
        defaultCastorList.add(String2Short.class);
        defaultCastorList.add(String2SqlDate.class);
        defaultCastorList.add(String2SqlTime.class);
        defaultCastorList.add(String2TimeZone.class);
        defaultCastorList.add(String2Timestamp.class);
        defaultCastorList.add(TimeZone2String.class);
        defaultCastorList.add(Timestamp2Calendar.class);
        defaultCastorList.add(Timestamp2Datetime.class);
        defaultCastorList.add(Timestamp2Long.class);
        defaultCastorList.add(Timestamp2SqlDate.class);
        defaultCastorList.add(Timestamp2SqlTime.class);
        defaultCastorList.add(Timestamp2String.class);
        one = new Castors();
    }

    public static Castors me() {
        return one;
    }

    public static Castors create() {
        return new Castors();
    }

    public synchronized Castors setSetting(Object obj) {
        if (obj != null) {
            this.setting = obj;
            this.reload();
        }
        return this;
    }

    public synchronized Castors setTypeExtractor(TypeExtractor te) {
        this.extractor = te;
        return this;
    }

    private Castors() {
        this.setting = new DefaultCastorSetting();
        this.reload();
    }

    private void reload() {
        this.buildSettingMap();
        ArrayList classes = new ArrayList();
        classes.addAll(defaultCastorList);
        for (Class clazz : classes) {
            try {
                if (Modifier.isAbstract(clazz.getModifiers()) || !Castor.class.isAssignableFrom(clazz)) continue;
                this.fillMap(clazz, this.settingMap, false);
            }
            catch (Throwable e) {
                if (!log.isWarnEnabled()) continue;
                log.warnf("Fail to create castor [%s] because: %s", clazz, e.getMessage());
            }
        }
        if (log.isDebugEnabled()) {
            log.debugf("Using %s castor for Castors", this.map.size());
        }
    }

    private void buildSettingMap() throws SecurityException {
        this.settingMap = new HashMap();
        Method[] methodArray = this.setting.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m1 = methodArray[n2];
            Class<?>[] pts = m1.getParameterTypes();
            if (pts.length == 1 && Castor.class.isAssignableFrom(pts[0])) {
                this.settingMap.put(pts[0], m1);
            }
            ++n2;
        }
    }

    public void addCastor(Class<?> klass) {
        try {
            this.fillMap(klass, this.settingMap, true);
        }
        catch (Throwable e) {
            throw Lang.wrapThrow(Lang.unwrapThrow(e));
        }
    }

    private void fillMap(Class<?> klass, HashMap<Class<?>, Method> settingMap, boolean replace) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Castor<?, ?> castor = (Castor<?, ?>)klass.newInstance();
        if (!this.map.containsKey(castor.toString()) || replace) {
            this.map.put(castor.toString(), castor);
        } else {
            castor = this.map.get(castor.toString());
        }
        Method m = settingMap.get(castor.getClass());
        if (m == null) {
            for (Map.Entry<Class<?>, Method> entry : settingMap.entrySet()) {
                Class<?> cc = entry.getKey();
                if (!cc.isAssignableFrom(klass)) continue;
                m = settingMap.get(cc);
                break;
            }
        }
        if (m != null) {
            m.invoke(this.setting, castor);
        }
    }

    public <F, T> T cast(Object src, Class<F> fromType, Class<T> toType, String ... args) throws FailToCastObjectException {
        if (src == null) {
            if (toType.isPrimitive()) {
                if (toType == Integer.TYPE) {
                    return (T)Integer.valueOf(0);
                }
                if (toType == Long.TYPE) {
                    return (T)Long.valueOf(0L);
                }
                if (toType == Byte.TYPE) {
                    return (T)Byte.valueOf((byte)0);
                }
                if (toType == Short.TYPE) {
                    return (T)Short.valueOf((short)0);
                }
                if (toType == Float.TYPE) {
                    return (T)Float.valueOf(0.0f);
                }
                if (toType == Double.TYPE) {
                    return (T)Double.valueOf(0.0);
                }
                if (toType == Boolean.TYPE) {
                    return (T)Boolean.FALSE;
                }
                if (toType == Character.TYPE) {
                    return (T)Character.valueOf(' ');
                }
                throw Lang.impossible();
            }
            return null;
        }
        if (fromType == toType || toType == null || fromType == null) {
            return (T)src;
        }
        if (fromType.getName().equals(toType.getName())) {
            return (T)src;
        }
        if (toType.isAssignableFrom(fromType)) {
            return (T)src;
        }
        Mirror<F> from = Mirror.me(fromType, this.extractor);
        Castor<F, T> c = this.find(from, toType);
        if (c == null) {
            throw new FailToCastObjectException(String.format("Can not find castor for '%s'=>'%s' in (%d) because:\n%s", fromType.getName(), toType.getName(), this.map.size(), "Fail to find matched castor"));
        }
        if (Object2Object.class.getName().equals(c.getClass().getName()) && from.canCastToDirectly(toType)) {
            return (T)src;
        }
        try {
            return c.cast(src, toType, args);
        }
        catch (FailToCastObjectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FailToCastObjectException(String.format("Fail to cast from <%s> to <%s> for {%s} because:\n%s:%s", fromType.getName(), toType.getName(), src, e.getClass().getSimpleName(), e.getMessage()), Lang.unwrapThrow(e));
        }
    }

    public <F, T> Castor<F, T> find(Class<F> from, Class<T> to) {
        return this.find(Mirror.me(from), to);
    }

    private <F, T> Castor<F, T> find(Mirror<F> from, Class<T> toType) {
        String key = Castor.key(from.getType(), toType);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        Mirror<T> to = Mirror.me(toType, this.extractor);
        Class<?>[] fets = from.extractTypes();
        Class<?>[] tets = to.extractTypes();
        Class<?>[] classArray = fets;
        int n = fets.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> ft = classArray[n2];
            Class<?>[] classArray2 = tets;
            int n3 = tets.length;
            int n4 = 0;
            while (n4 < n3) {
                Class<?> tt = classArray2[n4];
                if (this.map.containsKey(Castor.key(ft, tt))) {
                    Castor<?, ?> castor = this.map.get(Castor.key(ft, tt));
                    this.map.put(key, castor);
                    return castor;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public <T> T castTo(Object src, Class<T> toType) throws FailToCastObjectException {
        return this.cast(src, src == null ? null : src.getClass(), toType, new String[0]);
    }

    public boolean canCast(Class<?> fromType, Class<?> toType) {
        if (Mirror.me(fromType).canCastToDirectly(toType)) {
            return true;
        }
        Castor<?, ?> castor = this.find(fromType, toType);
        return !(castor instanceof Object2Object);
    }

    public String castToString(Object src) {
        try {
            return this.castTo(src, String.class);
        }
        catch (FailToCastObjectException failToCastObjectException) {
            return String.valueOf(src);
        }
    }
}

