/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.conf;

import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.el.opt.custom.CustomMake;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mapl.Mapl;
import org.nutz.resource.NutResource;
import org.nutz.resource.Scans;
import org.nutz.resource.impl.FileResource;

public class NutConf {
    private static final Log log = Logs.get();
    private static final String DEFAULT_CONFIG = "org/nutz/conf/NutzDefaultConfig.js";
    private Map<String, Object> map = new HashMap<String, Object>();
    private static volatile NutConf conf;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NutConf me() {
        if (conf != null) return conf;
        Class<NutConf> clazz = NutConf.class;
        synchronized (NutConf.class) {
            if (conf != null) return conf;
            conf = new NutConf();
            // ** MonitorExit[var0] (shouldn't be in output)
            return conf;
        }
    }

    private NutConf() {
        this.loadResource(DEFAULT_CONFIG);
    }

    public static void load(String ... paths) {
        NutConf.me().loadResource(paths);
        CustomMake.init();
    }

    private void loadResource(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            List<NutResource> resources;
            String path = stringArray[n2];
            if (path.endsWith(".js")) {
                File f = Files.findFile(path);
                resources = new ArrayList<NutResource>();
                resources.add(new FileResource(f));
            } else {
                resources = Scans.me().scan(path, "\\.js$");
            }
            for (NutResource nr : resources) {
                try {
                    Object obj = Json.fromJson(nr.getReader());
                    if (!(obj instanceof Map)) continue;
                    Map m = (Map)obj;
                    this.map = (Map)Mapl.merge(this.map, m);
                    for (Object key : m.keySet()) {
                        if (!key.equals("include")) continue;
                        this.map.remove("include");
                        List include = (List)m.get("include");
                        this.loadResource(include.toArray(new String[include.size()]));
                    }
                }
                catch (Throwable e) {
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Fail to load config?! for " + nr.getName(), e);
                }
            }
            ++n2;
        }
    }

    public static Object get(String key, Type type) {
        return NutConf.me().getItem(key, type);
    }

    public static Object get(String key) {
        return NutConf.me().getItem(key, null);
    }

    private Object getItem(String key, Type type) {
        if (this.map == null) {
            return null;
        }
        if (type == null) {
            return this.map.get(key);
        }
        return Mapl.maplistToObj(this.map.get(key), type);
    }

    public static void clear() {
        conf = null;
    }
}

