/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.entity;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.nutz.castor.Castors;
import org.nutz.dao.Chain;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Lang;

public class Record
implements Map<String, Object>,
Serializable {
    private static final long serialVersionUID = 4614645901639942051L;
    private Map<String, Object> map = new LinkedHashMap<String, Object>();
    private Map<String, Integer> sqlTypeMap = new HashMap<String, Integer>();

    public static Record create(ResultSet rs) {
        String name = null;
        int i = 0;
        try {
            Record re = new Record();
            ResultSetMetaData meta = rs.getMetaData();
            int count = meta.getColumnCount();
            i = 1;
            while (i <= count) {
                name = meta.getColumnLabel(i);
                switch (meta.getColumnType(i)) {
                    case 93: {
                        re.set(name, rs.getTimestamp(i));
                        break;
                    }
                    case 91: {
                        re.set(name, rs.getTimestamp(i));
                        break;
                    }
                    case 2005: {
                        re.set(name, rs.getString(i));
                        break;
                    }
                    default: {
                        re.set(name, rs.getObject(i));
                    }
                }
                re.setSqlType(name, meta.getColumnType(i));
                ++i;
            }
            return re;
        }
        catch (SQLException e) {
            if (name != null) {
                throw new DaoException(String.format("Column Name=%s, index=%d", name, i), e);
            }
            throw new DaoException(e);
        }
    }

    public Record set(String name, Object value) {
        this.map.put(name.toLowerCase(), value);
        return this;
    }

    public Object remove(String name) {
        return this.map.remove(name.toLowerCase());
    }

    public int getColumnCount() {
        return this.map.size();
    }

    public Set<String> getColumnNames() {
        return this.map.keySet();
    }

    public int getInt(String name) {
        Object val;
        block3: {
            try {
                val = this.get(name);
                if (val != null) break block3;
                return -1;
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return Castors.me().castTo(val, Integer.TYPE);
    }

    public String getString(String name) {
        Object val = this.get(name);
        if (val == null) {
            return null;
        }
        return Castors.me().castToString(val);
    }

    public Timestamp getTimestamp(String name) {
        Object val = this.get(name);
        if (val == null) {
            return null;
        }
        return Castors.me().castTo(val, Timestamp.class);
    }

    public String toJson(JsonFormat format) {
        return Json.toJson(this.map, format);
    }

    public String toString() {
        return Json.toJson(this.map);
    }

    public <T> T toPojo(Class<T> type) {
        return Lang.map2Object(this.map, type);
    }

    public <T> T toEntity(Entity<T> en) {
        return en.getObject(this);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key.toString().toLowerCase());
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object out) {
        return this.map.equals(out);
    }

    @Override
    public Object get(Object name) {
        if (name == null) {
            return null;
        }
        return this.map.get(name.toString().toLowerCase());
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public Object put(String name, Object value) {
        return this.map.put(name.toLowerCase(), value);
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> out) {
        for (Map.Entry<? extends String, ? extends Object> entry : out.entrySet()) {
            this.map.put(entry.getKey().toLowerCase(), entry.getValue());
        }
    }

    @Override
    public Object remove(Object key) {
        return this.map.remove(key.toString().toLowerCase());
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<Object> values() {
        return this.map.values();
    }

    public Chain toChain() {
        return Chain.from(this.map);
    }

    public int getSqlType(String name) {
        return this.sqlTypeMap.get(name.toLowerCase());
    }

    protected void setSqlType(String name, int value) {
        this.sqlTypeMap.put(name.toLowerCase(), value);
    }
}

