/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.nutz.dao.DB;
import org.nutz.dao.DaoException;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Comment;
import org.nutz.dao.entity.annotation.EL;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Index;
import org.nutz.dao.entity.annotation.Many;
import org.nutz.dao.entity.annotation.ManyMany;
import org.nutz.dao.entity.annotation.Name;
import org.nutz.dao.entity.annotation.One;
import org.nutz.dao.entity.annotation.PK;
import org.nutz.dao.entity.annotation.SQL;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.dao.entity.annotation.TableIndexes;
import org.nutz.dao.entity.annotation.TableMeta;
import org.nutz.dao.entity.annotation.View;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.FieldMacroInfo;
import org.nutz.dao.impl.entity.NutEntity;
import org.nutz.dao.impl.entity.NutEntityIndex;
import org.nutz.dao.impl.entity.field.ManyLinkField;
import org.nutz.dao.impl.entity.field.ManyManyLinkField;
import org.nutz.dao.impl.entity.field.NutMappingField;
import org.nutz.dao.impl.entity.field.OneLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.dao.impl.entity.info.MappingInfo;
import org.nutz.dao.impl.entity.info.TableInfo;
import org.nutz.dao.impl.entity.info._Infos;
import org.nutz.dao.impl.entity.macro.ElFieldMacro;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.jdbc.JdbcExpert;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.sql.Pojo;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.segment.CharSegment;
import org.nutz.lang.util.NutMap;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.trans.Trans;

public class AnnotationEntityMaker
implements EntityMaker {
    private static final Log log = Logs.get();
    private DataSource datasource;
    private JdbcExpert expert;
    private EntityHolder holder;

    public AnnotationEntityMaker(DataSource datasource, JdbcExpert expert, EntityHolder holder) {
        this.datasource = datasource;
        this.expert = expert;
        this.holder = holder;
    }

    @Override
    public <T> Entity<T> make(Class<T> type) {
        boolean hasTableComment;
        NutEntity<T> en = this._createNutEntity(type);
        TableInfo ti = this._createTableInfo(type);
        if (this.expert.getConf() != null) {
            for (String key : this.expert.getConf().keySet()) {
                en.getMetas().put(key, this.expert.getConf().get(key));
            }
        }
        if (ti.annMeta != null) {
            NutMap map = Lang.map(ti.annMeta.value());
            for (Map.Entry entry : map.entrySet()) {
                en.getMetas().put((String)entry.getKey(), entry.getValue().toString());
            }
        }
        String tableName = ti.annTable == null ? Strings.lowerWord(type.getSimpleName(), '_') : ti.annTable.value();
        String viewName = ti.annView == null ? tableName : ti.annView.value();
        en.setTableName(tableName);
        en.setViewName(viewName);
        boolean bl = hasTableComment = ti.tableComment != null;
        String tableComment = hasTableComment ? (Strings.isBlank(ti.tableComment.value()) ? type.getName() : ti.tableComment.value()) : null;
        en.setHasTableComment(hasTableComment);
        en.setTableComment(tableComment);
        boolean shouldUseColumn = false;
        boolean hasColumnComment = false;
        Field[] fieldArray = en.getMirror().getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (shouldUseColumn && hasColumnComment) break;
            if (!shouldUseColumn && field.getAnnotation(Column.class) != null) {
                shouldUseColumn = true;
            }
            if (!hasColumnComment && field.getAnnotation(Comment.class) != null) {
                hasColumnComment = true;
            }
            ++n2;
        }
        en.setHasColumnComment(hasColumnComment);
        ArrayList<MappingInfo> infos = new ArrayList<MappingInfo>();
        ArrayList<LinkInfo> ones = new ArrayList<LinkInfo>();
        ArrayList<LinkInfo> manys = new ArrayList<LinkInfo>();
        ArrayList<LinkInfo> manymanys = new ArrayList<LinkInfo>();
        AccessibleObject[] accessibleObjectArray = en.getMirror().getFields();
        int n3 = accessibleObjectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            Field field = accessibleObjectArray[n4];
            if (field.getAnnotation(One.class) != null) {
                ones.add(_Infos.createLinkInfo(field));
            } else if (field.getAnnotation(Many.class) != null) {
                manys.add(_Infos.createLinkInfo(field));
            } else if (field.getAnnotation(ManyMany.class) != null) {
                manymanys.add(_Infos.createLinkInfo(field));
            } else if (!(Modifier.isTransient(field.getModifiers()) && field.getAnnotation(Column.class) == null || shouldUseColumn && field.getAnnotation(Column.class) == null && field.getAnnotation(Id.class) == null && field.getAnnotation(Name.class) == null)) {
                infos.add(_Infos.createMappingInfo(ti.annPK, field));
            }
            ++n4;
        }
        accessibleObjectArray = en.getType().getMethods();
        n3 = accessibleObjectArray.length;
        n4 = 0;
        while (n4 < n3) {
            AccessibleObject method = accessibleObjectArray[n4];
            if (((Method)method).getAnnotation(One.class) != null) {
                ones.add(_Infos.createLinkInfo((Method)method));
            } else if (((Method)method).getAnnotation(Many.class) != null) {
                manys.add(_Infos.createLinkInfo((Method)method));
            } else if (((Method)method).getAnnotation(ManyMany.class) != null) {
                manymanys.add(_Infos.createLinkInfo((Method)method));
            } else if (((Method)method).getAnnotation(Column.class) != null || ((Method)method).getAnnotation(Id.class) != null || ((Method)method).getAnnotation(Name.class) != null) {
                infos.add(_Infos.createMapingInfo(ti.annPK, (Method)method));
            }
            ++n4;
        }
        ArrayList<MappingInfo> tmp = new ArrayList<MappingInfo>(infos.size());
        MappingInfo miId = null;
        MappingInfo miName = null;
        for (MappingInfo mi : infos) {
            if (mi.annId != null) {
                if (miId != null) {
                    throw new DaoException("Allows only a single @Id ! " + type);
                }
                miId = mi;
                continue;
            }
            if (mi.annName != null) {
                if (miName != null) {
                    throw new DaoException("Allows only a single @Name ! " + type);
                }
                miName = mi;
                continue;
            }
            tmp.add(mi);
        }
        if (miName != null) {
            tmp.add(0, miName);
        }
        if (miId != null) {
            tmp.add(0, miId);
        }
        if ((infos = tmp).isEmpty()) {
            throw Lang.makeThrow(IllegalArgumentException.class, "Pojo(%s) without any Mapping Field!!", type);
        }
        for (MappingInfo info : infos) {
            NutMappingField ef = new NutMappingField(en);
            this._evalMappingField(ef, info);
            en.addMappingField(ef);
        }
        this.holder.set(en);
        for (LinkInfo li : ones) {
            en.addLinkField(new OneLinkField(en, this.holder, li));
        }
        for (LinkInfo li : manys) {
            en.addLinkField(new ManyLinkField(en, this.holder, li));
        }
        for (LinkInfo li : manymanys) {
            en.addLinkField(new ManyManyLinkField(en, this.holder, li));
        }
        en.checkCompositeFields(ti.annPK == null ? null : ti.annPK.value());
        if (this.datasource != null && this.expert != null) {
            this._checkupEntityFieldsWithDatabase(en);
        }
        this._evalFieldMacro(en, infos);
        if (ti.annIndexes != null) {
            this._evalEntityIndexes(en, ti.annIndexes);
        }
        return en;
    }

    private TableInfo _createTableInfo(Class<?> type) {
        TableInfo info = new TableInfo();
        Mirror<Class<?>> mirror = Mirror.me(type);
        info.annTable = mirror.getAnnotation(Table.class);
        info.annView = mirror.getAnnotation(View.class);
        info.annMeta = mirror.getAnnotation(TableMeta.class);
        info.annPK = mirror.getAnnotation(PK.class);
        info.annIndexes = mirror.getAnnotation(TableIndexes.class);
        info.tableComment = mirror.getAnnotation(Comment.class);
        return info;
    }

    private List<FieldMacroInfo> _annToFieldMacroInfo(EL[] els, SQL[] sqls) {
        int n;
        int n2;
        Annotation[] annotationArray;
        LinkedList<FieldMacroInfo> mis = new LinkedList<FieldMacroInfo>();
        if (els.length > 0) {
            annotationArray = els;
            n2 = els.length;
            n = 0;
            while (n < n2) {
                Annotation el = annotationArray[n];
                mis.add(new FieldMacroInfo((EL)el));
                ++n;
            }
        }
        if (sqls.length > 0) {
            annotationArray = sqls;
            n2 = sqls.length;
            n = 0;
            while (n < n2) {
                Annotation sql = annotationArray[n];
                mis.add(new FieldMacroInfo((SQL)sql));
                ++n;
            }
        }
        return mis;
    }

    private void _evalMappingField(NutMappingField ef, MappingInfo info) {
        ef.setName(info.name);
        ef.setType(info.fieldType);
        if (info.annColumn == null || Strings.isBlank(info.annColumn.value())) {
            ef.setColumnName(info.name);
        } else {
            ef.setColumnName(info.annColumn.value());
        }
        boolean hasColumnComment = info.columnComment != null;
        ef.setHasColumnComment(hasColumnComment);
        if (hasColumnComment) {
            String comment = info.columnComment.value();
            if (Strings.isBlank(comment)) {
                ef.setColumnComment(info.name);
            } else {
                ef.setColumnComment(comment);
            }
        }
        if (info.annId != null) {
            ef.setAsId();
            if (info.annId.auto() && info.annPrev == null) {
                ef.setAsAutoIncreasement();
            }
        }
        if (info.annName != null) {
            ef.setAsName();
            ef.setCasesensitive(info.annName.casesensitive());
        }
        if (ef.isId() && ef.isName()) {
            throw Lang.makeThrow("Field '%s'(%s) can not be @Id and @Name at same time!", ef.getName(), ef.getEntity().getType().getName());
        }
        if (info.annPK != null) {
            if (info.annPK.value().length == 1) {
                if (Lang.contains(info.annPK.value(), info.name)) {
                    if (ef.getTypeMirror().isIntLike()) {
                        ef.setAsId();
                    } else {
                        ef.setAsName();
                    }
                }
            } else if (Lang.contains(info.annPK.value(), info.name)) {
                ef.setAsCompositePk();
            }
        }
        if (info.annDefault != null) {
            ef.setDefaultValue(new CharSegment(info.annDefault.value()));
        }
        if (info.annReadonly != null) {
            ef.setAsReadonly();
        }
        if (info.annDefine != null) {
            ef.setColumnType(info.annDefine.type());
            ef.setWidth(info.annDefine.width());
            ef.setPrecision(info.annDefine.precision());
            if (info.annDefine.unsigned()) {
                ef.setAsUnsigned();
            }
            if (info.annDefine.notNull()) {
                ef.setAsNotNull();
            }
            if (info.annDefine.auto() && !ef.isId()) {
                ef.setAsAutoIncreasement();
            }
            if (info.annDefine.customType().length() > 0) {
                ef.setCustomDbType(info.annDefine.customType());
            }
            ef.setInsert(info.annDefine.insert());
            ef.setUpdate(info.annDefine.update());
        } else {
            Jdbcs.guessEntityFieldColumnType(ef);
        }
        ef.setAdaptor(this.expert.getAdaptor(ef));
        ef.setInjecting(info.injecting);
        ef.setEjecting(info.ejecting);
    }

    private void _evalFieldMacro(Entity<?> en, List<MappingInfo> infos) {
        for (MappingInfo info : infos) {
            if (info.annPrev != null) {
                en.addBeforeInsertMacro(this.__macro(en.getField(info.name), this._annToFieldMacroInfo(info.annPrev.els(), info.annPrev.value())));
            }
            if (info.annNext != null && en.addAfterInsertMacro(this.__macro(en.getField(info.name), this._annToFieldMacroInfo(info.annNext.els(), info.annNext.value()))) || info.annId == null || !info.annId.auto()) continue;
            if (this.expert != null && !this.expert.isSupportAutoIncrement()) {
                log.debug("Database don't support auto-increment. If insert fail, pls add trigger in database or using @Prev in Pojo");
            }
            en.addAfterInsertMacro(this.expert.fetchPojoId(en, en.getField(info.name)));
        }
    }

    private Pojo __macro(MappingField ef, List<FieldMacroInfo> infoList) {
        FieldMacroInfo theInfo = null;
        for (FieldMacroInfo info : infoList) {
            if (DB.OTHER == info.getDb()) {
                theInfo = info;
                continue;
            }
            if (!info.getDb().name().equalsIgnoreCase(this.expert.getDatabaseType())) continue;
            theInfo = info;
            break;
        }
        if (theInfo != null) {
            if (theInfo.isEl()) {
                return new ElFieldMacro(ef, theInfo.getValue());
            }
            return new SqlFieldMacro(ef, theInfo.getValue());
        }
        return null;
    }

    private void _evalEntityIndexes(NutEntity<?> en, TableIndexes indexes) {
        Index[] indexArray = indexes.value();
        int n = indexArray.length;
        int n2 = 0;
        while (n2 < n) {
            Index idx = indexArray[n2];
            NutEntityIndex index = new NutEntityIndex();
            index.setUnique(idx.unique());
            index.setName(idx.name());
            String[] stringArray = idx.fields();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String indexName = stringArray[n4];
                MappingField ef = en.getField(indexName);
                if (ef == null) {
                    throw Lang.makeThrow("Fail to find field '%s' in '%s' by @Index(%s:%s)", indexName, en.getType().getName(), index.getName(), Lang.concat(idx.fields()));
                }
                index.addField(ef);
                ++n4;
            }
            en.addIndex(index);
            ++n2;
        }
    }

    private void _checkupEntityFieldsWithDatabase(NutEntity<?> en) {
        block6: {
            Connection conn = null;
            try {
                try {
                    conn = Trans.getConnectionAuto(this.datasource);
                    this.expert.setupEntityField(conn, en);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.debugf("Fail to setup '%s'(%s) by DB, because: (%s)'%s'", en.getType().getName(), en.getTableName(), e.getClass().getName(), e.getMessage());
                    }
                    Trans.closeConnectionAuto(conn);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                Trans.closeConnectionAuto(conn);
                throw throwable;
            }
            Trans.closeConnectionAuto(conn);
        }
    }

    protected <T> NutEntity<T> _createNutEntity(Class<T> type) {
        return new NutEntity<T>(type);
    }
}

