/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkType;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.field.AbstractLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Strings;

public class ManyLinkField
extends AbstractLinkField {
    public ManyLinkField(Entity<?> entity, EntityHolder holder, LinkInfo info) {
        super(entity, holder, info);
        this.targetType = info.many.target();
        this.mapKey = info.many.key();
        Entity<?> ta = this.getLinkedEntity();
        if (Strings.isBlank(info.many.field())) {
            this.hostField = null;
            this.linkedField = null;
        } else {
            this.linkedField = ta.getField(info.many.field());
            if (this.linkedField == null) {
                throw Lang.makeThrow("Invalid @Many(field=%s) '%s' : %s<=>%s", info.many.field(), this.getName(), this.getEntity().getType(), ta.getType());
            }
            this.hostField = Strings.isBlank(this.mapKey) ? (this.linkedField.getTypeMirror().isIntLike() ? this.getEntity().getIdField() : this.getEntity().getNameField()) : this.getEntity().getField(this.mapKey);
            if (this.hostField == null) {
                throw Lang.makeThrow("Fail to find hostField for @Many(field=%s) '%s' : %s<=>%s", info.many.field(), this.getName(), this.getEntity().getType(), ta.getType());
            }
        }
    }

    @Override
    public Condition createCondition(Object host) {
        return this.linkedField == null ? null : Cnd.where(this.linkedField.getName(), "=", this.hostField.getValue(host));
    }

    @Override
    public void updateLinkedField(Object obj, Object linked) {
        if (this.hostField != null) {
            final Object v = this.hostField.getValue(obj);
            Lang.each(linked, new Each<Object>(){

                @Override
                public void invoke(int i, Object ele, int length) throws ExitLoop, LoopException {
                    ManyLinkField.this.linkedField.setValue(ele, v);
                }
            });
        }
    }

    @Override
    public MappingField getHostField() {
        return this.hostField;
    }

    @Override
    public MappingField getLinkedField() {
        return this.linkedField;
    }

    @Override
    public void saveLinkedField(Object obj, Object linked) {
    }

    @Override
    public LinkType getLinkType() {
        return LinkType.MANY;
    }
}

