/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.entity.field;

import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.LinkType;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.entity.EntityName;
import org.nutz.dao.impl.entity.field.AbstractLinkField;
import org.nutz.dao.impl.entity.info.LinkInfo;
import org.nutz.dao.util.cri.SimpleCriteria;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;

public class ManyManyLinkField
extends AbstractLinkField {
    private EntityName relationTableName;
    private String fromColumnName;
    private String toColumnName;

    public ManyManyLinkField(Entity<?> host, EntityHolder holder, LinkInfo info) {
        super(host, holder, info);
        this.targetType = info.manymany.target();
        this.mapKey = info.manymany.key();
        this.relationTableName = EntityName.create(info.manymany.relation());
        String[] ss = Strings.splitIgnoreBlank(info.manymany.from(), ":");
        this.fromColumnName = ss[0];
        String fromField = ss.length > 1 ? ss[1] : null;
        ss = Strings.splitIgnoreBlank(info.manymany.to(), ":");
        this.toColumnName = ss[0];
        String toField = ss.length > 1 ? ss[1] : null;
        Entity<?> ta = this.getLinkedEntity();
        if (fromField != null) {
            this.hostField = host.getField(fromField);
        }
        if (toField != null) {
            this.linkedField = ta.getField(toField);
        }
        if (this.hostField != null && this.linkedField == null) {
            this.linkedField = ta.getPkType() == PkType.ID ? ta.getIdField() : ta.getNameField();
        } else if (this.hostField == null && this.linkedField != null) {
            this.hostField = host.getPkType() == PkType.ID ? host.getIdField() : host.getNameField();
        } else if (host.getIdField() != null && ta.getIdField() != null) {
            this.hostField = host.getIdField();
            this.linkedField = ta.getIdField();
        } else if (host.getIdField() != null && ta.getNameField() != null) {
            this.hostField = host.getIdField();
            this.linkedField = ta.getNameField();
        } else if (host.getNameField() != null && ta.getIdField() != null) {
            this.hostField = host.getNameField();
            this.linkedField = ta.getIdField();
        } else if (host.getNameField() != null && ta.getNameField() != null) {
            this.hostField = host.getNameField();
            this.linkedField = ta.getNameField();
        }
        if (this.hostField == null || this.linkedField == null) {
            throw Lang.makeThrow("Invalid @ManyMany in '%s'(%s): lack @Id or @Name", info.name, host.getType().getName());
        }
    }

    @Override
    public Condition createCondition(Object host) {
        SimpleCriteria cri = Cnd.cri();
        cri.where().andInBySql(this.linkedField.getColumnName(), "SELECT %s FROM %s WHERE %s=%s", this.toColumnName, this.getRelationName(), this.fromColumnName, Sqls.formatFieldValue(this.hostField.getValue(host)));
        return cri;
    }

    @Override
    public void updateLinkedField(Object obj, Object linked) {
    }

    @Override
    public void saveLinkedField(Object obj, Object linked) {
    }

    @Override
    public LinkType getLinkType() {
        return LinkType.MANYMANY;
    }

    public String getRelationName() {
        return this.relationTableName.value();
    }

    public String getFromColumnName() {
        return this.fromColumnName;
    }

    public String getToColumnName() {
        return this.toColumnName;
    }

    public String[] getLinkedPkNames() {
        String[] re = new String[]{this.hostField.getName(), this.linkedField.getName()};
        return re;
    }
}

