/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.ext;

import javax.sql.DataSource;
import org.nutz.aop.AopCallback;
import org.nutz.dao.SqlManager;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.EntityMaker;
import org.nutz.dao.impl.EntityHolder;
import org.nutz.dao.impl.NutDao;
import org.nutz.dao.impl.ext.LazyAnnotationEntityMaker;

public class LazyNutDao
extends NutDao {
    private boolean cycle = false;

    @Override
    public void setDataSource(DataSource ds) {
        super.setDataSource(ds);
        this.holder = new EntityHolder(this){

            @Override
            public <T> Entity<T> getEntity(Class<T> classOfT) {
                if (AopCallback.class.isAssignableFrom(classOfT)) {
                    return this.getEntity(classOfT.getSuperclass());
                }
                return super.getEntity(classOfT);
            }
        };
        this.holder.maker = this.createEntityMaker();
    }

    @Override
    protected EntityMaker createEntityMaker() {
        if (this.cycle) {
            return new LazyAnnotationEntityMaker(this.dataSource, this.expert, this.holder, this);
        }
        return new LazyAnnotationEntityMaker(this.dataSource, this.expert, this.holder, new NutDao(this.dataSource));
    }

    public LazyNutDao() {
    }

    public LazyNutDao(DataSource dataSource) {
        super(dataSource);
    }

    public LazyNutDao(DataSource dataSource, boolean cycle) {
        super(dataSource);
        this.setCycle(cycle);
    }

    public LazyNutDao(DataSource dataSource, SqlManager sqlManager) {
        super(dataSource, sqlManager);
    }

    public void setCycle(boolean cycle) {
        if (this.cycle != cycle) {
            this.cycle = cycle;
            this.holder.maker = this.createEntityMaker();
        }
    }
}

