/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.jdbc.gbase;

import java.util.List;
import org.nutz.dao.DB;
import org.nutz.dao.Dao;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.entity.MappingField;
import org.nutz.dao.entity.PkType;
import org.nutz.dao.entity.annotation.ColType;
import org.nutz.dao.impl.entity.macro.SqlFieldMacro;
import org.nutz.dao.impl.jdbc.AbstractJdbcExpert;
import org.nutz.dao.jdbc.JdbcExpertConfigFile;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Pojo;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.util.Pojos;

public class GBaseJdbcExpert
extends AbstractJdbcExpert {
    private static final String META_ENGINE = "gbase-engine";
    private static final String META_CHARSET = "gbase-charset";

    public GBaseJdbcExpert(JdbcExpertConfigFile conf) {
        super(conf);
    }

    @Override
    public String getDatabaseType() {
        return DB.GBASE.name();
    }

    @Override
    public void formatQuery(Pojo pojo) {
        Pager pager = pojo.getContext().getPager();
        if (pager != null && pager.getPageNumber() > 0) {
            pojo.append(Pojos.Items.wrapf(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    public void formatQuery(Sql sql) {
        Pager pager = sql.getContext().getPager();
        if (pager != null && pager.getPageNumber() > 0) {
            sql.setSourceSql(String.valueOf(sql.getSourceSql()) + String.format(" LIMIT %d, %d", pager.getOffset(), pager.getPageSize()));
        }
    }

    @Override
    protected String evalFieldType(MappingField mf) {
        if (mf.getCustomDbType() != null) {
            return mf.getCustomDbType();
        }
        if (mf.getColumnType() == ColType.INT) {
            int width = mf.getWidth();
            if (width <= 0) {
                return "INT(32)";
            }
            if (width <= 4) {
                return "TINYINT(" + width * 4 + ")";
            }
            if (width <= 8) {
                return "INT(" + width * 4 + ")";
            }
            return "BIGINT(" + width * 4 + ")";
        }
        if (mf.getColumnType() == ColType.BINARY) {
            return "MediumBlob";
        }
        return super.evalFieldType(mf);
    }

    @Override
    public boolean createEntity(Dao dao, Entity<?> en) {
        StringBuilder sb = new StringBuilder("CREATE TABLE " + en.getTableName() + "(");
        for (MappingField mf : en.getMappingFields()) {
            sb.append('\n').append(mf.getColumnName());
            sb.append(' ').append(this.evalFieldType(mf));
            if (mf.isName() && en.getPkType() != PkType.NAME) {
                sb.append(" UNIQUE NOT NULL");
            } else {
                if (mf.isUnsigned()) {
                    sb.append(" UNSIGNED");
                }
                if (mf.isNotNull()) {
                    sb.append(" NOT NULL");
                } else if (mf.getColumnType() == ColType.TIMESTAMP) {
                    sb.append(" NULL");
                }
                if (mf.isAutoIncreasement()) {
                    sb.append(" AUTO_INCREMENT");
                }
                if (mf.getColumnType() == ColType.TIMESTAMP) {
                    if (mf.hasDefaultValue()) {
                        sb.append(" ").append(this.getDefaultValue(mf));
                    } else if (mf.isNotNull()) {
                        sb.append(" DEFAULT 0");
                    } else {
                        sb.append(" DEFAULT NULL");
                    }
                } else if (mf.hasDefaultValue()) {
                    sb.append(" DEFAULT '").append(this.getDefaultValue(mf)).append("'");
                }
            }
            if (mf.hasColumnComment()) {
                sb.append(" COMMENT '").append(mf.getColumnComment()).append("'");
            }
            sb.append(',');
        }
        List<MappingField> pks = en.getPks();
        if (!pks.isEmpty()) {
            sb.append('\n');
            sb.append("PRIMARY KEY (");
            for (MappingField pk : pks) {
                sb.append(pk.getColumnName()).append(',');
            }
            sb.setCharAt(sb.length() - 1, ')');
            sb.append("\n ");
        }
        sb.setCharAt(sb.length() - 1, ')');
        if (en.hasMeta(META_ENGINE)) {
            sb.append(" ENGINE=" + en.getMeta(META_ENGINE));
        }
        if (en.hasMeta(META_CHARSET)) {
            sb.append(" CHARSET=" + en.getMeta(META_CHARSET));
        } else {
            sb.append(" CHARSET=utf8");
        }
        if (en.hasTableComment()) {
            sb.append(" COMMENT='").append(en.getTableComment()).append("'");
        }
        dao.execute(Sqls.create(sb.toString()));
        dao.execute(this.createIndexs(en).toArray(new Sql[0]));
        this.createRelation(dao, en);
        return true;
    }

    @Override
    protected String createResultSetMetaSql(Entity<?> en) {
        return "SELECT * FROM " + en.getViewName() + " LIMIT 1";
    }

    @Override
    public Pojo fetchPojoId(Entity<?> en, MappingField idField) {
        String autoSql = "SELECT @@@@IDENTITY";
        SqlFieldMacro autoInfo = new SqlFieldMacro(idField, autoSql);
        autoInfo.setEntity(en);
        return autoInfo;
    }
}

