/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import org.nutz.dao.Condition;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.impl.sql.NutStatement;
import org.nutz.dao.impl.sql.SimpleVarSet;
import org.nutz.dao.impl.sql.SqlLiteral;
import org.nutz.dao.jdbc.Jdbcs;
import org.nutz.dao.jdbc.ValueAdaptor;
import org.nutz.dao.pager.Pager;
import org.nutz.dao.sql.Sql;
import org.nutz.dao.sql.SqlCallback;
import org.nutz.dao.sql.VarIndex;
import org.nutz.dao.sql.VarSet;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;

public class NutSql
extends NutStatement
implements Sql {
    SqlLiteral literal;
    private VarSet vars = new SimpleVarSet();
    private List<VarSet> rows = new LinkedList<VarSet>();
    private VarSet lastRow;
    private SqlCallback callback;
    private ValueAdaptor[] adaptors;
    private ValueAdaptor[] clientAdaptors;

    private NutSql() {
        this.addBatch();
    }

    public NutSql(String sql) {
        this();
        this.literal = new SqlLiteral().valueOf(sql);
        this.setSqlType(this.literal.getType());
        this.adaptors = new ValueAdaptor[this.literal.getParamIndexes().getOrders().size()];
        this.clientAdaptors = new ValueAdaptor[this.adaptors.length];
    }

    private NutSql(SqlLiteral literal, SqlCallback callback) {
        this();
        this.literal = literal;
        this.setSqlType(this.literal.getType());
        this.callback = callback;
        this.adaptors = new ValueAdaptor[literal.getParamIndexes().getOrders().size()];
        this.clientAdaptors = new ValueAdaptor[this.adaptors.length];
    }

    @Override
    public Sql setEntity(Entity<?> en) {
        return (Sql)super.setEntity(en);
    }

    @Override
    public ValueAdaptor[] getAdaptors() {
        int i = 0;
        while (i < this.adaptors.length) {
            if (this.clientAdaptors[i] != null) {
                this.adaptors[i] = this.clientAdaptors[i];
            } else if (this.adaptors[i] == null) {
                String name = this.literal.getParamIndexes().getOrderName(i);
                int[] is = this.literal.getParamIndexes().getOrderIndex(name);
                Object value = null;
                for (VarSet row : this.rows) {
                    value = row.get(name);
                    if (value != null) break;
                }
                if (value != null) {
                    ValueAdaptor vab = Jdbcs.getAdaptor(Mirror.me(value));
                    int[] nArray = is;
                    int n = is.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int x = nArray[n2];
                        this.adaptors[x] = vab;
                        ++n2;
                    }
                } else {
                    this.adaptors[i] = Jdbcs.Adaptor.asNull;
                }
            }
            ++i;
        }
        return this.adaptors;
    }

    @Override
    public void setValueAdaptor(String name, ValueAdaptor adaptor) {
        int[] is = this.literal.getParamIndexes().getOrderIndex(name);
        if (is != null) {
            int[] nArray = is;
            int n = is.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                this.adaptors[i] = adaptor;
                ++n2;
            }
        }
    }

    @Override
    public Object[][] getParamMatrix() {
        if (this.rows.size() > 0) {
            VarSet vs = this.rows.get(this.rows.size() - 1);
            while (vs != null) {
                if (vs.keys().size() != 0) break;
                this.rows.remove(vs);
                vs = null;
                if (this.rows.size() <= 0) continue;
                vs = this.rows.get(this.rows.size() - 1);
            }
        }
        Object[][] re = new Object[this.rows.size()][this.adaptors.length];
        int i = 0;
        for (VarSet row : this.rows) {
            Object[] cols = re[i++];
            for (String name : this.literal.getParamIndexes().names()) {
                int[] is;
                Object value = row.get(name);
                int[] nArray = is = this.literal.getParamIndexes().getOrderIndex(name);
                int n = is.length;
                int n2 = 0;
                while (n2 < n) {
                    int x = nArray[n2];
                    cols[x] = value;
                    ++n2;
                }
            }
        }
        return re;
    }

    @Override
    public String toPreparedStatement() {
        String[] ss = this._createSqlElements();
        VarIndex vIndex = this.literal.getParamIndexes();
        for (String name : vIndex.names()) {
            int[] is;
            int[] nArray = is = vIndex.indexesOf(name);
            int n = is.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                ss[i] = "?";
                ++n2;
            }
        }
        return Lang.concat(ss).toString();
    }

    private String[] _createSqlElements() {
        String[] ss = this.literal.stack.cloneChain();
        VarIndex vIndex = this.literal.getVarIndexes();
        VarSet vs = this.vars;
        for (String name : vIndex.names()) {
            int[] is = vIndex.indexesOf(name);
            Object obj = vs.get(name);
            int[] nArray = is;
            int n = is.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                ss[i] = obj == null ? "" : obj.toString();
                ++n2;
            }
        }
        return ss;
    }

    @Override
    public VarSet vars() {
        return this.vars;
    }

    @Override
    public VarSet params() {
        return this.lastRow;
    }

    @Override
    public VarIndex varIndex() {
        return this.literal.getVarIndexes();
    }

    @Override
    public VarIndex paramIndex() {
        return this.literal.getParamIndexes();
    }

    @Override
    public void addBatch() {
        this.lastRow = new SimpleVarSet();
        this.rows.add(this.lastRow);
    }

    @Override
    public void clearBatch() {
        this.rows.clear();
        this.addBatch();
    }

    @Override
    public Sql setCallback(SqlCallback callback) {
        this.callback = callback;
        return this;
    }

    @Override
    public Sql setCondition(Condition cnd) {
        this.vars().set("condition", cnd.toSql(this.getEntity()));
        return this;
    }

    @Override
    public Sql duplicate() {
        return new NutSql(this.literal, this.callback);
    }

    @Override
    public void onBefore(Connection conn) {
    }

    @Override
    public void onAfter(Connection conn, ResultSet rs) throws SQLException {
        if (this.callback != null) {
            this.getContext().setResult(this.callback.invoke(conn, rs, this));
        }
    }

    @Override
    public String toString() {
        return super.toStatement(this.getParamMatrix(), this.toPreparedStatement());
    }

    @Override
    public NutSql setPager(Pager pager) {
        this.getContext().setPager(pager);
        return this;
    }

    @Override
    public void setSourceSql(String sql) {
        if (this.literal != null) {
            this.literal.valueOf(sql);
        } else {
            this.literal = new SqlLiteral().valueOf(sql);
        }
    }

    @Override
    public String getSourceSql() {
        return this.literal.toString();
    }
}

