/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.impl.sql;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.util.List;
import org.nutz.castor.Castors;
import org.nutz.dao.Sqls;
import org.nutz.dao.entity.Entity;
import org.nutz.dao.sql.DaoStatement;
import org.nutz.dao.sql.SqlContext;
import org.nutz.dao.sql.SqlType;
import org.nutz.lang.Strings;

public abstract class NutStatement
implements DaoStatement {
    private Entity<?> entity;
    private SqlContext context = new SqlContext();
    private SqlType sqlType;

    @Override
    public boolean isSelect() {
        return SqlType.SELECT == this.sqlType;
    }

    @Override
    public boolean isUpdate() {
        return SqlType.UPDATE == this.sqlType;
    }

    @Override
    public boolean isDelete() {
        return SqlType.DELETE == this.sqlType;
    }

    @Override
    public boolean isInsert() {
        return SqlType.INSERT == this.sqlType;
    }

    @Override
    public boolean isCreate() {
        return SqlType.CREATE == this.sqlType;
    }

    @Override
    public boolean isDrop() {
        return SqlType.DROP == this.sqlType;
    }

    @Override
    public boolean isRun() {
        return SqlType.RUN == this.sqlType;
    }

    @Override
    public boolean isAlter() {
        return SqlType.ALTER == this.sqlType;
    }

    @Override
    public boolean isExec() {
        return SqlType.EXEC == this.sqlType;
    }

    @Override
    public boolean isCall() {
        return SqlType.CALL == this.sqlType;
    }

    @Override
    public boolean isOther() {
        return SqlType.OTHER == this.sqlType;
    }

    @Override
    public Entity<?> getEntity() {
        return this.entity;
    }

    @Override
    public DaoStatement setEntity(Entity<?> entity) {
        this.entity = entity;
        return this;
    }

    @Override
    public SqlContext getContext() {
        return this.context;
    }

    public void setContext(SqlContext context) {
        this.context = context;
    }

    @Override
    public SqlType getSqlType() {
        return this.sqlType;
    }

    public DaoStatement setSqlType(SqlType sqlType) {
        this.sqlType = sqlType;
        return this;
    }

    @Override
    public Object getResult() {
        return this.context.getResult();
    }

    @Override
    public <T> List<T> getList(Class<T> classOfT) {
        return (List)this.getResult();
    }

    @Override
    public <T> T getObject(Class<T> classOfT) {
        return Castors.me().castTo(this.getResult(), classOfT);
    }

    @Override
    public int getInt() {
        return this.getObject(Integer.class);
    }

    @Override
    public Number getNumber() {
        return this.getObject(Number.class);
    }

    @Override
    public String getString() {
        return this.getObject(String.class);
    }

    @Override
    public boolean getBoolean() {
        return this.getObject(Boolean.class);
    }

    @Override
    public int getUpdateCount() {
        return this.context.getUpdateCount();
    }

    @Override
    public String toString() {
        String sql = this.toPreparedStatement();
        StringBuilder sb = new StringBuilder(sql);
        Object[][] mtrx = this.getParamMatrix();
        if (mtrx != null && mtrx.length > 0 && mtrx[0].length > 0) {
            int[] maxes = new int[mtrx[0].length];
            String[][] sss = new String[mtrx.length][mtrx[0].length];
            int row = 0;
            while (row < mtrx.length) {
                int col = 0;
                while (col < mtrx[0].length) {
                    String s = this.param2String(mtrx[row][col]);
                    maxes[col] = Math.max(maxes[col], s.length());
                    sss[row][col] = s;
                    ++col;
                }
                ++row;
            }
            sb.append("\n    |");
            int i = 0;
            while (i < mtrx[0].length) {
                sb.append(' ');
                sb.append(Strings.alignRight("" + (i + 1), maxes[i], ' '));
                sb.append(" |");
                ++i;
            }
            sb.append("\n    |");
            i = 0;
            while (i < mtrx[0].length) {
                sb.append('-');
                sb.append(Strings.dup('-', maxes[i]));
                sb.append("-|");
                ++i;
            }
            int maxRow = mtrx.length > 50 ? 50 : mtrx.length;
            int row2 = 0;
            while (row2 < maxRow) {
                sb.append("\n    |");
                int col = 0;
                while (col < mtrx[0].length) {
                    sb.append(' ');
                    sb.append(Strings.alignLeft(sss[row2][col], maxes[col], ' '));
                    sb.append(" |");
                    ++col;
                }
                ++row2;
            }
            if (maxRow != mtrx.length) {
                sb.append("\n  .............................................").append("\n  !!!Too many data . Only display 50 lines , don't show the remaining record").append("\n  .............................................");
            }
            sb.append("\n  For example:> \"");
            sb.append(this.toExampleStatement(mtrx, sql));
            sb.append('\"');
        }
        return sb.toString();
    }

    protected String toExampleStatement(Object[][] mtrx, String sql) {
        StringBuilder sb = new StringBuilder();
        String[] ss = sql.split("[?]");
        int i = 0;
        if (mtrx.length > 0) {
            while (i < mtrx[0].length) {
                sb.append(ss[i]);
                Object obj = mtrx[0][i];
                if (obj != null) {
                    if (obj instanceof Blob) {
                        Blob blob = (Blob)obj;
                        obj = "Blob(" + blob.hashCode() + ")";
                    } else if (obj instanceof Clob) {
                        Clob clob = (Clob)obj;
                        obj = "Clob(" + clob.hashCode() + ")";
                    } else if (obj instanceof byte[] || obj instanceof char[]) {
                        if (Array.getLength(obj) > 10240) {
                            obj = "*BigData[len=" + Array.getLength(obj) + "]";
                        }
                    } else if (obj instanceof InputStream) {
                        try {
                            obj = "*InputStream[len=" + ((InputStream)obj).available() + "]";
                        }
                        catch (IOException iOException) {}
                    } else if (obj instanceof Reader) {
                        obj = "*Reader@" + obj.hashCode();
                    }
                }
                sb.append(Sqls.formatFieldValue(obj));
                ++i;
            }
        }
        if (i < ss.length) {
            sb.append(ss[i]);
        }
        return sb.toString();
    }

    protected String toStatement(Object[][] mtrx, String sql) {
        StringBuilder sb = new StringBuilder();
        String[] ss = sql.split("[?]");
        int i = 0;
        if (mtrx.length > 0) {
            while (i < mtrx[0].length) {
                sb.append(ss[i]);
                sb.append(Sqls.formatFieldValue(mtrx[0][i]));
                ++i;
            }
        }
        while (i < ss.length) {
            sb.append(ss[i]);
            ++i;
        }
        return sb.toString();
    }

    protected String param2String(Object obj) {
        if (obj == null) {
            return "NULL";
        }
        if (obj instanceof Blob) {
            Blob blob = (Blob)obj;
            return "Blob(" + blob.hashCode() + ")";
        }
        if (obj instanceof Clob) {
            Clob clob = (Clob)obj;
            return "Clob(" + clob.hashCode() + ")";
        }
        if (obj instanceof byte[] || obj instanceof char[]) {
            if (Array.getLength(obj) > 10240) {
                return "*BigData[len=" + Array.getLength(obj) + "]";
            }
        } else if (obj instanceof InputStream) {
            try {
                obj = "*InputStream[len=" + ((InputStream)obj).available() + "]";
            }
            catch (IOException iOException) {}
        } else if (obj instanceof Reader) {
            obj = "*Reader@" + obj.hashCode();
        }
        return Castors.me().castToString(obj);
    }
}

